/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.jrdf.graph.AbstractBlankNode;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.trippi.RDFUtil;
import org.trippi.TrippiException;

public class TripleMaker {
    private static GraphElementFactory m_factory = new RDFUtil();
    private static Map m_blankMap = null;
    private static Map m_aliasMap;

    public BlankNode createResource(int hashCode) {
        return new FreeBlankNode(hashCode);
    }

    public static Literal createLiteral(String lexicalValue) throws TrippiException {
        try {
            return m_factory.createLiteral(lexicalValue);
        }
        catch (GraphElementFactoryException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static Literal createLiteral(String lexicalValue, String languageType) throws TrippiException {
        try {
            return m_factory.createLiteral(lexicalValue, languageType);
        }
        catch (GraphElementFactoryException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static Literal createLiteral(String lexicalValue, URI datatypeURI) throws TrippiException {
        try {
            return m_factory.createLiteral(lexicalValue, datatypeURI);
        }
        catch (GraphElementFactoryException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static BlankNode createResource() throws TrippiException {
        try {
            return m_factory.createResource();
        }
        catch (GraphElementFactoryException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static URIReference createResource(String uri) throws TrippiException {
        try {
            return TripleMaker.createResource(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static URIReference createResource(URI uri) throws TrippiException {
        try {
            return m_factory.createResource(uri);
        }
        catch (GraphElementFactoryException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static URIReference createResource(URI uri, boolean validate) throws TrippiException {
        try {
            return m_factory.createResource(uri, validate);
        }
        catch (GraphElementFactoryException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static Triple create(SubjectNode subject, PredicateNode predicate, ObjectNode object) throws TrippiException {
        try {
            return m_factory.createTriple(subject, predicate, object);
        }
        catch (GraphElementFactoryException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static Triple create(String subject, String predicate, String object) throws TrippiException {
        return TripleMaker.create((SubjectNode)TripleMaker.createResource(subject), (PredicateNode)TripleMaker.createResource(predicate), (ObjectNode)TripleMaker.createResource(object));
    }

    public static Triple createPlain(String subject, String predicate, String object) throws TrippiException {
        return TripleMaker.create((SubjectNode)TripleMaker.createResource(subject), (PredicateNode)TripleMaker.createResource(predicate), (ObjectNode)TripleMaker.createLiteral(object));
    }

    public static Triple createLocal(String subject, String predicate, String object, String language) throws TrippiException {
        return TripleMaker.create((SubjectNode)TripleMaker.createResource(subject), (PredicateNode)TripleMaker.createResource(predicate), (ObjectNode)TripleMaker.createLiteral(object, language));
    }

    public static Triple createTyped(String subject, String predicate, String object, String datatype) throws TrippiException {
        try {
            return TripleMaker.create((SubjectNode)TripleMaker.createResource(subject), (PredicateNode)TripleMaker.createResource(predicate), (ObjectNode)TripleMaker.createLiteral(object, new URI(datatype)));
        }
        catch (URISyntaxException e) {
            throw new TrippiException(e.getMessage(), e);
        }
    }

    public static GraphElementFactory getGraphElementFactory() {
        return m_factory;
    }

    public static void setAliasMap(Map aliasMap) {
    }

    public static Node parse(String n) throws TrippiException {
        if (m_blankMap == null) {
            m_blankMap = new HashMap();
        }
        if (n.length() > 0) {
            char c = n.charAt(0);
            if (c == '<' && n.length() > 4) {
                try {
                    return TripleMaker.createResource(new URI(TripleMaker.stripFirstAndLast(n)));
                }
                catch (URISyntaxException e) {
                    throw new TrippiException(e.getMessage(), e);
                }
            }
            if ((c == '\"' || c == '\'') && n.length() > 1) {
                int i = n.lastIndexOf(c);
                if (i == n.length() - 1) {
                    return TripleMaker.createLiteral(TripleMaker.unescapeLiteral(TripleMaker.stripFirstAndLast(n)));
                }
                String uriString = n.substring(1, i);
                String qualifier = n.substring(i + 1);
                if (qualifier.startsWith("@")) {
                    return TripleMaker.createLiteral(uriString, qualifier.substring(1));
                }
                if (qualifier.startsWith("^^")) {
                    try {
                        return TripleMaker.createLiteral(uriString, new URI(qualifier.substring(2)));
                    }
                    catch (URISyntaxException e) {
                        throw new TrippiException(e.getMessage(), e);
                    }
                }
                throw new TrippiException("Malformed literal: " + n);
            }
            if (c == '_') {
                Node blankNode = (Node)m_blankMap.get(n);
                if (blankNode == null) {
                    blankNode = TripleMaker.createResource();
                    m_blankMap.put(n, blankNode);
                }
                return blankNode;
            }
        }
        throw new TrippiException("Could not parse as Node: " + n);
    }

    private static String stripFirstAndLast(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 1; i < s.length() - 1; ++i) {
            out.append(s.charAt(i));
        }
        return out.toString();
    }

    private static String escapeLiteral(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                out.append("\\\"");
                continue;
            }
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private static String unescapeLiteral(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                char d = s.charAt(++i);
                out.append(d);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String toString(Node node) {
        if (node == null) {
            return "null";
        }
        if (node instanceof URIReference) {
            URIReference n = (URIReference)node;
            return "<" + n.getURI().toString() + ">";
        }
        if (node instanceof BlankNode) {
            return "_node" + node.hashCode();
        }
        Literal n = (Literal)node;
        StringBuffer out = new StringBuffer();
        out.append("\"" + TripleMaker.escapeLiteral(n.getLexicalForm()) + "\"");
        if (n.getLanguage() != null && n.getLanguage().length() > 0) {
            out.append("@" + n.getLanguage());
        } else if (n.getDatatypeURI() != null) {
            out.append("^^" + n.getDatatypeURI().toString());
        }
        return out.toString();
    }

    public static String toString(Triple triple) {
        return TripleMaker.toString((Node)triple.getSubject()) + " " + TripleMaker.toString((Node)triple.getPredicate()) + " " + TripleMaker.toString((Node)triple.getObject());
    }

    public class FreeBlankNode
    extends AbstractBlankNode {
        private int m_hashCode;

        public FreeBlankNode(int hashCode) {
            this.m_hashCode = hashCode;
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }
}

