/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class DataStream {
    public static final ByteArrayInputStream EMPTY = new ByteArrayInputStream(new byte[0]);
    public static final int INLINE = 0;
    public static final int BASIS = 1;
    private File m_dataFile;
    private String m_mimeType;
    private final String m_id;
    private long m_size;
    protected boolean m_dirty = true;

    public DataStream(File tempDir, String id) {
        this.m_id = id;
        File m_dataFile = new File(tempDir, id);
        this.clearData();
    }

    public abstract int getType();

    public String getId() {
        return this.m_id;
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public void setMimeType(String mimeType) {
        this.m_dirty = true;
        this.m_mimeType = mimeType;
    }

    public long getSize() {
        return this.m_size;
    }

    public InputStream getData() throws IOException {
        if (this.m_size == 0L) {
            return EMPTY;
        }
        return new FileInputStream(this.m_dataFile);
    }

    public void setData(InputStream in) throws IOException {
        this.m_dirty = true;
        FileOutputStream out = new FileOutputStream(this.m_dataFile);
        byte[] buf = new byte[4096];
        int i = 0;
        this.m_size = 0L;
        while ((i = in.read(buf)) != -1) {
            this.m_size += (long)i;
            out.write(buf, 0, i);
        }
        in.close();
        out.close();
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void setClean() {
        this.m_dirty = false;
    }

    public void clearData() {
        this.m_size = 0L;
        this.m_dirty = true;
        this.m_dataFile.delete();
    }
}

