/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.actions;

import fedora.client.Administrator;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeObjectState
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Set<String> m_pids;
    private final String m_newState;

    public ChangeObjectState(String pid, String stateString) {
        super(stateString);
        this.m_pids = new HashSet<String>();
        this.m_pids.add(pid);
        this.m_newState = stateString.toUpperCase().substring(0, 1);
    }

    public ChangeObjectState(Set<String> pids, String stateString) {
        super(stateString);
        this.m_pids = pids;
        this.m_newState = stateString.toUpperCase().substring(0, 1);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String reason = JOptionPane.showInputDialog("Enter a log message for the state change.");
        if (reason != null) {
            try {
                for (String pid : this.m_pids) {
                    Administrator.APIM.modifyObject(pid, this.m_newState, null, null, reason);
                }
                String s = "s";
                if (this.m_pids.size() == 1) {
                    s = "";
                }
                JOptionPane.showMessageDialog(Administrator.getDesktop(), "Success.\nSet state of " + this.m_pids.size() + " object" + s + " to '" + this.m_newState + "'.");
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                Administrator.showErrorDialog(Administrator.getDesktop(), "Failure Changing State", message, e);
            }
        }
    }
}

