/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.actions;

import fedora.client.Administrator;
import fedora.client.objecteditor.ObjectEditorFrame;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ViewObject
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Set m_pids;
    private boolean m_prompt;

    public ViewObject() {
        super("Open Object...");
        this.m_prompt = true;
    }

    public ViewObject(String pid) {
        super("Open Object");
        this.m_pids = new HashSet();
        this.m_pids.add(pid);
    }

    public ViewObject(Set pids) {
        super("Open Objects");
        this.m_pids = pids;
    }

    public void actionPerformed(ActionEvent ae) {
        this.launch();
    }

    public void launch() {
        if (this.m_prompt) {
            String pid = JOptionPane.showInputDialog("Enter the PID of the object to open.");
            if (pid == null) {
                return;
            }
            this.m_pids = new HashSet();
            this.m_pids.add(pid);
        }
        for (String pid : this.m_pids) {
            try {
                ObjectEditorFrame editor = new ObjectEditorFrame(pid, 0);
                editor.setVisible(true);
                Administrator.getDesktop().add(editor);
                editor.setSelected(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Administrator.showErrorDialog(Administrator.getDesktop(), "Error Opening Object", e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
    }
}

