/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.Administrator;
import fedora.client.deployment.DatastreamInputPane;
import fedora.client.deployment.DocumentsPane;
import fedora.client.deployment.GeneralPane;
import fedora.client.deployment.MethodsPane;
import fedora.client.deployment.ServiceProfilePane;
import fedora.client.deployment.XMLFileChooserFilter;
import fedora.client.deployment.data.DCElement;
import fedora.client.deployment.data.DSInputRule;
import fedora.client.deployment.data.Datastream;
import fedora.client.deployment.data.Method;
import fedora.client.deployment.data.MethodParm;
import fedora.client.deployment.data.MethodProperties;
import fedora.client.deployment.data.ServiceDeploymentTemplate;
import fedora.client.deployment.data.ServiceSoftware;
import fedora.client.deployment.xml.DCGenerator;
import fedora.client.deployment.xml.DSInputSpecGenerator;
import fedora.client.deployment.xml.MethodMapGenerator;
import fedora.client.deployment.xml.ServiceDeploymentMETSSerializer;
import fedora.client.deployment.xml.ServiceProfileSerializer;
import fedora.client.deployment.xml.WSDLGenerator;
import fedora.client.utility.ingest.AutoIngestor;
import fedora.common.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ServiceDeploymentBuilder
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    protected JTabbedPane tabpane;
    protected ServiceDeploymentTemplate newSDep;
    private File s_lastDir = null;
    private String currentTabName;
    private int currentTabIndex;

    public static void main(String[] args) {
        try {
            if (args.length == 5) {
                JFrame frame = new JFrame("ServiceDeploymentBuilder Test");
                String protocol = args[0];
                String host = args[1];
                int port = new Integer(args[2]);
                String user = args[3];
                String pass = args[4];
                File dir = null;
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                frame.getContentPane().add((Component)new ServiceDeploymentBuilder(protocol, host, port, user, pass, dir), "Center");
                frame.setSize(700, 500);
                frame.setVisible(true);
            } else {
                System.out.println("ServiceDeploymentBuilder main method requires 5 arguments.");
                System.out.println("Usage: ServiceDeploymentBuilder protocol host port user pass");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public ServiceDeploymentBuilder(String protocol, String host, int port, String user, String pass, File dir) {
        super("Service Deployment Builder");
        this.s_lastDir = dir;
        this.setClosable(true);
        this.setMaximizable(true);
        this.setSize(700, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.newSDep = new ServiceDeploymentTemplate();
        this.tabpane = new JTabbedPane();
        this.tabpane.setBackground(Color.GRAY);
        this.tabpane.addTab("General", this.createGeneralPane());
        this.tabpane.addTab("Service Profile", this.createProfilePane());
        this.tabpane.addTab("Service Methods", this.createMethodsPane());
        this.tabpane.addTab("Datastream Input", this.createDSInputPane());
        this.tabpane.addTab("Documentation", this.createDocPane());
        JButton save = new JButton("Save");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceDeploymentBuilder.this.save();
            }
        });
        JButton ingest = new JButton("Ingest");
        ingest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceDeploymentBuilder.this.ingest();
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceDeploymentBuilder.this.showHelp();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceDeploymentBuilder.this.cancel();
            }
        });
        JPanel gbuttonPanel = new JPanel();
        gbuttonPanel.setBackground(Color.WHITE);
        gbuttonPanel.add(save);
        gbuttonPanel.add(ingest);
        gbuttonPanel.add(help);
        gbuttonPanel.add(cancel);
        this.getContentPane().add((Component)this.tabpane, "Center");
        this.getContentPane().add((Component)gbuttonPanel, "South");
        this.setListeners();
        this.setVisible(true);
    }

    private void setListeners() {
        this.tabpane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ServiceDeploymentBuilder.this.updateTemplate();
                ServiceDeploymentBuilder.this.currentTabIndex = ServiceDeploymentBuilder.this.tabpane.getSelectedIndex();
                ServiceDeploymentBuilder.this.currentTabName = ServiceDeploymentBuilder.this.tabpane.getTitleAt(ServiceDeploymentBuilder.this.currentTabIndex);
                if (ServiceDeploymentBuilder.this.currentTabIndex == 3) {
                    DatastreamInputPane dsip = (DatastreamInputPane)ServiceDeploymentBuilder.this.tabpane.getComponentAt(3);
                    dsip.renderDSBindingKeys(ServiceDeploymentBuilder.this.newSDep.getDSBindingKeys());
                }
            }
        });
    }

    public ServiceDeploymentTemplate getTemplate() {
        return this.newSDep;
    }

    public void save() {
        ServiceDeploymentMETSSerializer mets = this.savePanelInfo();
        File file = null;
        if (mets != null) {
            JFileChooser chooser = new JFileChooser(this.s_lastDir);
            chooser.setFileSelectionMode(0);
            XMLFileChooserFilter filter = new XMLFileChooserFilter();
            chooser.setFileFilter(filter);
            if (chooser.showSaveDialog(this.tabpane) == 0) {
                file = chooser.getSelectedFile();
                this.s_lastDir = file.getParentFile();
                String ext = filter.getExtension(file);
                if (ext == null || !ext.equalsIgnoreCase("xml")) {
                    file = new File(file.getPath() + ".xml");
                }
                try {
                    mets.writeMETSFile(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.assertTabPaneMsg("ServiceDeploymentBuilder: Error saving METS file for deployment: " + e.getMessage(), "ServiceDeploymentBuilder");
                }
            } else {
                this.assertTabPaneMsg("ServiceDeploymentBuilder: You did not specify a file to Save.", "ServiceDeploymentBuilder");
            }
        }
    }

    public void ingest() {
        InputStream in = null;
        String pid = null;
        ServiceDeploymentMETSSerializer mets = this.savePanelInfo();
        if (mets != null) {
            try {
                in = mets.writeMETSStream();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("ServiceDeploymentBuilder: Error saving METS to stream: " + e.getMessage(), "ServiceDeploymentBuilder");
            }
            try {
                AutoIngestor ingestor = new AutoIngestor(Administrator.APIA, Administrator.APIM);
                pid = ingestor.ingestAndCommit(in, Constants.METS_EXT1_1.uri, "ingest deployment object via ServiceDeploymentBuilder tool");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("ServiceDeploymentBuilder: error ingesting deployment object: " + e.getMessage(), null);
            }
            this.assertTabPaneMsg("New PID = " + pid, "Successful Ingest");
        }
    }

    public void showHelp() {
        if (this.currentTabIndex == 0) {
            this.showGeneralHelp();
        } else if (this.currentTabIndex == 1) {
            this.showProfileHelp();
        } else if (this.currentTabIndex == 2) {
            this.showMethodsHelp();
        } else if (this.currentTabIndex == 3) {
            this.showDatastreamsHelp();
        } else if (this.currentTabIndex == 4) {
            this.showDocumentsHelp();
        }
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    protected void updateTemplate() {
        Component[] tabs;
        for (Component element : tabs = this.tabpane.getComponents()) {
            if (element.getName().equalsIgnoreCase("GeneralTab")) {
                GeneralPane gp = (GeneralPane)element;
                if (gp.rb_chosen.equalsIgnoreCase("retainPID")) {
                    this.newSDep.setbObjPID(gp.getBObjectPID());
                } else {
                    this.newSDep.setbObjPID(null);
                }
                this.newSDep.setSDefContractPID(gp.getSDefContractPID());
                this.newSDep.setbObjLabel(gp.getBObjectLabel());
                this.newSDep.setbObjName(gp.getBObjectName());
                this.newSDep.setDCRecord(gp.getDCElements());
                continue;
            }
            if (element.getName().equalsIgnoreCase("ProfileTab")) {
                ServiceProfilePane spp = (ServiceProfilePane)element;
                this.newSDep.setServiceProfile(spp.getServiceProfile());
                continue;
            }
            if (element.getName().equalsIgnoreCase("MethodsTab")) {
                MethodsPane mp = (MethodsPane)element;
                this.newSDep.setHasBaseURL(mp.hasBaseURL());
                if (mp.hasBaseURL()) {
                    String baseURL = mp.getBaseURL();
                    if (baseURL.endsWith("/")) {
                        this.newSDep.setServiceBaseURL(baseURL);
                    } else {
                        this.newSDep.setServiceBaseURL(baseURL + "/");
                    }
                } else {
                    this.newSDep.setServiceBaseURL("LOCAL");
                }
                HashMap mmap = mp.getMethodMap();
                Method[] methods = mp.getMethods();
                this.newSDep.setMethodsHashMap(mmap);
                this.newSDep.setMethods(methods);
                Vector<String> dsBindingKeys = new Vector<String>();
                for (Method element2 : methods) {
                    MethodProperties props = element2.methodProperties;
                    if (props == null) continue;
                    for (int j = 0; j < props.dsBindingKeys.length; ++j) {
                        if (dsBindingKeys.contains(props.dsBindingKeys[j])) continue;
                        dsBindingKeys.add(props.dsBindingKeys[j]);
                    }
                }
                this.newSDep.setDSBindingKeys(dsBindingKeys);
                continue;
            }
            if (element.getName().equalsIgnoreCase("DSInputTab")) {
                DatastreamInputPane dsp = (DatastreamInputPane)element;
                this.newSDep.setDSInputSpec(dsp.getDSInputRules());
                continue;
            }
            if (!element.getName().equalsIgnoreCase("DocumentsTab")) continue;
            DocumentsPane docp = (DocumentsPane)element;
            this.newSDep.setDocDatastreams(docp.getDocDatastreams());
        }
    }

    protected boolean validateTemplate() {
        Component[] tabs = this.tabpane.getComponents();
        for (int i = 0; i < tabs.length; ++i) {
            if (!(tabs[i].getName().equalsIgnoreCase("GeneralTab") ? !this.validGeneralTab((GeneralPane)tabs[i]) : (tabs[i].getName().equalsIgnoreCase("ProfileTab") ? !this.validProfileTab((ServiceProfilePane)tabs[i]) : (tabs[i].getName().equalsIgnoreCase("MethodsTab") ? !this.validMethodsTab((MethodsPane)tabs[i]) : (tabs[i].getName().equalsIgnoreCase("DSInputTab") ? !this.validDSInputTab((DatastreamInputPane)tabs[i]) : tabs[i].getName().equalsIgnoreCase("DocumentsTab") && !this.validDocsTab((DocumentsPane)tabs[i])))))) continue;
            return false;
        }
        return true;
    }

    public ServiceDeploymentMETSSerializer savePanelInfo() {
        this.updateTemplate();
        ServiceDeploymentMETSSerializer mets = null;
        if (this.validateTemplate()) {
            DCGenerator dcg = null;
            DSInputSpecGenerator dsg = null;
            MethodMapGenerator mmg = null;
            WSDLGenerator wsdlg = null;
            ServiceProfileSerializer spg = null;
            try {
                dcg = new DCGenerator(this.newSDep);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("ServiceDeploymentBuilder: error serializing dc record", null);
            }
            try {
                spg = new ServiceProfileSerializer(this.newSDep);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("ServiceDeploymentBuilder: error serializing service profile", null);
            }
            try {
                dsg = new DSInputSpecGenerator(this.newSDep);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("ServiceDeploymentBuilder: error serializing ds input spec", null);
            }
            try {
                mmg = new MethodMapGenerator(this.newSDep);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("ServiceDeploymentBuilder: error serializing method map", null);
            }
            try {
                wsdlg = new WSDLGenerator(this.newSDep);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("ServiceDeploymentBuilder: error serializing wsdl", null);
            }
            try {
                mets = new ServiceDeploymentMETSSerializer(this.newSDep, dcg.getRootElement(), spg.getRootElement(), dsg.getRootElement(), mmg.getRootElement(), wsdlg.getRootElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("ServiceDeploymentBuilder: error in creating METS.", null);
            }
        }
        return mets;
    }

    private JComponent createGeneralPane() {
        GeneralPane gpane = new GeneralPane(this);
        gpane.setName("GeneralTab");
        return gpane;
    }

    private JComponent createProfilePane() {
        ServiceProfilePane profpane = new ServiceProfilePane(this);
        profpane.setName("ProfileTab");
        return profpane;
    }

    private JComponent createMethodsPane() {
        MethodsPane mpane = new MethodsPane(this);
        mpane.setName("MethodsTab");
        return mpane;
    }

    private JComponent createDSInputPane() {
        DatastreamInputPane dspane = new DatastreamInputPane(this);
        dspane.setName("DSInputTab");
        return dspane;
    }

    private JComponent createDocPane() {
        DocumentsPane docpane = new DocumentsPane();
        docpane.setName("DocumentsTab");
        return docpane;
    }

    private boolean validGeneralTab(GeneralPane gp) {
        if (gp.rb_chosen.equalsIgnoreCase("retainPID") && (gp.getBObjectPID() == null || gp.getBObjectPID().trim().equals(""))) {
            this.assertTabPaneMsg("The test PID value is missing on General Tab.", gp.getName());
            return false;
        }
        if (gp.getSDefContractPID() == null || gp.getSDefContractPID().trim().equals("")) {
            this.assertTabPaneMsg("SDefPID is missing on General Tab.", gp.getName());
            return false;
        }
        if (gp.getBObjectLabel() == null || gp.getBObjectLabel().trim().equals("")) {
            this.assertTabPaneMsg("Service Object Description is missing on General Tab.", gp.getName());
            return false;
        }
        if (gp.getBObjectName() == null || gp.getBObjectName().trim().equals("")) {
            this.assertTabPaneMsg("Service Object Name (1-word) is missing on General Tab.", gp.getName());
            return false;
        }
        if (gp.getDCElements().length <= 0) {
            this.assertTabPaneMsg("You must enter at least one DC element on General Tab.", gp.getName());
            return false;
        }
        return true;
    }

    private boolean validProfileTab(ServiceProfilePane spp) {
        if (spp.getServiceName() == null) {
            this.assertTabPaneMsg(new String("You must enter a Service name in the Service Profile Tab"), spp.getName());
            return false;
        }
        if (spp.getMsgProtocol() == null) {
            this.assertTabPaneMsg(new String("You must enter the messaging protocol for this service in the Service Profile Tab"), spp.getName());
            return false;
        }
        if (spp.getOutputMIMETypes().length == 0) {
            this.assertTabPaneMsg(new String("You must enter at least one output MIME type for this service in the Service Profile Tab"), spp.getName());
            return false;
        }
        return true;
    }

    private boolean validMethodsTab(MethodsPane mp) {
        if (mp.hasBaseURL() && (mp.getBaseURL() == null || mp.getBaseURL().trim().equals(""))) {
            this.assertTabPaneMsg("The Base URL is missing on Service Methods Tab.", mp.getName());
            return false;
        }
        if (mp.getMethods().length <= 0) {
            this.assertTabPaneMsg("You must enter at least one method definition in Service Methods Tab.", mp.getName());
            return false;
        }
        Method[] methods = mp.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].methodProperties == null) {
                this.assertTabPaneMsg(new String("You must enter properties for the method " + methods[i].methodName) + " in the Service Methods Tab", mp.getName());
                return false;
            }
            if (methods[i].methodProperties.wasValidated) continue;
            this.assertTabPaneMsg(new String("You must enter valid properties for the method " + methods[i].methodName + " in the Service Methods Tab"), mp.getName());
            return false;
        }
        return true;
    }

    private boolean validDSInputTab(DatastreamInputPane dsp) {
        DSInputRule[] rules = dsp.getDSInputRules();
        Vector bindkeys = this.newSDep.getDSBindingKeys();
        if (bindkeys.size() != rules.length) {
            this.assertTabPaneMsg(new String("You have not completed entry of the Datastream input binding rules in the Datastream Input Tab"), dsp.getName());
            return false;
        }
        for (DSInputRule element : rules) {
            if (element.bindingKeyName == null) {
                this.assertTabPaneMsg(new String("A Datastream parm name is missing from column 1 of the table in the Datastream Input Tab"), dsp.getName());
                return false;
            }
            if (element.bindingMIMEType == null || element.bindingMIMEType.trim().equalsIgnoreCase("")) {
                this.assertTabPaneMsg(new String("You must enter MIMEType for datastream input parm " + element.bindingKeyName + " in the Datastream Input Tab"), dsp.getName());
                return false;
            }
            if (element.minNumBindings == null) {
                this.assertTabPaneMsg(new String("You must enter Min Occurs for datastream input parm " + element.bindingKeyName + " on Datastream Input Tab."), dsp.getName());
                return false;
            }
            if (element.maxNumBindings == null) {
                this.assertTabPaneMsg(new String("You must enter Max Occurs for datastream input parm " + element.bindingKeyName + " on Datastream Input Tab."), dsp.getName());
                return false;
            }
            if (element.ordinality == null) {
                this.assertTabPaneMsg(new String("You must enter Order Matters for datastream input parm " + element.bindingKeyName + " on Datastream Input Tab."), dsp.getName());
                return false;
            }
            if (element.bindingLabel != null) continue;
            this.assertTabPaneMsg(new String("You must enter Pretty Label for datastream input parm " + element.bindingKeyName + " on Datastream Input Tab."), dsp.getName());
            return false;
        }
        return true;
    }

    private boolean validDocsTab(DocumentsPane docp) {
        Datastream[] docs = docp.getDocDatastreams();
        if (docs.length < 1) {
            this.assertTabPaneMsg(new String("You must enter at least one document that describes the service in the Documents Tab."), docp.getName());
            return false;
        }
        for (Datastream element : docs) {
            if (element.dsLabel == null) {
                this.assertTabPaneMsg(new String("You must enter a Label for all documentslisted on the Documents Tab."), docp.getName());
                return false;
            }
            if (element.dsMIMEType != null) continue;
            this.assertTabPaneMsg(new String("You must enter a MIME type for all documentslisted on the Documents Tab."), docp.getName());
            return false;
        }
        return true;
    }

    private void showGeneralHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("There are three sections to the General Tab that must be completed:\n\n Object Description:\n >>> Service Object PID: either select the button for the repository system to generate one, or enter your own with the prefix 'test:' or 'demo:'\n\n >>> Service Object Name:  enter a single word to name the object. This name is used in various places within inline metadata that is generated by the tool.\n\n >>> Service Object Label: enter a meaningful label for theobject.\n\n \n Service Contract:\n >>> Service Definition PID: enter the PID of the Service Definition Object that the Service Deployment is fullfilling\n\n \n Dublin Core Metadata:\n>>> Enter at least one DC element to describe the Service Deployment Object.");
        JOptionPane.showMessageDialog(this, helptxt, "Help for General Tab", 0);
    }

    private void showMethodsHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("Service Address:\n There are three types of service bindings that can be set up in a Service Deployment object:\n\n 1. Base URL (Service with a Base URL): You are mapping the Service Deployment object to a service that has a single base URL that all of the service methods are relative to. The service will be used to transform or refactor Datastream content.\n\n 2. No Base URL (Multi-Server Service): You are mapping the Service Deployment object to a service whose methods do not have a common base URL.  Instead, different methods may run on different servers.  However, from the Fedora perspective these methods may be aggregated together in a single Service Deployment object to fulfill a Service contract. The service methods will be used to transform or refactor Datastream content.\n\n 2. Fedora Built-in Datastream Resolver: You are NOT mapping the Service Deployment object to a service. Instead, this Service Deployment object will partake of default capabilities of the Fedora repository server.  You can use this option if you simply want to make an association between methods of a behavor contract and Datastreams in the object. So, for example, you want the Service contract methods to just return specific Datastreams in the object without transforming or refactoring those datastreams via a service.  This option is really just specifying a MethodName-to-Datastream binding relationship.\n\n\n Service Method Definitions:\n Here are the definitions of the specific methods that are runnable by the service.  A list of methods are automatically  listed in the table.  These were obtained by looking up the abstract methods defined by the Service Definition Contract that you specified in the 'General Tab.' Use the 'Properties' button to the right of the table to enter specific service binding information for each method.");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Service Methods Tab", 0);
    }

    private void showDatastreamsHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("insert datastream Input help\n\n");
        helptxt.append("\n\n");
        helptxt.append("\n\n");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Datastream Input Tab", 0);
    }

    private void showDocumentsHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("insert documents help\n\n");
        helptxt.append("\n\n");
        helptxt.append("\n\n");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Documents Tab", 0);
    }

    private void showProfileHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("Use the Service Profile to enter technical information about the service being mapped to this Service Deployment object.\n\n");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Service Profile Tab", 0);
    }

    private void assertTabPaneMsg(String msg, String tabpane) {
        JOptionPane.showMessageDialog(this, new String(msg), new String(tabpane + " Message"), 1);
    }

    private void print() {
        DSInputRule[] rules;
        ServiceSoftware[] sw;
        String[] outputMIME;
        String[] inputMIME;
        DCElement[] dcrecord;
        System.out.println("FROM GENERAL TAB===============================");
        System.out.println("sDefPID: " + this.newSDep.getSDefContractPID());
        System.out.println("sSepLabel: " + this.newSDep.getbObjLabel());
        System.out.println("DCRecord: ");
        for (DCElement element : dcrecord = this.newSDep.getDCRecord()) {
            System.out.println(">>> " + element.elementName + "=" + element.elementValue);
        }
        System.out.println("FROM PROFILE TAB===============================");
        System.out.println("serviceName: " + this.newSDep.getServiceProfile().serviceName);
        System.out.println("serviceLabel: " + this.newSDep.getServiceProfile().serviceLabel);
        System.out.println("serviceTestURL: " + this.newSDep.getServiceProfile().serviceTestURL);
        System.out.println("Input MIME: ");
        for (String element : inputMIME = this.newSDep.getServiceProfile().inputMIMETypes) {
            System.out.println(">>> " + element);
        }
        System.out.println("Input MIME: ");
        for (String element : outputMIME = this.newSDep.getServiceProfile().outputMIMETypes) {
            System.out.println(">>> " + element);
        }
        System.out.println("SW Depend: ");
        for (ServiceSoftware element : sw = this.newSDep.getServiceProfile().software) {
            System.out.println(">>> " + element.swName + "," + element.swType + "," + element.swVersion + "," + element.swLicenceType + ",");
        }
        System.out.println("FROM METHODS TAB===============================");
        System.out.println("hasBaseURL: " + this.newSDep.getHasBaseURL());
        System.out.println("serviceBaseURL: " + this.newSDep.getServiceBaseURL());
        System.out.println("methods: ");
        HashMap m2 = this.newSDep.getMethodsHashMap();
        Collection methods = m2.values();
        for (Method method : methods) {
            System.out.println("  method name: " + method.methodName + "\n" + "  method desc: " + method.methodLabel + "\n" + "  method URL: " + method.methodProperties.methodFullURL + "\n" + "  method protocol" + method.methodProperties.protocolType + "\n");
            System.out.println("  method parms:");
            for (MethodParm mp : method.methodProperties.methodParms) {
                System.out.println(">>>parmName: " + mp.parmName + "\n" + ">>>parmType: " + mp.parmType + "\n" + ">>>parmLabel: " + mp.parmLabel + "\n" + ">>>parmDefaultValue: " + mp.parmDefaultValue + "\n" + ">>>parmPassBy: " + mp.parmPassBy + "\n" + ">>>parmRequired: " + mp.parmRequired + "\n" + ">>>parmDomainValues: " + mp.parmDomainValues + "\n");
            }
        }
        System.out.println("FROM DSINPUT TAB===============================");
        for (DSInputRule element : rules = this.newSDep.getDSInputSpec()) {
            System.out.println(">>>name= " + element.bindingKeyName + "\n" + ">>>mime= " + element.bindingMIMEType + "\n" + ">>>min= " + element.minNumBindings + "\n" + ">>>max= " + element.maxNumBindings + "\n" + ">>>order= " + element.ordinality + "\n" + ">>>label= " + element.bindingLabel + "\n" + ">>>instruct= " + element.bindingInstruction + "\n");
        }
    }
}

