/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.deployment.ComboBoxRenderer;
import fedora.client.deployment.ComboBoxTableCellEditor;
import fedora.client.deployment.ServiceDeploymentBuilder;
import fedora.client.deployment.data.ServiceProfile;
import fedora.client.deployment.data.ServiceSoftware;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;

public class ServiceProfilePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField serviceName;
    private JTextField serviceLabel;
    private JTextField serviceTestURL;
    private JComboBox msgProtocol;
    private JTextField inputMIMETypes;
    private JTextField outputMIMETypes;
    private final JTable dependencyTable;

    public ServiceProfilePane(ServiceDeploymentBuilder parent) {
        this.setLayout(new GridLayout(3, 1));
        JPanel textPane1 = new JPanel();
        textPane1.setBorder(new TitledBorder("General"));
        textPane1.setLayout(new GridLayout(4, 2));
        textPane1.add(new JLabel("Service Name: "));
        this.serviceName = new JTextField();
        textPane1.add(this.serviceName);
        textPane1.add(new JLabel("Service Description: "));
        this.serviceLabel = new JTextField();
        textPane1.add(this.serviceLabel);
        textPane1.add(new JLabel("Service Test URL: "));
        this.serviceTestURL = new JTextField();
        textPane1.add(this.serviceTestURL);
        JPanel textPane2 = new JPanel();
        textPane2.setBorder(new TitledBorder("Service Binding"));
        textPane2.setLayout(new GridLayout(4, 2));
        textPane2.add(new JLabel("Messaging Protocol:"));
        String[] messaging = new String[]{"HTTP GET", "HTTP POST", "SOAP"};
        this.msgProtocol = new JComboBox<String>(messaging);
        textPane2.add(this.msgProtocol);
        textPane2.add(new JLabel("Input MIME Types: "));
        this.inputMIMETypes = new JTextField();
        textPane2.add(this.inputMIMETypes);
        textPane2.add(new JLabel("Output MIME Types: "));
        this.outputMIMETypes = new JTextField();
        textPane2.add(this.outputMIMETypes);
        this.dependencyTable = new JTable(20, 5);
        this.dependencyTable.setColumnSelectionAllowed(false);
        this.dependencyTable.setRowSelectionAllowed(true);
        this.dependencyTable.setRowHeight(18);
        TableColumn tc0 = this.dependencyTable.getColumnModel().getColumn(0);
        tc0.setHeaderValue("Software Name");
        tc0.sizeWidthToFit();
        TableColumn tc1 = this.dependencyTable.getColumnModel().getColumn(1);
        tc1.setHeaderValue("Version");
        tc1.sizeWidthToFit();
        TableColumn tc2 = this.dependencyTable.getColumnModel().getColumn(2);
        tc2.setHeaderValue("Software Type");
        String[] swtype = new String[]{"Server_Application", "Client_Application", "Utility_Application", "Software_Library", "Script", "Program", "Operating_System", "Programming_Language", "OTHER"};
        tc2.setCellRenderer(new ComboBoxRenderer(swtype));
        tc2.setCellEditor(new ComboBoxTableCellEditor(swtype));
        tc2.sizeWidthToFit();
        tc2.sizeWidthToFit();
        TableColumn tc3 = this.dependencyTable.getColumnModel().getColumn(3);
        tc3.setHeaderValue("License Type");
        String[] license = new String[]{"Commercial", "GNU_GPL", "GNU_LGPL", "Mozilla_Public_License", "BSD", "Common_Public_License", "Apache_Software_License", "Sun_Community_Source_License", "Public_Domain", "OTHER"};
        tc3.setCellRenderer(new ComboBoxRenderer(license));
        tc3.setCellEditor(new ComboBoxTableCellEditor(license));
        tc3.sizeWidthToFit();
        TableColumn tc4 = this.dependencyTable.getColumnModel().getColumn(4);
        tc4.setHeaderValue("Open Source?");
        String[] yesno = new String[]{Boolean.toString(true), Boolean.toString(false)};
        tc4.setCellRenderer(new ComboBoxRenderer(yesno));
        tc4.setCellEditor(new ComboBoxTableCellEditor(yesno));
        tc4.sizeWidthToFit();
        JScrollPane scrollpane = new JScrollPane(this.dependencyTable);
        scrollpane.setColumnHeaderView(this.dependencyTable.getTableHeader());
        scrollpane.getViewport().setBackground(Color.white);
        JPanel dependencyPanel = new JPanel(new BorderLayout());
        dependencyPanel.setBorder(new TitledBorder("Software Dependencies"));
        dependencyPanel.add((Component)scrollpane, "Center");
        this.add(textPane1);
        this.add(textPane2);
        this.add(dependencyPanel);
        this.setVisible(true);
    }

    public ServiceProfile getServiceProfile() {
        ServiceProfile profile = new ServiceProfile();
        profile.serviceName = this.getServiceName();
        profile.serviceLabel = this.getServiceLabel();
        profile.serviceTestURL = this.getServiceTestURL();
        profile.msgProtocol = this.getMsgProtocol();
        profile.inputMIMETypes = this.getInputMIMETypes();
        profile.outputMIMETypes = this.getOutputMIMETypes();
        profile.software = this.getSWDependencies();
        return profile;
    }

    public String getServiceName() {
        return this.serviceName.getText();
    }

    public String getServiceLabel() {
        return this.serviceLabel.getText();
    }

    public String getServiceTestURL() {
        return this.serviceTestURL.getText();
    }

    public String getMsgProtocol() {
        return (String)this.msgProtocol.getSelectedItem();
    }

    public String[] getInputMIMETypes() {
        Vector<String> mimeTypes = new Vector<String>();
        String normalizedString = this.normalizeString(this.inputMIMETypes.getText());
        StringTokenizer st = new StringTokenizer(normalizedString, ",");
        while (st.hasMoreElements()) {
            mimeTypes.add(((String)st.nextElement()).trim());
        }
        return mimeTypes.toArray(new String[0]);
    }

    public String[] getOutputMIMETypes() {
        Vector<String> mimeTypes = new Vector<String>();
        String normalizedString = this.normalizeString(this.outputMIMETypes.getText());
        StringTokenizer st = new StringTokenizer(normalizedString, ",");
        while (st.hasMoreElements()) {
            mimeTypes.add(((String)st.nextElement()).trim());
        }
        return mimeTypes.toArray(new String[0]);
    }

    public ServiceSoftware[] getSWDependencies() {
        if (this.dependencyTable.isEditing()) {
            this.dependencyTable.getCellEditor().stopCellEditing();
        }
        Vector<ServiceSoftware> elements = new Vector<ServiceSoftware>();
        int rowcount = this.dependencyTable.getModel().getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            ServiceSoftware sw = new ServiceSoftware();
            sw.swName = (String)this.dependencyTable.getValueAt(i, 0);
            if (sw.swName != null) {
                sw.swName = sw.swName.trim();
            }
            if (sw.swName == null || sw.swName.equalsIgnoreCase("") || sw.swName.equalsIgnoreCase(" ")) continue;
            sw.swVersion = (String)this.dependencyTable.getValueAt(i, 1);
            sw.swType = (String)this.dependencyTable.getValueAt(i, 2);
            sw.swLicenceType = (String)this.dependencyTable.getValueAt(i, 3);
            sw.isOpenSource = Boolean.parseBoolean((String)this.dependencyTable.getValueAt(i, 4));
            elements.add(sw);
        }
        return elements.toArray(new ServiceSoftware[0]);
    }

    private String normalizeString(String values) {
        String original = values.trim();
        Pattern spaces = Pattern.compile(" ++");
        Matcher m = spaces.matcher(original);
        String interim = m.replaceAll(",");
        Pattern multcommas = Pattern.compile(",++");
        Matcher m2 = multcommas.matcher(interim);
        String normal = m2.replaceAll(",");
        return normal;
    }
}

