/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.data.BObjTemplate;
import fedora.client.deployment.data.DCElement;
import fedora.client.deployment.xml.XMLWriter;
import fedora.common.Constants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DCGenerator
implements Constants {
    private Document document;

    public DCGenerator(BObjTemplate newBObj) throws DeploymentBuilderException {
        this.createDOM();
        this.genDC(newBObj);
    }

    private void createDOM() throws DeploymentBuilderException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new DeploymentBuilderException("DCGenerator: error configuring parser.Underlying exception: " + pce.getMessage());
        }
    }

    private void genDC(BObjTemplate newBObj) {
        DCElement[] elements = newBObj.getDCRecord();
        Element root = this.document.createElementNS(DCGenerator.OAI_DC.uri, "oai_dc:dc");
        root.setAttributeNS(DCGenerator.XMLNS.uri, "xmlns:oai_dc", DCGenerator.OAI_DC.uri);
        root.setAttributeNS(DCGenerator.XMLNS.uri, "xmlns:dc", DCGenerator.DC.uri);
        this.document.appendChild(root);
        for (DCElement element : elements) {
            Element e = this.document.createElementNS(DCGenerator.DC.uri, "dc:" + element.elementName);
            e.appendChild(this.document.createTextNode(element.elementValue));
            root.appendChild(e);
        }
    }

    public Element getRootElement() {
        return this.document.getDocumentElement();
    }

    public Document getDocument() {
        return this.document;
    }

    public void printDC() {
        try {
            String str = new XMLWriter(new DOMResult(this.document)).getXMLAsString();
            System.out.println(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

