/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.data.DSInputRule;
import fedora.client.deployment.data.ServiceDeploymentTemplate;
import fedora.client.deployment.xml.XMLWriter;
import fedora.common.Constants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DSInputSpecGenerator
implements Constants {
    private Document document;

    public DSInputSpecGenerator(ServiceDeploymentTemplate newSDep) throws DeploymentBuilderException {
        this.createDOM();
        this.genDSInputSpec(newSDep);
    }

    private void createDOM() throws DeploymentBuilderException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new DeploymentBuilderException("DSInputSpecGenerator: error configuring parser.Underlying exception: " + pce.getMessage());
        }
    }

    private void genDSInputSpec(ServiceDeploymentTemplate newSDef) {
        DSInputRule[] rules = newSDef.getDSInputSpec();
        Element root = this.document.createElementNS(DSInputSpecGenerator.BINDING_SPEC.uri, "fbs:DSInputSpec");
        root.setAttributeNS(DSInputSpecGenerator.XMLNS.uri, "xmlns:fbs", DSInputSpecGenerator.BINDING_SPEC.uri);
        String bmlabel = newSDef.getbObjLabel() == null ? "" : newSDef.getbObjLabel();
        root.setAttribute("label", "Datastream Input Specification for " + bmlabel);
        String sDefPID = newSDef.getSDefContractPID() == null ? "" : newSDef.getSDefContractPID();
        root.setAttribute("bDefPID", sDefPID);
        this.document.appendChild(root);
        for (DSInputRule element : rules) {
            String[] mimetypes;
            Element dsInput = this.document.createElementNS(DSInputSpecGenerator.BINDING_SPEC.uri, "fbs:DSInput");
            String bindKeyName = element.bindingKeyName == null ? "" : element.bindingKeyName;
            String mime = element.bindingMIMEType == null ? "" : element.bindingMIMEType;
            String min = element.minNumBindings == null ? "" : element.minNumBindings;
            String max = element.maxNumBindings == null ? "" : element.maxNumBindings;
            String order = element.ordinality == null ? "" : element.ordinality;
            String label = element.bindingLabel == null ? "" : element.bindingLabel;
            String instr = element.bindingInstruction == null ? "" : element.bindingInstruction;
            dsInput.setAttribute("wsdlMsgPartName", bindKeyName.trim());
            dsInput.setAttribute("DSMin", min.trim());
            dsInput.setAttribute("DSMax", max.trim());
            dsInput.setAttribute("DSOrdinality", order.trim());
            Element dsLabel = this.document.createElementNS(DSInputSpecGenerator.BINDING_SPEC.uri, "fbs:DSInputLabel");
            dsLabel.appendChild(this.document.createTextNode(label));
            Element dsInstr = this.document.createElementNS(DSInputSpecGenerator.BINDING_SPEC.uri, "fbs:DSInputInstruction");
            dsInstr.appendChild(this.document.createTextNode(instr));
            dsInput.appendChild(dsLabel);
            for (String element2 : mimetypes = mime.split(",")) {
                Element dsMIME = this.document.createElementNS(DSInputSpecGenerator.BINDING_SPEC.uri, "fbs:DSMIME");
                dsMIME.appendChild(this.document.createTextNode(element2));
                dsInput.appendChild(dsMIME);
            }
            dsInput.appendChild(dsInstr);
            root.appendChild(dsInput);
        }
    }

    public Element getRootElement() {
        return this.document.getDocumentElement();
    }

    public Document getDocument() {
        return this.document;
    }

    public void printDSInputSpec() {
        try {
            String str = new XMLWriter(new DOMResult(this.document)).getXMLAsString();
            System.out.println(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

