/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.data.BObjTemplate;
import fedora.client.deployment.xml.BObjMETSSerializer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceDefinitionMETSSerializer
extends BObjMETSSerializer {
    private final Element in_dc;
    private final Element in_methodMap;

    public ServiceDefinitionMETSSerializer(BObjTemplate sDefData, Element dc, Element methodMap) throws DeploymentBuilderException {
        super(sDefData);
        this.in_dc = dc;
        this.in_methodMap = methodMap;
        this.serialize();
    }

    protected Attr[] getVariableRootAttrs() {
        Vector<Attr> v_attrs = new Vector<Attr>();
        Attr extVersion = this.document.createAttribute("EXT_VERSION");
        extVersion.setValue("1.1");
        v_attrs.add(extVersion);
        return v_attrs.toArray(new Attr[0]);
    }

    protected Element[] getInlineMD() throws DeploymentBuilderException {
        Vector<Element> v_elements = new Vector<Element>();
        v_elements.add(this.setDC(this.in_dc));
        v_elements.add(this.setMethodMap(this.in_methodMap));
        return v_elements.toArray(new Element[0]);
    }

    private Element setMethodMap(Element methodMap) throws DeploymentBuilderException {
        Element mmapNode = this.document.createElementNS(ServiceDefinitionMETSSerializer.METS.uri, "METS:amdSec");
        mmapNode.setAttribute("ID", "METHODMAP");
        Element techMD = this.document.createElementNS(ServiceDefinitionMETSSerializer.METS.uri, "METS:techMD");
        techMD.setAttribute("ID", "METHODMAP1.0");
        techMD.setAttribute("CREATED", this.now);
        techMD.setAttribute("STATUS", "A");
        Element mdWrap = this.document.createElementNS(ServiceDefinitionMETSSerializer.METS.uri, "METS:mdWrap");
        mdWrap.setAttribute("MIMETYPE", "text/xml");
        mdWrap.setAttribute("MDTYPE", "OTHER");
        mdWrap.setAttribute("LABEL", "Abstract Method Definitions");
        Element xmlData = this.document.createElementNS(ServiceDefinitionMETSSerializer.METS.uri, "METS:xmlData");
        Node importMethodMap = this.document.importNode(methodMap, true);
        xmlData.appendChild(importMethodMap);
        mdWrap.appendChild(xmlData);
        techMD.appendChild(mdWrap);
        mmapNode.appendChild(techMD);
        return mmapNode;
    }
}

