/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.export;

import fedora.client.Administrator;
import fedora.client.export.ExportOptionsDialog;
import fedora.client.utility.export.Export;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ExportDialog {
    public static int ONE = 0;
    public static int MULTI = 1;

    public ExportDialog(int kind) {
        try {
            JFileChooser browse = new JFileChooser(Administrator.getLastDir());
            browse.setDialogTitle("Export to which directory?");
            browse.setFileSelectionMode(1);
            int returnVal = browse.showOpenDialog(Administrator.getDesktop());
            if (returnVal == 0) {
                File file = browse.getSelectedFile();
                Administrator.setLastDir(file.getParentFile());
                ExportOptionsDialog optsDialog = new ExportOptionsDialog("Select Options for Export");
                if (optsDialog.getFormatSelection() != null) {
                    if (kind == ONE) {
                        String pid = JOptionPane.showInputDialog("Enter the PID of the object to export.");
                        if (pid != null && !pid.equals("")) {
                            Export.one(Administrator.APIA, Administrator.APIM, pid, optsDialog.getFormatSelection(), optsDialog.getContextSelection(), file);
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), "Export succeeded.  PID='" + pid + "'.");
                        }
                    } else {
                        long st = System.currentTimeMillis();
                        int count = Export.multi(Administrator.APIA, Administrator.APIM, optsDialog.getFormatSelection(), optsDialog.getContextSelection(), file);
                        long et = System.currentTimeMillis();
                        JOptionPane.showMessageDialog(Administrator.getDesktop(), "Export of " + count + " objects finished.\n" + "Time elapsed: " + Export.getDuration(et - st));
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.getClass().getName();
            }
            Administrator.showErrorDialog(Administrator.getDesktop(), "Export Failure", msg, e);
        }
    }
}

