/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.objecteditor.ContentEditor;
import fedora.client.objecteditor.ContentViewer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public abstract class ContentHandlerFactory {
    private static HashMap s_viewers = new HashMap();
    private static HashMap s_editors = new HashMap();

    public static void register(ContentViewer handler) {
        String[] types;
        if (handler.isEditor()) {
            for (String element : types = handler.getTypes()) {
                s_editors.put(element, handler);
            }
        }
        for (String element : types = handler.getTypes()) {
            s_viewers.put(element, handler);
        }
    }

    public static boolean hasViewer(String type) {
        return s_viewers.containsKey(type) || type.endsWith("+xml") && s_viewers.containsKey("text/xml");
    }

    public static boolean viewerIsEditor(String type) {
        Object viewer = s_viewers.get(type);
        if (viewer != null) {
            return viewer instanceof ContentEditor;
        }
        return false;
    }

    public static boolean hasEditor(String type) {
        return s_editors.containsKey(type) || type.endsWith("+xml") && s_editors.containsKey("text/xml");
    }

    public static ContentViewer getViewer(String type, InputStream data) throws IOException {
        ContentViewer viewer = (ContentViewer)s_viewers.get(type);
        if (viewer == null && type.endsWith("+xml")) {
            viewer = (ContentViewer)s_viewers.get("text/xml");
        }
        return viewer.newInstance(type, data, true);
    }

    public static ContentEditor getEditor(String type, InputStream data) throws IOException {
        ContentEditor editor = (ContentEditor)s_editors.get(type);
        if (editor == null && type.endsWith("+xml")) {
            editor = (ContentEditor)s_editors.get("text/xml");
        }
        return (ContentEditor)editor.newInstance(type, data, false);
    }
}

