/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.objecteditor.DatastreamsPane;
import fedora.client.objecteditor.ObjectPane;
import fedora.client.objecteditor.PotentiallyDirty;
import fedora.client.objecteditor.Util;
import fedora.server.types.gen.Datastream;
import fedora.server.types.gen.ObjectFields;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ObjectEditorFrame
extends JInternalFrame
implements PotentiallyDirty {
    private static final long serialVersionUID = 1L;
    private final ObjectPane m_objectPane;
    private final DatastreamsPane m_datastreamsPane;
    private final JTabbedPane m_tabbedPane;
    private final String m_pid;
    static ImageIcon objIcon = new ImageIcon(Administrator.cl.getResource("images/standard/general/Information16.gif"));
    static ImageIcon dsIcon = new ImageIcon(Administrator.cl.getResource("images/standard/general/Copy16.gif"));
    static ImageIcon dissIcon = new ImageIcon(Administrator.cl.getResource("images/standard/general/Refresh16.gif"));

    public ObjectEditorFrame(String pid, int startTab) throws Exception {
        super(pid, true, true, true, true);
        this.m_pid = pid;
        ObjectFields o = Util.getObjectFields(pid, new String[]{"pid", "state", "label", "cDate", "mDate", "ownerId"});
        String state = o.getState();
        String label = o.getLabel();
        String cDate = o.getCDate();
        String mDate = o.getMDate();
        String ownerId = o.getOwnerId();
        this.doTitle(false);
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new ObjectEditorClosingListener(pid));
        this.m_objectPane = new ObjectPane(this, pid, state, label, cDate, mDate, ownerId);
        this.m_datastreamsPane = new DatastreamsPane(this, pid);
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.addTab("Properties", this.m_objectPane);
        this.m_tabbedPane.setBackgroundAt(0, Administrator.DEFAULT_COLOR);
        this.m_tabbedPane.setIconAt(0, objIcon);
        this.m_tabbedPane.addTab("Datastreams", this.m_datastreamsPane);
        this.m_tabbedPane.setBackgroundAt(1, Administrator.DEFAULT_COLOR);
        this.m_tabbedPane.setIconAt(1, dsIcon);
        this.m_tabbedPane.setSelectedIndex(startTab);
        JPanel outerPane = new JPanel();
        outerPane.setLayout(new BorderLayout());
        outerPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        outerPane.add((Component)this.m_tabbedPane, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)outerPane, "Center");
        this.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Open16.gif")));
        this.pack();
        Dimension dims = this.getSize();
        if (dims.height < 545) {
            dims.height = 545;
        } else if (dims.height > 580) {
            dims.height = 580;
        }
        if (dims.width < 740) {
            dims.width = 740;
        } else if (dims.width > 820) {
            dims.width = 820;
        }
        this.setSize(dims);
        this.show();
    }

    public Datastream[] getCurrentDatastreamVersions() {
        Collection vColl = this.m_datastreamsPane.getCurrentVersionMap().values();
        Datastream[] versions = new Datastream[vColl.size()];
        Iterator iter = vColl.iterator();
        int i = 0;
        while (iter.hasNext()) {
            versions[i++] = (Datastream)iter.next();
        }
        return versions;
    }

    private void doTitle(boolean dirty) {
        String d = "";
        if (dirty) {
            d = "*";
        }
        this.setTitle("Object - " + this.m_pid + d);
    }

    public boolean isDirty() {
        return this.m_objectPane.isDirty() || this.m_datastreamsPane.isDirty();
    }

    public void indicateDirtiness() {
        int dirtyCount = 0;
        if (this.m_objectPane.isDirty()) {
            ++dirtyCount;
            this.m_tabbedPane.setTitleAt(0, "Properties*");
        } else {
            this.m_tabbedPane.setTitleAt(0, "Properties");
        }
        if (this.m_datastreamsPane.isDirty()) {
            ++dirtyCount;
            this.m_tabbedPane.setTitleAt(1, "Datastreams*");
        } else {
            this.m_tabbedPane.setTitleAt(1, "Datastreams");
        }
        if (dirtyCount > 0) {
            this.doTitle(true);
        } else {
            this.doTitle(false);
        }
    }

    protected class ObjectEditorClosingListener
    extends InternalFrameAdapter {
        private final String m_pid;

        public ObjectEditorClosingListener(String pid) {
            this.m_pid = pid;
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            if (ObjectEditorFrame.this.isDirty()) {
                Object[] options = new Object[]{"Yes", "No"};
                int selected = JOptionPane.showOptionDialog(null, "Close " + this.m_pid + " without saving changes?", "Unsaved changes", -1, 2, null, options, options[0]);
                if (selected == 0) {
                    e.getInternalFrame().dispose();
                }
            } else {
                e.getInternalFrame().dispose();
            }
        }
    }
}

