/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor.types;

import fedora.client.objecteditor.types.DatastreamBindingRule;
import fedora.client.objecteditor.types.DatastreamInputSpec;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DatastreamInputSpecDeserializer
extends DefaultHandler {
    private DatastreamInputSpec m_result;
    private String m_label;
    private List m_bindingRules;
    private String m_min;
    private String m_max;
    private String m_orderMatters;
    private String m_key;
    private StringBuffer m_inputLabel;
    private StringBuffer m_inputInstruction;
    private StringBuffer m_types;
    private int m_readingContent;
    private static int NONE = 0;
    private static int INPUT_LABEL = 1;
    private static int TYPES = 2;
    private static int INPUT_INSTRUCTION = 3;

    public DatastreamInputSpecDeserializer(InputStream xml) throws IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(xml, (DefaultHandler)this);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new IOException(e.getMessage());
            }
            throw new IOException("Error parsing datastream input spec: " + e.getClass().getName());
        }
    }

    public DatastreamInputSpec getResult() {
        return this.m_result;
    }

    public void startElement(String uri, String localName, String qName, Attributes a) {
        if (localName.equals("DSInputSpec")) {
            this.m_bindingRules = new ArrayList();
            for (int i = 0; i < a.getLength(); ++i) {
                String name = a.getLocalName(i);
                if (!name.equals("label")) continue;
                this.m_label = a.getValue(i);
            }
        } else if (localName.equals("DSInput")) {
            this.m_inputLabel = new StringBuffer();
            this.m_inputInstruction = new StringBuffer();
            this.m_types = new StringBuffer();
            for (int i = 0; i < a.getLength(); ++i) {
                String name = a.getLocalName(i);
                if (name.equals("DSMin")) {
                    this.m_min = a.getValue(i);
                    continue;
                }
                if (name.equals("DSMax")) {
                    this.m_max = a.getValue(i);
                    continue;
                }
                if (name.equals("DSOrdinality")) {
                    this.m_orderMatters = a.getValue(i);
                    continue;
                }
                if (!name.equals("wsdlMsgPartName")) continue;
                this.m_key = a.getValue(i);
            }
        } else if (localName.equals("DSInputLabel")) {
            this.m_readingContent = INPUT_LABEL;
        } else if (localName.equals("DSMIME")) {
            this.m_readingContent = TYPES;
        } else if (localName.equals("DSInputInstruction")) {
            this.m_readingContent = INPUT_INSTRUCTION;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.m_readingContent == INPUT_LABEL) {
            this.m_inputLabel.append(ch, start, length);
        } else if (this.m_readingContent == TYPES) {
            this.m_types.append(ch, start, length);
        } else if (this.m_readingContent == INPUT_INSTRUCTION) {
            this.m_inputInstruction.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("DSInputLabel") || localName.equals("DSMIME") || localName.equals("DSInputInstruction")) {
            this.m_readingContent = NONE;
            if (localName.equals("DSMIME")) {
                this.m_types.append(" ");
            }
        } else if (localName.equals("DSInput")) {
            int max;
            int min;
            try {
                min = Integer.parseInt(this.m_min);
            }
            catch (Exception e) {
                min = 1;
            }
            try {
                max = Integer.parseInt(this.m_max);
            }
            catch (Exception e) {
                max = this.m_max != null && (this.m_max.startsWith("-") || this.m_max.startsWith("n") || this.m_max.startsWith("N") || this.m_max.startsWith("u") || this.m_max.startsWith("U") || this.m_max.startsWith("i") || this.m_max.startsWith("I")) ? -1 : 1;
            }
            boolean orderMatters = false;
            if (this.m_orderMatters != null && (this.m_orderMatters.startsWith("y") || this.m_orderMatters.startsWith("Y") || this.m_orderMatters.startsWith("t") || this.m_orderMatters.startsWith("T") || this.m_orderMatters.equals("1"))) {
                orderMatters = true;
            }
            String[] types = this.m_types.toString().replaceAll(" +", " ").trim().split(" ");
            this.m_bindingRules.add(new DatastreamBindingRule(this.m_key, this.m_inputLabel.toString(), this.m_inputInstruction.toString(), min, max, orderMatters, types));
        } else if (localName.equals("DSInputSpec")) {
            this.m_result = new DatastreamInputSpec(this.m_label, this.m_bindingRules);
        }
    }
}

