/*
 * Decompiled with CFR 0.152.
 */
package fedora.common.rdf;

import fedora.common.rdf.RDFNamespace;
import java.net.URI;
import java.net.URISyntaxException;
import org.jrdf.graph.TypedNodeVisitor;
import org.jrdf.graph.URIReference;

public class RDFName
implements URIReference {
    private static final long serialVersionUID = 1L;
    public final RDFNamespace namespace;
    public final String localName;
    public final String uri;
    public final String qName;
    private URI m_uri;

    public RDFName(RDFNamespace namespace, String localName) {
        try {
            this.namespace = namespace;
            this.localName = localName;
            this.uri = namespace.uri + localName;
            this.qName = namespace.prefix + ":" + this.localName;
            this.m_uri = new URI(this.uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad URI Syntax", e);
        }
    }

    public boolean looselyMatches(String in, boolean tryFirstLocalNameChar) {
        if (in == null || in.length() == 0) {
            return false;
        }
        if (in.equalsIgnoreCase(this.localName)) {
            return true;
        }
        if (in.indexOf(this.localName) != -1) {
            return true;
        }
        if (in.equals(this.uri)) {
            return true;
        }
        return tryFirstLocalNameChar && in.length() == 1 && in.toUpperCase().charAt(0) == this.localName.toUpperCase().charAt(0);
    }

    public void accept(TypedNodeVisitor visitor) {
        visitor.visitURIReference((URIReference)this);
    }

    public URI getURI() {
        return this.m_uri;
    }

    public String toString() {
        return this.uri;
    }
}

