/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.access;

import fedora.common.Constants;
import fedora.server.access.APIAStub;
import fedora.server.access.FedoraAPIA;
import fedora.server.access.FedoraAPIAService;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class FedoraAPIAServiceLocator
extends Service
implements Constants,
FedoraAPIAService {
    private static final long serialVersionUID = 1L;
    private final String FedoraAPIAPortSOAPHTTP_address = "http://localhost:0/fedora/services/access";
    private final String FedoraAPIAPortSOAPHTTPS_address = "https://localhost:0/fedora/services/access";
    private String username = null;
    private String password = null;
    private int socketTimeoutMilliseconds = 120000;
    private String FedoraAPIAPortSOAPHTTPWSDDServiceName = "FedoraAPIAPortSOAPHTTP";
    private String FedoraAPIAPortSOAPHTTPSWSDDServiceName = "FedoraAPIAPortSOAPHTTPS";
    private HashSet ports = null;

    public FedoraAPIAServiceLocator(String user, String pass) {
        this.username = user;
        this.password = pass;
    }

    public FedoraAPIAServiceLocator(String user, String pass, int socketTimeoutSeconds) {
        this.username = user;
        this.password = pass;
        this.socketTimeoutMilliseconds = socketTimeoutSeconds * 1000;
    }

    public FedoraAPIAServiceLocator() {
        this.username = "nobody";
        this.password = "nobody";
    }

    public String getFedoraAPIAPortSOAPHTTPAddress() {
        return "http://localhost:0/fedora/services/access";
    }

    public String getFedoraAPIAPortSOAPHTTPWSDDServiceName() {
        return this.FedoraAPIAPortSOAPHTTPWSDDServiceName;
    }

    public void setFedoraAPIAPortSOAPHTTPWSDDServiceName(String name) {
        this.FedoraAPIAPortSOAPHTTPWSDDServiceName = name;
    }

    public FedoraAPIA getFedoraAPIAPortSOAPHTTP() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL("http://localhost:0/fedora/services/access");
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.getFedoraAPIAPortSOAPHTTP(endpoint);
    }

    public FedoraAPIA getFedoraAPIAPortSOAPHTTP(URL portAddress) throws ServiceException {
        try {
            APIAStub _stub = new APIAStub(portAddress, this, this.username, this.password);
            _stub.setPortName(this.getFedoraAPIAPortSOAPHTTPWSDDServiceName());
            _stub.setTimeout(this.socketTimeoutMilliseconds);
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public String getFedoraAPIAPortSOAPHTTPSAddress() {
        return "https://localhost:0/fedora/services/access";
    }

    public String getFedoraAPIAPortSOAPHTTPSWSDDServiceName() {
        return this.FedoraAPIAPortSOAPHTTPSWSDDServiceName;
    }

    public void setFedoraAPIAPortSOAPHTTPSWSDDServiceName(String name) {
        this.FedoraAPIAPortSOAPHTTPSWSDDServiceName = name;
    }

    public FedoraAPIA getFedoraAPIAPortSOAPHTTPS() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL("https://localhost:0/fedora/services/access");
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.getFedoraAPIAPortSOAPHTTPS(endpoint);
    }

    public FedoraAPIA getFedoraAPIAPortSOAPHTTPS(URL portAddress) throws ServiceException {
        try {
            APIAStub _stub = new APIAStub(portAddress, this, this.username, this.password);
            _stub.setPortName(this.getFedoraAPIAPortSOAPHTTPSWSDDServiceName());
            _stub.setTimeout(this.socketTimeoutMilliseconds);
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (FedoraAPIA.class.isAssignableFrom(serviceEndpointInterface)) {
                APIAStub _stub = new APIAStub(new URL("http://localhost:0/fedora/services/access"), this, this.username, this.password);
                _stub.setPortName(this.getFedoraAPIAPortSOAPHTTPWSDDServiceName());
                _stub.setTimeout(this.socketTimeoutMilliseconds);
                return _stub;
            }
            if (FedoraAPIA.class.isAssignableFrom(serviceEndpointInterface)) {
                APIAStub _stub = new APIAStub(new URL("https://localhost:0/fedora/services/access"), this, this.username, this.password);
                _stub.setPortName(this.getFedoraAPIAPortSOAPHTTPSWSDDServiceName());
                _stub.setTimeout(this.socketTimeoutMilliseconds);
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("FedoraAPIAPortSOAPHTTP".equals(inputPortName)) {
            return this.getFedoraAPIAPortSOAPHTTP();
        }
        if ("FedoraAPIAPortSOAPHTTPS".equals(inputPortName)) {
            return this.getFedoraAPIAPortSOAPHTTPS();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        ((Stub)_stub).setTimeout(this.socketTimeoutMilliseconds);
        return _stub;
    }

    public QName getServiceName() {
        return new QName(FedoraAPIAServiceLocator.API.uri, "Fedora-API-A-Service");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("FedoraAPIAPortSOAPHTTP"));
            this.ports.add(new QName("FedoraAPIAPortSOAPHTTPS"));
        }
        return this.ports.iterator();
    }
}

