/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.storage.types;

import fedora.common.Constants;

public class RelationshipTuple
implements Constants {
    public final String subject;
    public final String predicate;
    public final String object;
    public final boolean isLiteral;
    public final String datatype;

    public RelationshipTuple(String subject, String predicate, String object, boolean isLiteral, String datatype) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.isLiteral = isLiteral;
        this.datatype = datatype;
    }

    public String getObjectPID() {
        if (this.object != null && !this.isLiteral && this.object.startsWith("info:fedora/")) {
            String PID2 = this.object.substring(12);
            return PID2;
        }
        return null;
    }

    public String getRelationship() {
        String prefixRel = RelationshipTuple.RELS_EXT.uri;
        if (this.predicate != null && this.predicate.startsWith(prefixRel)) {
            String rel = "rel:" + this.predicate.substring(prefixRel.length());
            return rel;
        }
        String prefixModel = RelationshipTuple.MODEL.uri;
        if (this.predicate != null && this.predicate.startsWith(prefixModel)) {
            String rel = "fedora-model:" + this.predicate.substring(prefixModel.length());
            return rel;
        }
        return this.predicate;
    }

    public String toString() {
        String retVal = "Sub: " + this.subject + "  Pred: " + this.predicate + "  Obj: [" + this.object + ", " + this.isLiteral + ", " + this.datatype + "]";
        return retVal;
    }

    public int hashCode() {
        return RelationshipTuple.hc(this.subject) + RelationshipTuple.hc(this.predicate) + RelationshipTuple.hc(this.object) + RelationshipTuple.hc(this.datatype);
    }

    public boolean equals(Object o) {
        if (o instanceof RelationshipTuple) {
            RelationshipTuple t = (RelationshipTuple)o;
            return RelationshipTuple.eq(this.subject, t.subject) && RelationshipTuple.eq(this.predicate, t.predicate) && RelationshipTuple.eq(this.object, t.object) && RelationshipTuple.eq(this.datatype, t.datatype) && this.isLiteral == t.isLiteral;
        }
        return false;
    }

    private static boolean eq(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return b != null && a.equals(b);
    }

    private static int hc(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }
}

