/*
 * Decompiled with CFR 0.152.
 */
package fedora.utilities;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

public class FileComparator
implements Comparator {
    private int m_multiplier = 1;
    private boolean m_ignoreCase = false;

    public FileComparator() {
    }

    public FileComparator(boolean useDescendingOrder) {
        if (useDescendingOrder) {
            this.m_multiplier = -1;
        }
    }

    public FileComparator(boolean useDescendingOrder, boolean ignoreCase) {
        this(useDescendingOrder);
        this.m_ignoreCase = ignoreCase;
    }

    public int compare(Object o1, Object o2) {
        String s1 = FileComparator.getComparable(o1);
        String s2 = FileComparator.getComparable(o2);
        if (this.m_ignoreCase) {
            return this.m_multiplier * s1.compareToIgnoreCase(s2);
        }
        return this.m_multiplier * s1.compareTo(s2);
    }

    public boolean descends() {
        return this.m_multiplier == -1;
    }

    public boolean ignoresCase() {
        return this.m_ignoreCase;
    }

    private static String getComparable(Object o) {
        File f = (File)o;
        StringBuffer out = new StringBuffer();
        StringTokenizer names = new StringTokenizer(f.getPath(), File.separator);
        int last = names.countTokens();
        int count = 0;
        while (names.hasMoreTokens()) {
            String name = names.nextToken();
            if (++count != 1) {
                out.append(File.separator);
            }
            if (count == last && !f.isDirectory()) {
                out.append(name);
                continue;
            }
            out.append(" " + name);
        }
        return out.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof FileComparator) {
            FileComparator c = (FileComparator)o;
            return this.descends() == c.descends() && this.ignoresCase() == c.ignoresCase();
        }
        return false;
    }

    public static void main(String[] args) {
        ArrayList list = new ArrayList();
        FileComparator.getFilesAndDirs(new File(args[0]), list);
        Object[] files = new File[list.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = (File)list.get(i);
        }
        FileComparator.print("Before sorting", (File[])files);
        Arrays.sort(files);
        FileComparator.print("Default File sorting", (File[])files);
        Arrays.sort(files, new FileComparator());
        FileComparator.print("Sorted with FileComparator", (File[])files);
        Arrays.sort(files, new FileComparator(true));
        FileComparator.print("Sorted with FileComparator in reverse", (File[])files);
    }

    private static void print(String kind, File[] f) {
        System.out.println(kind);
        for (File element : f) {
            System.out.println(FileComparator.getComparable(element));
        }
        System.out.println();
    }

    private static void getFilesAndDirs(File dir, List list) {
        File[] files;
        for (File element : files = dir.listFiles()) {
            list.add(element);
            if (!element.isDirectory()) continue;
            FileComparator.getFilesAndDirs(element, list);
        }
    }
}

