/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.query.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.nsdl.mptstore.core.TableManager;
import org.nsdl.mptstore.query.QueryException;
import org.nsdl.mptstore.query.component.GraphPattern;
import org.nsdl.mptstore.query.component.GraphQuery;
import org.nsdl.mptstore.query.component.MPTable;
import org.nsdl.mptstore.query.component.MappableNodeFilter;
import org.nsdl.mptstore.query.component.MappableNodePattern;
import org.nsdl.mptstore.query.component.MappableTriplePattern;
import org.nsdl.mptstore.query.component.NodeFilter;
import org.nsdl.mptstore.query.component.QueryElement;
import org.nsdl.mptstore.query.component.TriplePattern;
import org.nsdl.mptstore.query.provider.SQLBuilder;
import org.nsdl.mptstore.query.provider.SQLProvider;
import org.nsdl.mptstore.rdf.Node;
import org.nsdl.mptstore.rdf.PredicateNode;
import org.nsdl.mptstore.util.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphQuerySQLProvider
implements SQLBuilder,
SQLProvider {
    private static final Logger LOG = Logger.getLogger((String)GraphQuerySQLProvider.class.getName());
    private final GraphQuery query;
    private final TableManager tableManager;
    private MappingManager manager;
    private List<String> targets;
    private final boolean backslashEscape;
    private Set<MappableTriplePattern> encounteredPatterns;
    private String ordering;
    private String orderingDirection;
    private HashMap<String, Set<String>> valueBindings;

    public GraphQuerySQLProvider(TableManager tm, GraphQuery graphQuery, boolean backslashIsEscape) {
        this.tableManager = tm;
        this.query = graphQuery;
        this.backslashEscape = backslashIsEscape;
    }

    @Override
    public void setTargets(List<String> targetList) {
        this.targets = new ArrayList<String>(targetList);
        this.ordering = null;
    }

    public void orderBy(String target, boolean desc) {
        if (this.targets == null || !this.targets.contains(target)) {
            throw new IllegalArgumentException("Cannot group by variable '" + target + "' since it is not in the target list " + this.targets);
        }
        this.ordering = target;
        this.orderingDirection = desc ? "DESC" : "ASC";
    }

    @Override
    public List<String> getSQL() throws QueryException {
        this.manager = new MappingManager(this.tableManager);
        this.encounteredPatterns = new HashSet<MappableTriplePattern>();
        this.valueBindings = new HashMap();
        HashMap<String, String> requiredBindings = new HashMap<String, String>();
        HashMap<String, String> allBindings = new HashMap<String, String>();
        JoinSequence joinSeq = null;
        for (QueryElement e : this.query.getRequired()) {
            LOG.debug((Object)("Processing required element: " + e));
            if (e.getType().equals((Object)QueryElement.Type.GraphQuery)) {
                throw new QueryException("Currently, we do not support subqueries");
            }
            if (!e.getType().equals((Object)QueryElement.Type.GraphPattern)) {
                throw new QueryException("Unknown query element type " + (Object)((Object)e.getType()));
            }
            if (joinSeq == null) {
                joinSeq = new JoinSequence(this.parseGraphPattern((GraphPattern)e, requiredBindings));
                continue;
            }
            joinSeq.addJoin("JOIN", this.parseGraphPattern((GraphPattern)e, requiredBindings), requiredBindings);
        }
        allBindings.putAll(requiredBindings);
        for (QueryElement e : this.query.getOptional()) {
            LOG.debug((Object)("processing optional path: " + e));
            HashMap<String, String> optionalBindings = requiredBindings;
            if (e.getType().equals((Object)QueryElement.Type.GraphQuery)) {
                throw new QueryException("Currently, we do not support subqueries");
            }
            if (!e.getType().equals((Object)QueryElement.Type.GraphPattern)) {
                throw new QueryException("Unknown query element type " + (Object)((Object)e.getType()));
            }
            joinSeq.addJoin("LEFT OUTER JOIN", this.parseGraphPattern((GraphPattern)e, optionalBindings), requiredBindings);
            this.addNewMappings(optionalBindings, allBindings);
        }
        StringBuilder sql = new StringBuilder();
        if (joinSeq == null) {
            return Arrays.asList("SELECT 1 WHERE 1=0");
        }
        sql.append("SELECT " + this.generateTargets(allBindings) + " FROM " + joinSeq);
        StringBuilder additional = new StringBuilder();
        if (this.valueBindings.size() > 0) {
            additional.append(" WHERE ");
            ArrayList<String> valueKeys = new ArrayList<String>(this.valueBindings.keySet());
            for (int i = 0; i < valueKeys.size(); ++i) {
                ArrayList values = new ArrayList(this.valueBindings.get(valueKeys.get(i)));
                for (int j = 0; j < values.size(); ++j) {
                    if (i > 0 || j > 0) {
                        sql.append(" AND ");
                    }
                    LOG.debug((Object)("Adding remaining unused binding for " + valueKeys.get(i) + ", " + (String)values.get(j) + "\n"));
                    additional.append((String)values.get(j));
                }
            }
        }
        if (!additional.toString().equals(" WHERE ")) {
            sql.append(additional.toString());
        }
        if (this.ordering != null) {
            sql.append(" ORDER BY " + allBindings.get(this.ordering) + " " + this.orderingDirection);
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(sql.toString());
        return sqlList;
    }

    @Override
    public List<String> getTargets() {
        return new ArrayList<String>(this.targets);
    }

    /*
     * WARNING - void declaration
     */
    private Joinable parseGraphPattern(GraphPattern g, HashMap<String, String> variableBindings) throws QueryException {
        void var6_11;
        LOG.debug((Object)("parsing graph pattern " + g));
        HashMap<String, Set<MappableNodeFilter>> filters = new HashMap<String, Set<MappableNodeFilter>>();
        HashSet<MappableNodeFilter<Node>> givenFilters = new HashSet<MappableNodeFilter<Node>>();
        for (NodeFilter<Node> nodeFilter : g.getFilters()) {
            givenFilters.add(new MappableNodeFilter<Node>(nodeFilter));
        }
        for (MappableNodeFilter mappableNodeFilter : givenFilters) {
            if (((MappableNodePattern)mappableNodeFilter.getNode()).isVariable()) {
                if (!filters.containsKey(((MappableNodePattern)mappableNodeFilter.getNode()).getVarName())) {
                    LOG.debug((Object)("Adding " + ((MappableNodePattern)mappableNodeFilter.getNode()).getVarName() + " To filter pool..\n"));
                    filters.put(((MappableNodePattern)mappableNodeFilter.getNode()).getVarName(), new HashSet());
                }
                ((Set)filters.get(((MappableNodePattern)mappableNodeFilter.getNode()).getVarName())).add(mappableNodeFilter);
            }
            if (((MappableNodePattern)mappableNodeFilter.getConstraint()).isVariable()) {
                if (!filters.containsKey(((MappableNodePattern)mappableNodeFilter.getConstraint()).getVarName())) {
                    LOG.debug((Object)("Adding " + ((MappableNodePattern)mappableNodeFilter.getConstraint()).getVarName() + " To filter pool..\n"));
                    filters.put(((MappableNodePattern)mappableNodeFilter.getConstraint()).getVarName(), new HashSet());
                }
                ((Set)filters.get(((MappableNodePattern)mappableNodeFilter.getConstraint()).getVarName())).add(mappableNodeFilter);
            }
            if (((MappableNodePattern)mappableNodeFilter.getNode()).isVariable() || ((MappableNodePattern)mappableNodeFilter.getConstraint()).isVariable()) continue;
            throw new IllegalArgumentException("Triple filters must contain a variable.  Neither " + ((MappableNodePattern)mappableNodeFilter.getNode()).getVarName() + " nor " + ((MappableNodePattern)mappableNodeFilter.getConstraint()).getVarName() + " is a variable!");
        }
        LinkedList<MappableTriplePattern> steps = new LinkedList<MappableTriplePattern>();
        for (TriplePattern p : g.getTriplePatterns()) {
            steps.add(new MappableTriplePattern(p));
        }
        Object var6_10 = null;
        boolean successfullyBoundFirstStep = false;
        while (!steps.isEmpty()) {
            MappableTriplePattern mappableTriplePattern = (MappableTriplePattern)steps.removeFirst();
            if (!this.bindPattern(mappableTriplePattern, variableBindings)) continue;
            successfullyBoundFirstStep = true;
            break;
        }
        if (!successfullyBoundFirstStep) {
            LOG.info((Object)("Pattern is entirely redundant.  Ignoring: " + g));
            return null;
        }
        JoinSequence joins = new JoinSequence(new JoinTable((MappableTriplePattern)var6_11));
        Set<MappableNodePattern> joinableVars = joins.joinVars();
        while (!steps.isEmpty()) {
            MappableTriplePattern mappableTriplePattern = this.getJoinablePattern(steps, variableBindings);
            if (mappableTriplePattern == null) {
                throw new QueryException("Cannot bind all query steps! \nremaining:\n" + steps + "\nvariables already bound:\n " + variableBindings.keySet() + "\n");
            }
            steps.remove(mappableTriplePattern);
            this.bindPattern(mappableTriplePattern, variableBindings);
            JoinTable table = new JoinTable(mappableTriplePattern);
            joinableVars.addAll(table.joinVars());
            JoinConditions conditions = new JoinConditions();
            this.addJoinConditions(conditions, mappableTriplePattern, variableBindings);
            this.addFilterConditions(conditions, filters, joinableVars, variableBindings);
            for (MappableNodePattern var : joinableVars) {
                if (!this.valueBindings.containsKey(var.boundTable().alias())) continue;
                for (String condition : this.valueBindings.get(var.boundTable().alias())) {
                    LOG.debug((Object)("parseGraphPattern: Adding remaining constant conditions " + condition + "\n"));
                    conditions.addCondition(condition);
                }
                this.valueBindings.remove(var.boundTable().alias());
            }
            joins.addJoin("JOIN", (Joinable)table, conditions);
        }
        if (filters.values().size() > 0 && g.getTriplePatterns().size() > 1) {
            throw new QueryException("Filter is unbound");
        }
        MappableTriplePattern p = new MappableTriplePattern(g.getTriplePatterns().get(0));
        for (String varName : filters.keySet()) {
            for (MappableNodeFilter f : (Set)filters.get(varName)) {
                this.processFilter(p, varName, f);
            }
        }
        return joins;
    }

    private void addJoinConditions(JoinConditions conditions, MappableTriplePattern step, HashMap<String, String> variableBindings) {
        for (MappableNodePattern<? extends Node> p : step.getNodes()) {
            if (!this.isBound(p, variableBindings) || p.mappedName().equals(this.getBoundValue(p, variableBindings))) continue;
            LOG.debug((Object)("parseGraphPattern: Adding Join Condition " + p.mappedName() + " = " + this.getBoundValue(p, variableBindings) + "\n"));
            conditions.addCondition(p.mappedName(), " = ", this.getBoundValue(p, variableBindings));
            if (!this.valueBindings.containsKey(p.boundTable().alias())) continue;
            LOG.debug((Object)("Removing value binding from queue: " + p.mappedName() + " = " + this.getBoundValue(p, variableBindings) + "\n"));
            this.valueBindings.get(p.boundTable().alias()).remove(p.mappedName() + " = " + this.getBoundValue(p, variableBindings));
        }
    }

    private void addFilterConditions(JoinConditions conditions, HashMap<String, Set<MappableNodeFilter>> filters, Set<MappableNodePattern> joinableVars, HashMap<String, String> variableBindings) {
        for (String filterVar : new ArrayList<String>(filters.keySet())) {
            for (MappableNodePattern joinableVar : joinableVars) {
                if (!joinableVar.isVariable() || !joinableVar.getVarName().equals(filterVar)) continue;
                for (MappableNodeFilter f : filters.get(filterVar)) {
                    String left = ((MappableNodePattern)f.getNode()).isVariable() && ((MappableNodePattern)f.getNode()).getVarName().equals(filterVar) ? this.getBoundValue(joinableVar, variableBindings) : (((MappableNodePattern)f.getNode()).isVariable() ? this.getBoundValue((MappableNodePattern)f.getNode(), variableBindings) : DBUtil.quotedString(((MappableNodePattern)f.getNode()).getNode().toString(), this.backslashEscape));
                    String right = ((MappableNodePattern)f.getConstraint()).isVariable() && ((MappableNodePattern)f.getConstraint()).getVarName().equals(filterVar) ? this.getBoundValue(joinableVar, variableBindings) : (((MappableNodePattern)f.getConstraint()).isVariable() ? this.getBoundValue((MappableNodePattern)f.getConstraint(), variableBindings) : DBUtil.quotedString(((MappableNodePattern)f.getConstraint()).getNode().toString(), this.backslashEscape));
                    conditions.addCondition(left, f.getOperator(), right);
                    LOG.debug((Object)("parseGraphPattern: Adding filter condition: " + left + " " + f.getOperator() + " " + right + "\n"));
                }
                this.removeFromMap(filters.get(filterVar), filters);
            }
        }
    }

    private void processFilter(MappableTriplePattern p, String varName, MappableNodeFilter f) throws QueryException {
        String mappedName;
        if (((MappableNodePattern)p.getSubject()).isVariable() && ((MappableNodePattern)p.getSubject()).getVarName().equals(varName)) {
            mappedName = ((MappableNodePattern)p.getSubject()).mappedName();
        } else if (((MappableNodePattern)p.getObject()).isVariable() && ((MappableNodePattern)p.getObject()).getVarName().equals(varName)) {
            mappedName = ((MappableNodePattern)p.getObject()).mappedName();
        } else {
            throw new QueryException("Variable " + varName + " in filter Cannot be found in graph query");
        }
        if (!this.valueBindings.containsKey(mappedName)) {
            this.valueBindings.put(mappedName, new HashSet());
        }
        if (((MappableNodePattern)f.getNode()).isVariable() && ((MappableNodePattern)f.getNode()).getVarName().equals(varName)) {
            if (((MappableNodePattern)f.getConstraint()).isVariable()) {
                LOG.warn((Object)"Node filter constraint is variable?  It's probably not legal to be here...");
            } else {
                this.valueBindings.get(mappedName).add(mappedName + " " + f.getOperator() + " " + DBUtil.quotedString(((MappableNodePattern)f.getConstraint()).getNode().toString(), this.backslashEscape));
                LOG.debug((Object)("Remaining Filters: " + mappedName + " " + f.getOperator() + " '" + ((MappableNodePattern)f.getConstraint()).getNode() + "'" + "\n"));
            }
        } else if (((MappableNodePattern)f.getConstraint()).isVariable() && ((MappableNodePattern)f.getConstraint()).getVarName().equals(varName)) {
            if (((MappableNodePattern)f.getNode()).isVariable()) {
                LOG.warn((Object)"Node filter constraint is variable and node is variable?  It's probably not legal to be here...");
            } else {
                this.valueBindings.get(mappedName).add(DBUtil.quotedString(((MappableNodePattern)f.getNode()).getNode().toString(), this.backslashEscape) + " " + f.getOperator() + " " + mappedName);
                LOG.debug((Object)("Remaining Filters: '" + ((MappableNodePattern)f.getNode()).getNode() + "' " + f.getOperator() + " " + mappedName + "\n"));
            }
        }
    }

    private MappableTriplePattern getJoinablePattern(List<MappableTriplePattern> l, HashMap<String, String> variableBindings) {
        for (MappableTriplePattern p : l) {
            if (!this.isBound((MappableNodePattern)p.getSubject(), variableBindings) && !this.isBound((MappableNodePattern)p.getObject(), variableBindings)) continue;
            return p;
        }
        return null;
    }

    private boolean isBound(MappableNodePattern n, HashMap<String, String> variableBindings) {
        if (n.isVariable()) {
            return variableBindings.containsKey(n.getVarName());
        }
        return true;
    }

    private String getBoundValue(MappableNodePattern n, HashMap<String, String> variableBindings) {
        if (n.isVariable()) {
            return variableBindings.get(n.getVarName());
        }
        return DBUtil.quotedString(n.getNode().toString(), this.backslashEscape);
    }

    private boolean bindPattern(MappableTriplePattern t, HashMap<String, String> variableBindings) {
        if (!this.encounteredPatterns.contains(t)) {
            this.encounteredPatterns.add(t);
            LOG.debug((Object)("Processing new pattern " + t));
            t.bindTo(this.manager.mapPredicateTable((MappableNodePattern<PredicateNode>)t.getPredicate()));
            this.bindNode((MappableNodePattern)t.getSubject(), variableBindings);
            this.bindNode((MappableNodePattern)t.getObject(), variableBindings);
            return true;
        }
        LOG.info((Object)("Already encountered pattern " + t));
        return false;
    }

    private void bindNode(MappableNodePattern p, HashMap<String, String> variableBindings) {
        if (p.isVariable()) {
            StringBuilder existing = new StringBuilder();
            for (String variable : variableBindings.keySet()) {
                existing.append(variable + " = " + variableBindings.get(variable) + "\n");
            }
            LOG.debug((Object)("Considering " + p.getVarName() + " with respect to \n" + existing));
            if (!variableBindings.containsKey(p.getVarName())) {
                LOG.debug((Object)("Bound " + p.getVarName() + " to " + p.mappedName() + "\n"));
                variableBindings.put(p.getVarName(), p.mappedName());
            }
        } else {
            if (!this.valueBindings.containsKey(p.boundTable().alias())) {
                this.valueBindings.put(p.boundTable().alias(), new HashSet());
            }
            LOG.debug((Object)("bindNode: adding valueBinding " + p.mappedName() + " = " + "'" + p.getNode() + "'\n"));
            this.valueBindings.get(p.boundTable().alias()).add(p.mappedName() + " = " + DBUtil.quotedString(p.getNode().toString(), this.backslashEscape));
        }
    }

    private <K, V> void removeFromMap(V value, Map<K, V> m) {
        HashSet<K> toRemove = new HashSet<K>();
        for (Map.Entry<K, V> e : m.entrySet()) {
            if (!e.getValue().equals(value)) continue;
            toRemove.add(e.getKey());
        }
        for (Map.Entry<K, V> key : toRemove) {
            m.remove(key);
        }
    }

    private String generateTargets(HashMap<String, String> variableBindings) {
        String selects = "";
        for (int i = 0; i < this.targets.size(); ++i) {
            selects = selects + variableBindings.get(this.targets.get(i));
            if (i >= this.targets.size() - 1) continue;
            selects = selects + ", ";
        }
        return selects;
    }

    private <K, V> void addNewMappings(Map<K, V> from, Map<K, V> to) {
        for (K key : from.keySet()) {
            if (to.containsKey(key)) continue;
            to.put(key, from.get(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MappingManager {
        private HashMap<String, List<String>> predicateMap = new HashMap();
        private HashMap<PredicateNode, MPTable> nonexistantMappings = new HashMap();
        private final TableManager adaptor;
        private int allMap = 0;

        public MappingManager(TableManager mgr) {
            this.adaptor = mgr;
        }

        public MPTable mapPredicateTable(MappableNodePattern<PredicateNode> predicate) {
            List<Object> aliases;
            String alias;
            String tableName;
            if (predicate.isVariable()) {
                throw new IllegalArgumentException("predicate must not be a variable");
            }
            if (predicate.isVariable()) {
                tableName = this.allTableQuery();
                alias = "ap_" + ++this.allMap;
            } else {
                tableName = this.adaptor.getTableFor(predicate.getNode());
            }
            if (tableName == null) {
                alias = "np_" + this.nonexistantMappings.size();
                tableName = "(SELECT p AS s, p AS o from tmap where 1=0)";
                if (!this.nonexistantMappings.containsKey(predicate.getNode())) {
                    alias = "np_" + this.nonexistantMappings.size();
                    LOG.debug((Object)("No table for '" + predicate.getNode() + "'.  Using empty table as " + alias));
                    tableName = "(SELECT p AS s, p AS o from tmap where 1=0)";
                    this.nonexistantMappings.put(predicate.getNode(), new MPTable(tableName, alias));
                    this.predicateMap.put(predicate.getNode().toString(), new ArrayList());
                    return this.nonexistantMappings.get(predicate.getNode());
                }
                List<String> aliases2 = this.predicateMap.get(predicate.getNode().toString());
                String primaryAlias = this.nonexistantMappings.get(predicate.getNode()).alias();
                alias = primaryAlias + "_" + aliases2.size();
                LOG.debug((Object)("Nonexistant predicate already encountered.   Using alias " + alias));
                return new MPTable(tableName, alias);
            }
            if (this.predicateMap.containsKey(predicate.getNode().toString())) {
                LOG.debug((Object)"Predicate already encountered.  Making new table alias");
                aliases = this.predicateMap.get(predicate.getNode().toString());
                alias = tableName + "_" + aliases.size();
                aliases.add(alias);
            } else {
                LOG.debug((Object)"Predicate never encountered.  Will refer to it by its own name");
                aliases = new ArrayList<String>();
                ((ArrayList)aliases).add(tableName);
                this.predicateMap.put(predicate.getNode().toString(), aliases);
                alias = tableName;
            }
            LOG.debug((Object)("Mapping predicate " + predicate.getNode().getValue() + " to " + tableName + " as " + alias));
            MPTable table = new MPTable(tableName, alias);
            return table;
        }

        private String allTableQuery() {
            boolean first = true;
            StringBuilder allTable = new StringBuilder();
            allTable.append("( ");
            for (PredicateNode predicate : this.adaptor.getPredicates()) {
                if (first) {
                    first = false;
                } else {
                    allTable.append(" UNION ALL ");
                }
                allTable.append(" SELECT * from " + this.adaptor.getTableFor(predicate));
            }
            allTable.append(")");
            return allTable.toString();
        }
    }

    private class JoinType {
        public static final String LEFT_OUTER_JOIN = "LEFT OUTER JOIN";
        public static final String INNER_JOIN = "JOIN";

        private JoinType() {
        }
    }

    private class JoinConditions {
        private Set<String> conditions = new HashSet<String>();

        private JoinConditions() {
        }

        public void addCondition(String leftOperand, String operator, String rightOperand) {
            this.addCondition(leftOperand.trim() + " " + operator.trim() + " " + rightOperand.trim());
        }

        public void addCondition(String condition) {
            this.conditions.add(condition.trim());
        }

        public String toString() {
            StringBuilder joinClause = new StringBuilder();
            for (String condition : this.conditions) {
                if (joinClause.length() == 0) {
                    joinClause.append(condition);
                    continue;
                }
                joinClause.append(" AND " + condition);
            }
            return joinClause.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinSequence
    implements Joinable {
        private final StringBuilder join;
        private int joinCount = 0;
        private final List<Joinable> joined = new ArrayList<Joinable>();

        public JoinSequence(Joinable start) {
            this.join = new StringBuilder(start.declaration());
            this.joined.add(start);
            this.joinCount = 1;
        }

        public void addJoin(String joinType, Joinable j, String joinConstraints) {
            if (j == null) {
                LOG.info((Object)"Skipping join");
                return;
            }
            this.join.append(" " + joinType + " " + j.declaration());
            this.joined.add(j);
            if (joinConstraints != null && joinConstraints != "") {
                this.join.append(" ON (" + joinConstraints + ")");
            }
            ++this.joinCount;
        }

        public void addJoin(String joinType, Joinable j, JoinConditions conditions) {
            this.addJoin(joinType, j, conditions.toString());
        }

        public void addJoin(String joinType, Joinable j, HashMap<String, String> variableBindings) {
            if (j == null) {
                LOG.info((Object)"Skipping join");
                return;
            }
            JoinConditions conditions = new JoinConditions();
            for (MappableNodePattern existingVar : this.joinVars()) {
                for (MappableNodePattern candidateVar : j.joinVars()) {
                    String existingVarName = existingVar.getVarName();
                    String candidateVarName = candidateVar.getVarName();
                    String candidateBinding = variableBindings.get(candidateVar.getVarName());
                    String existingBinding = existingVar.mappedName();
                    if (!existingVarName.equals(candidateVarName) || !existingBinding.equals(candidateBinding)) continue;
                    conditions.addCondition(existingBinding, " = ", candidateVar.mappedName());
                }
            }
            this.addJoin(joinType, j, conditions);
        }

        @Override
        public Set<MappableNodePattern> joinVars() {
            HashSet<MappableNodePattern> joinVars = new HashSet<MappableNodePattern>();
            for (Joinable joinable : this.joined) {
                joinVars.addAll(joinable.joinVars());
            }
            return joinVars;
        }

        @Override
        public String alias() {
            if (this.joinCount == 1) {
                return this.join.toString();
            }
            return "(" + this.join.toString() + ")";
        }

        @Override
        public String declaration() {
            return this.alias();
        }

        public String toString() {
            return this.join.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinTable
    implements Joinable {
        private final MappableTriplePattern t;

        public JoinTable(MappableTriplePattern tPattern) {
            this.t = tPattern;
        }

        @Override
        public Set<MappableNodePattern> joinVars() {
            HashSet<MappableNodePattern> s = new HashSet<MappableNodePattern>();
            if (((MappableNodePattern)this.t.getSubject()).isVariable()) {
                s.add((MappableNodePattern)this.t.getSubject());
            }
            if (((MappableNodePattern)this.t.getObject()).isVariable()) {
                s.add((MappableNodePattern)this.t.getObject());
            }
            return s;
        }

        @Override
        public String alias() {
            return ((MappableNodePattern)this.t.getSubject()).boundTable().alias();
        }

        @Override
        public String declaration() {
            String alias = ((MappableNodePattern)this.t.getSubject()).boundTable().alias();
            String name = ((MappableNodePattern)this.t.getSubject()).boundTable().name();
            if (name.equals(alias)) {
                return name;
            }
            return name + " AS " + alias;
        }

        public String toString() {
            return this.declaration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Joinable {
        public Set<MappableNodePattern> joinVars();

        public String alias();

        public String declaration();
    }
}

