/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.query.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.nsdl.mptstore.core.TableManager;
import org.nsdl.mptstore.query.component.TriplePattern;
import org.nsdl.mptstore.query.provider.SQLProvider;
import org.nsdl.mptstore.rdf.ObjectNode;
import org.nsdl.mptstore.rdf.PredicateNode;
import org.nsdl.mptstore.rdf.SubjectNode;
import org.nsdl.mptstore.util.DBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriplePatternSQLProvider
implements SQLProvider {
    private static final Logger LOG = Logger.getLogger((String)TriplePatternSQLProvider.class.getName());
    private TableManager _tableManager;
    private boolean _backslashIsEscape;
    private List<String> _targets;
    private String _subjectString;
    private String _objectString;
    private List<String> _sql;

    public TriplePatternSQLProvider(TableManager tableManager, boolean backslashIsEscape, TriplePattern pattern, List<String> targets) {
        this._tableManager = tableManager;
        this._backslashIsEscape = backslashIsEscape;
        this._targets = targets;
        SubjectNode subject = pattern.getSubject().getNode();
        PredicateNode predicate = pattern.getPredicate().getNode();
        ObjectNode object = pattern.getObject().getNode();
        if (subject != null) {
            this._subjectString = subject.toString();
        }
        if (object != null) {
            this._objectString = object.toString();
        }
        this._sql = new ArrayList<String>();
        if (predicate != null) {
            this.addSelect(predicate);
        } else {
            Iterator<PredicateNode> preds = this._tableManager.getPredicates().iterator();
            while (preds.hasNext()) {
                this.addSelect(preds.next());
            }
        }
    }

    private void addSelect(PredicateNode predicate) {
        String table = this._tableManager.getTableFor(predicate);
        if (table != null) {
            StringBuffer select = new StringBuffer();
            select.append("SELECT s, ");
            select.append(DBUtil.quotedString(predicate.toString(), this._backslashIsEscape));
            select.append(", o\nFROM ");
            select.append(table);
            if (this._subjectString != null || this._objectString != null) {
                select.append("\nWHERE ");
                if (this._subjectString != null) {
                    select.append("s = ");
                    select.append(DBUtil.quotedString(this._subjectString, this._backslashIsEscape));
                    if (this._objectString != null) {
                        select.append("\nAND ");
                    }
                }
                if (this._objectString != null) {
                    select.append("o = ");
                    select.append(DBUtil.quotedString(this._objectString, this._backslashIsEscape));
                }
            }
            String sqlString = select.toString();
            LOG.info((Object)("Generated query:\n" + sqlString));
            this._sql.add(sqlString);
        }
    }

    @Override
    public List<String> getTargets() {
        return this._targets;
    }

    @Override
    public List<String> getSQL() {
        return this._sql;
    }
}

