/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrdf.graph.Literal;
import org.jrdf.graph.TypedNodeVisitor;

public abstract class AbstractLiteral
implements Literal {
    protected String lexicalForm = null;
    protected String language = null;
    protected boolean wellFormedXML = false;
    protected URI datatypeURI = null;
    private static final Pattern pattern;
    private transient Matcher matcher;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getLexicalForm() {
        return this.lexicalForm;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isWellFormedXML() {
        return this.wellFormedXML;
    }

    public URI getDatatypeURI() {
        return this.datatypeURI;
    }

    public void accept(TypedNodeVisitor typedNodeVisitor) {
        typedNodeVisitor.visitLiteral(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object != null) {
            try {
                Literal literal = (Literal)object;
                if (this.getLexicalForm().equals(literal.getLexicalForm())) {
                    if (this.getDatatypeURI() == null && literal.getDatatypeURI() == null) {
                        if (String.valueOf(this.getLanguage()).equals(String.valueOf(literal.getLanguage()))) {
                            bl = true;
                        }
                    } else if (this.getDatatypeURI() != null && literal.getDatatypeURI() != null && this.getDatatypeURI().toString().equals(literal.getDatatypeURI().toString())) {
                        bl = true;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.getLexicalForm().hashCode();
        if (this.getDatatypeURI() != null) {
            n ^= this.getDatatypeURI().hashCode();
        }
        if (this.getLanguage() != null) {
            n ^= this.getLanguage().hashCode();
        }
        return n;
    }

    public String getEscapedForm() {
        return this.escape(this.getLexicalForm());
    }

    public String toString() {
        return this.getLexicalForm();
    }

    private String escape(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (this.matcher == null) {
            this.matcher = pattern.matcher(string);
        } else {
            this.matcher.reset(string);
        }
        if (!$assertionsDisabled && this.matcher == null) {
            throw new AssertionError();
        }
        if (!this.matcher.find()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            String string2;
            String string3 = this.matcher.group();
            block0 : switch (string3.length()) {
                case 1: {
                    switch (string3.charAt(0)) {
                        case '\t': {
                            string2 = "\\\\t";
                            break block0;
                        }
                        case '\n': {
                            string2 = "\\\\n";
                            break block0;
                        }
                        case '\r': {
                            string2 = "\\\\r";
                            break block0;
                        }
                        case '\"': {
                            string2 = "\\\\\\\"";
                            break block0;
                        }
                        case '\\': {
                            string2 = "\\\\\\\\";
                            break block0;
                        }
                    }
                    String string4 = Integer.toHexString(string3.charAt(0)).toUpperCase();
                    string2 = "\\\\u0000".substring(0, 7 - string4.length()) + string4;
                    if (!$assertionsDisabled && string2.length() != 7) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !string2.startsWith("\\\\u")) {
                        throw new AssertionError();
                    }
                    break;
                }
                case 2: {
                    if (!$assertionsDisabled && Character.getType(string3.charAt(0)) != 19) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && Character.getType(string3.charAt(1)) != 19) {
                        throw new AssertionError();
                    }
                    String string4 = Integer.toHexString(((string3.charAt(0) & 0x3FF) << 10) + (string3.charAt(1) & 0x3FF) + 65536).toUpperCase();
                    string2 = "\\\\U00000000".substring(0, 11 - string4.length()) + string4;
                    if (!$assertionsDisabled && string2.length() != 11) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !string2.startsWith("\\\\U000")) {
                        throw new AssertionError();
                    }
                    break;
                }
                default: {
                    throw new Error("Escape sequence " + string3 + " has no handler");
                }
            }
            if (!$assertionsDisabled && string2 == null) {
                throw new AssertionError();
            }
            this.matcher.appendReplacement(stringBuffer, string2);
        } while (this.matcher.find());
        this.matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !AbstractLiteral.class.desiredAssertionStatus();
        pattern = Pattern.compile("\\p{InHighSurrogates}\\p{InLowSurrogates}|[\\x00-\\x1F\\x22\\\\\\x7F-\\uFFFF]");
    }
}

