/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.jrdf.graph.AlreadyReifiedException;
import org.jrdf.graph.Alternative;
import org.jrdf.graph.Bag;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Collection;
import org.jrdf.graph.Container;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.Sequence;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.TripleFactory;
import org.jrdf.graph.TripleFactoryException;
import org.jrdf.graph.URIReference;
import org.jrdf.vocabulary.RDF;

public abstract class AbstractTripleFactory
implements TripleFactory {
    protected Graph graph;
    protected GraphElementFactory elementFactory;

    public void reifyTriple(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode, SubjectNode subjectNode2) throws TripleFactoryException, AlreadyReifiedException {
        try {
            this.reallyReifyTriple(subjectNode, predicateNode, objectNode, subjectNode2);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    public void reifyTriple(Triple triple, SubjectNode subjectNode) throws TripleFactoryException, AlreadyReifiedException {
        try {
            this.reallyReifyTriple(triple.getSubject(), triple.getPredicate(), triple.getObject(), subjectNode);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    private Node reallyReifyTriple(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode, Node node) throws GraphElementFactoryException, AlreadyReifiedException {
        URIReference uRIReference = this.elementFactory.createResource(RDF.SUBJECT);
        URIReference uRIReference2 = this.elementFactory.createResource(RDF.PREDICATE);
        URIReference uRIReference3 = this.elementFactory.createResource(RDF.OBJECT);
        URIReference uRIReference4 = this.elementFactory.createResource(RDF.TYPE);
        URIReference uRIReference5 = this.elementFactory.createResource(RDF.STATEMENT);
        try {
            if (!(!this.graph.contains((SubjectNode)node, uRIReference4, uRIReference5) || this.graph.contains((SubjectNode)node, uRIReference, (ObjectNode)((Object)subjectNode)) && this.graph.contains((SubjectNode)node, uRIReference2, (ObjectNode)((Object)predicateNode)) && this.graph.contains((SubjectNode)node, uRIReference3, objectNode))) {
                throw new AlreadyReifiedException("Node: " + node + " already used in " + "reification");
            }
            this.graph.add((SubjectNode)node, uRIReference4, uRIReference5);
            this.graph.add((SubjectNode)node, uRIReference, (ObjectNode)((Object)subjectNode));
            this.graph.add((SubjectNode)node, uRIReference2, (ObjectNode)((Object)predicateNode));
            this.graph.add((SubjectNode)node, uRIReference3, objectNode);
        }
        catch (GraphException graphException) {
            throw new GraphElementFactoryException(graphException);
        }
        return node;
    }

    public void addAlternative(SubjectNode subjectNode, Alternative alternative) throws TripleFactoryException {
        try {
            this.graph.add(subjectNode, this.elementFactory.createResource(RDF.TYPE), this.elementFactory.createResource(RDF.ALT));
            this.addContainer(subjectNode, alternative);
        }
        catch (GraphException graphException) {
            throw new TripleFactoryException(graphException);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    public void addBag(SubjectNode subjectNode, Bag bag) throws TripleFactoryException {
        try {
            this.graph.add(subjectNode, this.elementFactory.createResource(RDF.TYPE), this.elementFactory.createResource(RDF.BAG));
            this.addContainer(subjectNode, bag);
        }
        catch (GraphException graphException) {
            throw new TripleFactoryException(graphException);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    public void addSequence(SubjectNode subjectNode, Sequence sequence) throws TripleFactoryException {
        try {
            this.graph.add(subjectNode, this.elementFactory.createResource(RDF.TYPE), this.elementFactory.createResource(RDF.SEQ));
            this.addContainer(subjectNode, sequence);
        }
        catch (GraphException graphException) {
            throw new TripleFactoryException(graphException);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
    }

    private void addContainer(SubjectNode subjectNode, Container container) throws TripleFactoryException {
        try {
            long l = 1L;
            Iterator iterator = container.iterator();
            while (iterator.hasNext()) {
                ObjectNode objectNode = (ObjectNode)iterator.next();
                this.graph.add(subjectNode, this.elementFactory.createResource(new URI(RDF.baseURI + "_" + l++)), objectNode);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new TripleFactoryException(uRISyntaxException);
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
        catch (GraphException graphException) {
            throw new TripleFactoryException(graphException);
        }
    }

    public void addCollection(SubjectNode subjectNode, Collection collection) throws TripleFactoryException {
        try {
            URIReference uRIReference = this.elementFactory.createResource(RDF.FIRST);
            URIReference uRIReference2 = this.elementFactory.createResource(RDF.REST);
            URIReference uRIReference3 = this.elementFactory.createResource(RDF.NIL);
            SubjectNode subjectNode2 = subjectNode;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ObjectNode objectNode = (ObjectNode)iterator.next();
                this.graph.add(subjectNode2, uRIReference, objectNode);
                if (iterator.hasNext()) {
                    BlankNode blankNode = this.elementFactory.createResource();
                    this.graph.add(subjectNode2, uRIReference2, blankNode);
                    subjectNode2 = blankNode;
                    continue;
                }
                this.graph.add(subjectNode2, uRIReference2, uRIReference3);
            }
        }
        catch (GraphElementFactoryException graphElementFactoryException) {
            throw new TripleFactoryException(graphElementFactoryException);
        }
        catch (GraphException graphException) {
            throw new TripleFactoryException(graphException);
        }
    }
}

