/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph;

import java.net.URI;
import junit.framework.Test;
import junit.framework.TestCase;
import org.jrdf.graph.AlreadyReifiedException;
import org.jrdf.graph.Alternative;
import org.jrdf.graph.Bag;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Collection;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.Literal;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.Sequence;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.TripleFactory;
import org.jrdf.graph.TripleFactoryException;
import org.jrdf.graph.URIReference;
import org.jrdf.util.ClosableIterator;
import org.jrdf.vocabulary.RDF;

public abstract class AbstractTripleFactoryUnitTest
extends TestCase {
    protected Graph graph;
    protected GraphElementFactory elementFactory;
    protected TripleFactory tripleFactory;
    protected static BlankNode blank1;
    protected static BlankNode blank2;
    protected static URI uri1;
    protected static URI uri2;
    protected static URI uri3;
    protected static URIReference ref1;
    protected static URIReference ref2;
    protected static URIReference ref3;
    protected static final String TEST_STR1 = "A test string";
    protected static final String TEST_STR2 = "Another test string";
    protected static Literal l1;
    protected static Literal l2;

    public AbstractTripleFactoryUnitTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.graph = this.newGraph();
        this.elementFactory = this.graph.getElementFactory();
        this.tripleFactory = this.graph.getTripleFactory();
        blank1 = this.elementFactory.createResource();
        blank2 = this.elementFactory.createResource();
        uri1 = new URI("http://namespace#somevalue");
        uri2 = new URI("http://namespace#someothervalue");
        uri3 = new URI("http://namespace#yetanothervalue");
        ref1 = this.elementFactory.createResource(uri1);
        ref2 = this.elementFactory.createResource(uri2);
        ref3 = this.elementFactory.createResource(uri3);
        l1 = this.elementFactory.createLiteral(TEST_STR1);
        l2 = this.elementFactory.createLiteral(TEST_STR2);
    }

    public static Test suite() {
        return null;
    }

    public abstract Graph newGraph() throws Exception;

    public abstract PredicateNode getReifySubject() throws TripleFactoryException;

    public abstract PredicateNode getReifyPredicate() throws TripleFactoryException;

    public abstract PredicateNode getReifyObject() throws TripleFactoryException;

    public abstract PredicateNode getRdfType() throws TripleFactoryException;

    public abstract ObjectNode getRdfStatement() throws TripleFactoryException;

    public abstract Collection createCollection(ObjectNode[] var1);

    public abstract Alternative createAlternative(ObjectNode[] var1);

    public abstract Bag createBag(ObjectNode[] var1);

    public abstract Sequence createSequence(ObjectNode[] var1);

    public void testReification() throws Exception {
        PredicateNode predicateNode = this.getReifySubject();
        PredicateNode predicateNode2 = this.getReifyPredicate();
        PredicateNode predicateNode3 = this.getReifyObject();
        PredicateNode predicateNode4 = this.getRdfType();
        ObjectNode objectNode = this.getRdfStatement();
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.isEmpty());
        URIReference uRIReference = this.elementFactory.createResource(uri1);
        this.tripleFactory.reifyTriple(blank1, ref1, blank2, uRIReference);
        AbstractTripleFactoryUnitTest.assertEquals((Object)uri1, (Object)uRIReference.getURI());
        AbstractTripleFactoryUnitTest.assertEquals((long)4L, (long)this.graph.getNumberOfTriples());
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference, predicateNode4, objectNode));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference, predicateNode, blank1));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference, predicateNode2, ref1));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference, predicateNode3, blank2));
        Triple triple = this.elementFactory.createTriple(blank1, ref2, blank2);
        uRIReference = this.elementFactory.createResource(uri2);
        this.graph.add(triple);
        this.tripleFactory.reifyTriple(triple, uRIReference);
        AbstractTripleFactoryUnitTest.assertEquals((Object)uri2, (Object)uRIReference.getURI());
        AbstractTripleFactoryUnitTest.assertEquals((long)9L, (long)this.graph.getNumberOfTriples());
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference, predicateNode4, objectNode));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference, predicateNode, blank1));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference, predicateNode2, ref2));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference, predicateNode3, blank2));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blank1, ref2, blank2));
        this.tripleFactory.reifyTriple(blank1, ref1, blank2, this.elementFactory.createResource(uri1));
        AbstractTripleFactoryUnitTest.assertEquals((long)9L, (long)this.graph.getNumberOfTriples());
        this.tripleFactory.reifyTriple(triple, this.elementFactory.createResource(uri2));
        AbstractTripleFactoryUnitTest.assertEquals((long)9L, (long)this.graph.getNumberOfTriples());
        this.tripleFactory.reifyTriple(blank1, ref1, blank2, this.elementFactory.createResource(uri3));
        AbstractTripleFactoryUnitTest.assertEquals((long)13L, (long)this.graph.getNumberOfTriples());
        this.testCantInsert(blank2, ref1, blank1, this.elementFactory.createResource(uri1));
        AbstractTripleFactoryUnitTest.assertEquals((long)13L, (long)this.graph.getNumberOfTriples());
        this.testCantInsert(triple, uri3);
        AbstractTripleFactoryUnitTest.assertEquals((long)13L, (long)this.graph.getNumberOfTriples());
        this.testCantInsert(this.elementFactory.createTriple(blank2, ref2, blank2), uri2);
        AbstractTripleFactoryUnitTest.assertEquals((long)13L, (long)this.graph.getNumberOfTriples());
        BlankNode blankNode = this.elementFactory.createResource();
        this.tripleFactory.reifyTriple(blank1, ref1, l1, blankNode);
        AbstractTripleFactoryUnitTest.assertEquals((long)17L, (long)this.graph.getNumberOfTriples());
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blankNode, predicateNode4, objectNode));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blankNode, predicateNode, blank1));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blankNode, predicateNode2, ref1));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blankNode, predicateNode3, l1));
        triple = this.elementFactory.createTriple(blank1, ref2, l2);
        this.graph.add(triple);
        blankNode = this.elementFactory.createResource();
        this.tripleFactory.reifyTriple(triple, blankNode);
        AbstractTripleFactoryUnitTest.assertEquals((long)22L, (long)this.graph.getNumberOfTriples());
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blankNode, predicateNode4, objectNode));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blankNode, predicateNode, blank1));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blankNode, predicateNode2, ref2));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blankNode, predicateNode3, l2));
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.contains(blank1, ref2, l2));
        this.testCanInsert(blank1, ref1, blank2);
        this.testCantInsert(blank1, ref3, blank2, uRIReference);
        AbstractTripleFactoryUnitTest.assertEquals((long)26L, (long)this.graph.getNumberOfTriples());
        this.testCanInsert(triple);
        this.testCantInsert(this.elementFactory.createTriple(blank1, ref3, blank2), uRIReference.getURI());
        AbstractTripleFactoryUnitTest.assertEquals((long)30L, (long)this.graph.getNumberOfTriples());
        blankNode = this.elementFactory.createResource();
        this.graph.add(ref3, ref3, ref3);
        try {
            this.tripleFactory.reifyTriple(ref3, ref3, ref3, blankNode);
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            AbstractTripleFactoryUnitTest.fail((String)"Should allow reification of an existing");
        }
    }

    public void testCollections() throws Exception {
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.isEmpty());
        URIReference uRIReference = this.elementFactory.createResource(new URI("http://example.org/basket"));
        URIReference uRIReference2 = this.elementFactory.createResource(new URI("http://example.org/stuff/1.0/hasFruit"));
        BlankNode blankNode = this.elementFactory.createResource();
        this.graph.add(uRIReference, uRIReference2, blankNode);
        ObjectNode[] objectNodeArray = new ObjectNode[]{this.elementFactory.createResource(new URI("http://example.org/banana")), this.elementFactory.createResource(new URI("http://example.org/kiwi")), this.elementFactory.createResource(new URI("http://example.org/pineapple"))};
        URIReference uRIReference3 = this.elementFactory.createResource(RDF.FIRST);
        URIReference uRIReference4 = this.elementFactory.createResource(RDF.REST);
        URIReference uRIReference5 = this.elementFactory.createResource(RDF.NIL);
        Collection collection = this.createCollection(objectNodeArray);
        this.tripleFactory.addCollection(blankNode, collection);
        AbstractTripleFactoryUnitTest.assertEquals((String)"Should have seven statements", (long)7L, (long)this.graph.getNumberOfTriples());
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have first statement", (boolean)this.graph.contains(uRIReference, uRIReference2, blankNode));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have first object and first collection object", (boolean)this.graph.contains(blankNode, uRIReference3, objectNodeArray[0]));
        ClosableIterator closableIterator = this.graph.find(null, uRIReference3, null);
        int n = 0;
        while (closableIterator.hasNext()) {
            closableIterator.next();
            ++n;
        }
        AbstractTripleFactoryUnitTest.assertTrue((String)("Should have three rdf:first statements, not " + n), (n == 3 ? 1 : 0) != 0);
        for (int i = 0; i < objectNodeArray.length; ++i) {
            AbstractTripleFactoryUnitTest.assertTrue((String)("Should contain: " + objectNodeArray[i]), (boolean)this.graph.contains(null, uRIReference3, objectNodeArray[i]));
        }
        closableIterator = this.graph.find(null, uRIReference4, null);
        n = 0;
        while (closableIterator.hasNext()) {
            closableIterator.next();
            ++n;
        }
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have three rdf:rest statements", (n == 3 ? 1 : 0) != 0);
        closableIterator = this.graph.find(null, uRIReference4, uRIReference5);
        n = 0;
        while (closableIterator.hasNext()) {
            closableIterator.next();
            ++n;
        }
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have one rdf:rest with rdf:nil statements", (n == 1 ? 1 : 0) != 0);
    }

    public void testAlternative() throws Exception {
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.isEmpty());
        URIReference uRIReference = this.elementFactory.createResource(new URI("http://example.org/favourite-bananas"));
        ObjectNode[] objectNodeArray = new ObjectNode[]{this.elementFactory.createResource(new URI("http://example.org/banana")), this.elementFactory.createResource(new URI("http://example.org/cavendish")), this.elementFactory.createResource(new URI("http://example.org/ladyfinger")), this.elementFactory.createResource(new URI("http://example.org/banana"))};
        URIReference uRIReference2 = this.elementFactory.createResource(RDF.TYPE);
        URIReference uRIReference3 = this.elementFactory.createResource(RDF.ALT);
        Alternative alternative = this.createAlternative(objectNodeArray);
        this.tripleFactory.addAlternative(uRIReference, alternative);
        AbstractTripleFactoryUnitTest.assertEquals((String)"Should have five statements", (long)4L, (long)this.graph.getNumberOfTriples());
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, uRIReference2, uRIReference3));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, null, objectNodeArray[0]));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, null, objectNodeArray[1]));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, null, objectNodeArray[2]));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, null, objectNodeArray[3]));
        ClosableIterator closableIterator = this.graph.find(null, null, objectNodeArray[0]);
        int n = 0;
        while (closableIterator.hasNext()) {
            closableIterator.next();
            ++n;
        }
        AbstractTripleFactoryUnitTest.assertTrue((String)("Should have only the same statements: " + objectNodeArray[0]), (n == 1 ? 1 : 0) != 0);
    }

    public void testBag() throws Exception {
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.isEmpty());
        URIReference uRIReference = this.elementFactory.createResource(new URI("http://example.org/favourite-fruit"));
        ObjectNode[] objectNodeArray = new ObjectNode[]{this.elementFactory.createResource(new URI("http://example.org/banana")), this.elementFactory.createResource(new URI("http://example.org/kiwi")), this.elementFactory.createResource(new URI("http://example.org/pineapple")), this.elementFactory.createResource(new URI("http://example.org/pineapple")), this.elementFactory.createResource(new URI("http://example.org/banana"))};
        URIReference uRIReference2 = this.elementFactory.createResource(RDF.TYPE);
        URIReference uRIReference3 = this.elementFactory.createResource(RDF.BAG);
        Bag bag = this.createBag(objectNodeArray);
        this.tripleFactory.addBag(uRIReference, bag);
        AbstractTripleFactoryUnitTest.assertEquals((String)"Should have six statements", (long)6L, (long)this.graph.getNumberOfTriples());
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, uRIReference2, uRIReference3));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, null, objectNodeArray[0]));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, null, objectNodeArray[1]));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, null, objectNodeArray[2]));
        ClosableIterator closableIterator = this.graph.find(uRIReference, null, objectNodeArray[2]);
        int n = 0;
        while (closableIterator.hasNext()) {
            closableIterator.next();
            ++n;
        }
        AbstractTripleFactoryUnitTest.assertTrue((String)("Should have two of the same statements: " + objectNodeArray[2]), (n == 2 ? 1 : 0) != 0);
    }

    public void testSequence() throws Exception {
        AbstractTripleFactoryUnitTest.assertTrue((boolean)this.graph.isEmpty());
        URIReference uRIReference = this.elementFactory.createResource(new URI("http://example.org/favourite-fruit"));
        ObjectNode[] objectNodeArray = new ObjectNode[]{this.elementFactory.createResource(new URI("http://example.org/banana")), this.elementFactory.createResource(new URI("http://example.org/kiwi")), this.elementFactory.createResource(new URI("http://example.org/pineapple")), this.elementFactory.createResource(new URI("http://example.org/kiwi"))};
        URIReference uRIReference2 = this.elementFactory.createResource(RDF.TYPE);
        URIReference uRIReference3 = this.elementFactory.createResource(new URI(RDF.baseURI + "_1"));
        URIReference uRIReference4 = this.elementFactory.createResource(new URI(RDF.baseURI + "_2"));
        URIReference uRIReference5 = this.elementFactory.createResource(new URI(RDF.baseURI + "_3"));
        URIReference uRIReference6 = this.elementFactory.createResource(new URI(RDF.baseURI + "_4"));
        URIReference uRIReference7 = this.elementFactory.createResource(RDF.SEQ);
        Sequence sequence = this.createSequence(objectNodeArray);
        this.tripleFactory.addSequence(uRIReference, sequence);
        AbstractTripleFactoryUnitTest.assertEquals((String)"Should have five statements", (long)5L, (long)this.graph.getNumberOfTriples());
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, uRIReference2, uRIReference7));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, uRIReference3, objectNodeArray[0]));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, uRIReference4, objectNodeArray[1]));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, uRIReference5, objectNodeArray[2]));
        AbstractTripleFactoryUnitTest.assertTrue((String)"Should have statement", (boolean)this.graph.contains(uRIReference, uRIReference6, objectNodeArray[3]));
    }

    private void testCantInsert(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode, SubjectNode subjectNode2) throws Exception {
        try {
            this.tripleFactory.reifyTriple(subjectNode, predicateNode, objectNode, subjectNode2);
            AbstractTripleFactoryUnitTest.assertTrue((boolean)false);
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            // empty catch block
        }
    }

    private void testCantInsert(Triple triple, URI uRI) throws Exception {
        try {
            this.tripleFactory.reifyTriple(triple, this.elementFactory.createResource(uRI));
            AbstractTripleFactoryUnitTest.assertTrue((boolean)false);
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            // empty catch block
        }
    }

    private void testCanInsert(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode) throws Exception {
        try {
            this.tripleFactory.reifyTriple(subjectNode, predicateNode, objectNode, this.elementFactory.createResource());
            AbstractTripleFactoryUnitTest.assertTrue((boolean)true);
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            // empty catch block
        }
    }

    private void testCanInsert(Triple triple) throws Exception {
        try {
            this.tripleFactory.reifyTriple(triple, this.elementFactory.createResource());
            AbstractTripleFactoryUnitTest.assertTrue((boolean)true);
        }
        catch (AlreadyReifiedException alreadyReifiedException) {
            // empty catch block
        }
    }
}

