/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph.mem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jrdf.graph.Alternative;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.mem.AbstractUnorderedContainer;

public class AlternativeImpl
extends AbstractUnorderedContainer
implements Alternative {
    public boolean containsAll(Collection collection) {
        if (!(collection instanceof Alternative)) {
            throw new IllegalArgumentException("Can only add alts to other alts");
        }
        return this.elements.values().containsAll(collection);
    }

    public boolean add(Object object) throws IllegalArgumentException {
        if (!(object instanceof ObjectNode)) {
            throw new IllegalArgumentException("Can only add Object nodes");
        }
        if (!this.elements.containsValue(object)) {
            this.elements.put(new Long(this.key++), object);
        }
        return true;
    }

    public boolean addAll(Collection collection) throws IllegalArgumentException {
        if (!(collection instanceof Alternative)) {
            throw new IllegalArgumentException("Can only add alts to other alts");
        }
        Alternative alternative = (Alternative)collection;
        Iterator iterator = alternative.iterator();
        boolean bl = iterator.hasNext();
        while (iterator.hasNext()) {
            ObjectNode objectNode = (ObjectNode)iterator.next();
            this.elements.put(new Long(this.key++), objectNode);
        }
        return bl;
    }

    public boolean removeAll(Collection collection) throws IllegalArgumentException {
        if (!(collection instanceof Alternative)) {
            throw new IllegalArgumentException("Can only add bags to other bags");
        }
        Alternative alternative = (Alternative)collection;
        Iterator iterator = alternative.iterator();
        boolean bl = iterator.hasNext();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
        return bl;
    }

    public boolean retainAll(Collection collection) throws IllegalArgumentException {
        if (!(collection instanceof Alternative)) {
            throw new IllegalArgumentException("Can only add bags to other bags");
        }
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ObjectNode objectNode = (ObjectNode)iterator.next();
            if (collection.contains(objectNode)) continue;
            bl = true;
            this.remove(objectNode);
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Alternative alternative = (Alternative)object;
        boolean bl = false;
        if (this.size() == alternative.size()) {
            List<Object> list = Arrays.asList(this.toArray());
            List<Object> list2 = Arrays.asList(alternative.toArray());
            bl = ((Object)list).equals(list2);
        }
        return bl;
    }
}

