/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.bvalid.ValidatorException;
import net.sf.bvalid.catalog.FileSchemaIndex;
import net.sf.bvalid.catalog.SchemaCatalog;
import net.sf.bvalid.catalog.SchemaIndex;
import org.apache.log4j.Logger;

public class DiskSchemaCatalog
implements SchemaCatalog {
    private static Logger _LOG = Logger.getLogger((String)DiskSchemaCatalog.class.getName());
    private SchemaIndex _index;
    private File _storageDir;

    public DiskSchemaCatalog(SchemaIndex index, File storageDir) throws ValidatorException {
        this._index = index;
        this._storageDir = storageDir;
        this.pruneStorageDir();
    }

    private void pruneStorageDir() throws ValidatorException {
        HashSet<String> keepNames = new HashSet<String>();
        if (this._index instanceof FileSchemaIndex) {
            File indexFile = ((FileSchemaIndex)this._index).getIndexFile();
            keepNames.add(indexFile.getName());
        }
        Iterator iter = this._index.getURISet().iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            keepNames.add(this._index.getFilename(uri));
        }
        int pruneCount = DiskSchemaCatalog.pruneDir(this._storageDir, keepNames);
        _LOG.info((Object)("Pruned " + pruneCount + " unused file(s) from " + "schema storage directory"));
    }

    public synchronized boolean contains(String uri) throws ValidatorException {
        return this._index.getFilename(uri) != null;
    }

    public synchronized Iterator listURIs() throws ValidatorException {
        return this._index.getURISet().iterator();
    }

    public synchronized InputStream get(String uri) throws ValidatorException {
        String filename = this._index.getFilename(uri);
        if (filename == null) {
            return null;
        }
        try {
            return new FileInputStream(new File(this._storageDir, filename));
        }
        catch (IOException e) {
            _LOG.warn((Object)("Unable to read schema from disk (uri = " + uri + ", filename = " + filename + ")"), (Throwable)e);
            throw new ValidatorException("Error reading schema from disk", e);
        }
    }

    public synchronized void put(String uri, InputStream in) throws ValidatorException {
        long num = System.currentTimeMillis();
        File file = new File(this._storageDir, num + "");
        while (file.exists()) {
            file = new File(this._storageDir, ++num + "");
        }
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            _LOG.debug((Object)("Wrote content for schema (" + uri + ") to file: " + file.getPath()));
        }
        catch (Throwable th) {
            throw new ValidatorException("Unable to write schema content to file: " + file.getPath(), th);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception e) {}
            }
        }
        String oldFilename = this._index.putFilename(uri, file.getName());
        if (oldFilename != null) {
            this.removeSchemaFile(oldFilename);
        }
    }

    public synchronized void remove(String uri) throws ValidatorException {
        String filename = this._index.getFilename(uri);
        if (filename == null) {
            _LOG.warn((Object)("Cannot remove schema; not in index: " + uri));
        } else {
            this.removeSchemaFile(filename);
            this._index.removeMapping(uri);
        }
    }

    private void removeSchemaFile(String filename) {
        File file = new File(filename);
        boolean deleted = file.delete();
        if (!deleted && file.exists()) {
            _LOG.warn((Object)("Cannot remove schema file: " + file.getPath()));
        }
    }

    private static int pruneDir(File dir, Set keepNames) {
        int count = 0;
        try {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String name = file.getName();
                if (!file.isFile() || keepNames.contains(name)) continue;
                boolean deleted = file.delete();
                String msgSuffix = " unused file from storage directory: " + name;
                if (deleted) {
                    _LOG.info((Object)("Pruned" + msgSuffix));
                    ++count;
                    continue;
                }
                _LOG.warn((Object)("Unable to prune" + msgSuffix));
            }
        }
        catch (Throwable th) {
            _LOG.warn((Object)"Error pruning schema storage directory", th);
        }
        return count;
    }
}

