/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid.catalog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.bvalid.ValidatorException;
import net.sf.bvalid.catalog.SchemaIndex;
import org.apache.log4j.Logger;

public class FileSchemaIndex
implements SchemaIndex {
    public static final int DEFAULT_REFRESH_SECONDS = 60;
    private static Logger _LOG = Logger.getLogger((String)FileSchemaIndex.class.getName());
    private File _indexFile;
    private Map _indexMap;
    private int _refreshSeconds;
    private long _nextRefreshTime;

    public FileSchemaIndex(File indexFile) throws ValidatorException {
        this(indexFile, 60);
    }

    public FileSchemaIndex(File indexFile, int refreshSeconds) throws ValidatorException {
        this._indexFile = indexFile;
        this._refreshSeconds = refreshSeconds;
        this.loadIndex(true);
    }

    protected File getIndexFile() {
        return this._indexFile;
    }

    public synchronized Set getURISet() throws ValidatorException {
        this.loadIndex(false);
        return new HashSet(this._indexMap.keySet());
    }

    public synchronized String getFilename(String uri) throws ValidatorException {
        this.loadIndex(false);
        return (String)this._indexMap.get(uri);
    }

    public synchronized String putFilename(String uri, String filename) throws ValidatorException {
        this.loadIndex(true);
        String oldFilename = this._indexMap.put(uri, filename);
        this.saveIndex();
        return oldFilename;
    }

    public synchronized boolean removeMapping(String uri) throws ValidatorException {
        this.loadIndex(true);
        if (this._indexMap.remove(uri) != null) {
            this.saveIndex();
            return true;
        }
        return false;
    }

    private void loadIndex(boolean force) throws ValidatorException {
        if (force || System.currentTimeMillis() >= this._nextRefreshTime) {
            try {
                this._indexMap = FileSchemaIndex.loadIndex(this._indexFile);
                _LOG.debug((Object)("Index loaded, size = " + this._indexMap.size()));
                if (this._refreshSeconds > 0) {
                    this._nextRefreshTime = System.currentTimeMillis() + (long)(1000 * this._refreshSeconds);
                }
            }
            catch (IOException e) {
                throw new ValidatorException("Error loading schema index file", e);
            }
        }
    }

    private void saveIndex() throws ValidatorException {
        try {
            FileSchemaIndex.saveIndex(this._indexFile, this._indexMap);
            _LOG.debug((Object)("Index saved, size = " + this._indexMap.size()));
        }
        catch (IOException e) {
            throw new ValidatorException("Error saving schema index file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map loadIndex(File indexFile) throws IOException {
        if (!indexFile.exists()) {
            return new HashMap();
        }
        FileInputStream in = new FileInputStream(indexFile);
        try {
            HashMap<String, String> indexMap = new HashMap<String, String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            String line = reader.readLine();
            int lineNum = 0;
            while (line != null) {
                ++lineNum;
                if ((line = line.trim()).length() > 0) {
                    String[] parts = line.split(" ");
                    if (parts.length == 2) {
                        indexMap.put(parts[0], parts[1]);
                    } else {
                        _LOG.warn((Object)("Skipping line #" + lineNum + " in schema " + "index file (it did not contain a space " + "delimiter as expected)"));
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            HashMap<String, String> hashMap = indexMap;
            return hashMap;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveIndex(File indexFile, Map indexMap) throws IOException {
        FileOutputStream out = new FileOutputStream(indexFile);
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            Iterator iter = indexMap.keySet().iterator();
            while (iter.hasNext()) {
                String uri = (String)iter.next();
                String filename = (String)indexMap.get(uri);
                writer.println(uri + " " + filename);
            }
            writer.close();
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (Exception exception) {}
        }
    }
}

