/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid.locator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.bvalid.ValidatorException;
import net.sf.bvalid.locator.SchemaLocator;
import net.sf.bvalid.util.HttpInputStream;
import net.sf.bvalid.util.WebClient;
import org.apache.log4j.Logger;

public class URLSchemaLocator
implements SchemaLocator {
    private static Logger _LOG = Logger.getLogger((String)URLSchemaLocator.class.getName());
    private WebClient _client;

    public URLSchemaLocator() {
        this._client = new WebClient();
        this._client.USER_AGENT = "BValid Schema Validator - http://bvalid.sf.net/";
    }

    public URLSchemaLocator(WebClient client) {
        this._client = client;
    }

    public InputStream get(String uri, boolean required) throws ValidatorException {
        try {
            if (uri.startsWith("http://") || uri.startsWith("https://")) {
                HttpInputStream in = this._client.get(uri, true);
                _LOG.info((Object)("Resolved from web via http URL: " + uri));
                return in;
            }
            if (uri.startsWith("file:")) {
                URL fileURL = new URL(uri);
                File localFile = new File(fileURL.getFile());
                if (!localFile.exists()) {
                    throw new IOException("File does not exist: " + localFile.getPath());
                }
                _LOG.info((Object)("Resolved from filesystem via file URL: " + uri));
                return new FileInputStream(localFile);
            }
            throw new ValidatorException("Unrecognized scheme in schema URL: " + uri);
        }
        catch (Exception e) {
            if (!required) {
                _LOG.info((Object)("Not resolved, but not required: " + uri + ": " + " (cause: " + e.getClass().getName() + ": " + e.getMessage() + ")"));
                return null;
            }
            throw new ValidatorException("Unable to resolve schema: " + uri, e);
        }
    }

    public void successfullyUsed(String uri) {
    }
}

