/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;

public class HttpInputStream
extends InputStream {
    private HttpClient _client;
    private HttpMethod _method;
    private String _url;
    private int _code;
    private InputStream _in;

    public HttpInputStream(HttpClient client, HttpMethod method, String url) throws IOException {
        this._client = client;
        this._method = method;
        this._url = url;
        try {
            this._code = this._client.executeMethod(this._method);
            this._in = this._method.getResponseBodyAsStream();
            if (this._in == null) {
                this._in = new ByteArrayInputStream(new byte[0]);
            }
        }
        catch (IOException e) {
            this._method.releaseConnection();
            throw e;
        }
    }

    public String getMethodName() {
        return this._method.getName();
    }

    public String getURL() {
        return this._url;
    }

    public int getStatusCode() {
        return this._code;
    }

    public String getStatusText() {
        return this._method.getStatusLine().getReasonPhrase();
    }

    public Header getResponseHeader(String name) {
        return this._method.getResponseHeader(name);
    }

    public String getResponseHeaderValue(String name, String defaultValue) {
        Header header = this._method.getResponseHeader(name);
        if (header == null) {
            return defaultValue;
        }
        String value = header.getValue();
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return header.getValue();
    }

    public Header[] getResponseHeaders() {
        return this._method.getResponseHeaders();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int read() throws IOException {
        return this._in.read();
    }

    public int read(byte[] b) throws IOException {
        return this._in.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this._in.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this._in.skip(n);
    }

    public int available() throws IOException {
        return this._in.available();
    }

    public void mark(int readlimit) {
        this._in.mark(readlimit);
    }

    public void reset() throws IOException {
        this._in.reset();
    }

    public boolean markSupported() {
        return this._in.markSupported();
    }

    public void close() throws IOException {
        this._method.releaseConnection();
        this._in.close();
    }
}

