/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid.xsd;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

public class URLBasedGrammarPool
implements XMLGrammarPool {
    private static Logger _LOG = Logger.getLogger((String)URLBasedGrammarPool.class.getName());
    private boolean _locked = false;
    private Map _grammarMap = new HashMap();
    private static final Grammar[] _EMPTY_GRAMMAR_ARRAY = new Grammar[0];

    public Grammar[] retrieveInitialGrammarSet(String grammarType) {
        _LOG.debug((Object)"Returning empty initial grammar set");
        return _EMPTY_GRAMMAR_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheGrammars(String grammarType, Grammar[] grammars) {
        Map map = this._grammarMap;
        synchronized (map) {
            if (!this._locked) {
                for (int i = 0; i < grammars.length; ++i) {
                    String url = grammars[i].getGrammarDescription().getExpandedSystemId();
                    if (url != null) {
                        if (!this._grammarMap.containsKey(url)) {
                            this._grammarMap.put(url, grammars[i]);
                            _LOG.info((Object)("Put grammar in cache: " + url));
                            continue;
                        }
                        _LOG.debug((Object)("Grammar not put to cache; was already in map: " + url));
                        continue;
                    }
                    _LOG.debug((Object)"Grammar not put to cache; null expandedSystemId");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar retrieveGrammar(XMLGrammarDescription desc) {
        String url = desc.getExpandedSystemId();
        if (url != null) {
            Map map = this._grammarMap;
            synchronized (map) {
                Grammar grammar = (Grammar)this._grammarMap.get(url);
                if (grammar != null) {
                    _LOG.info((Object)("Grammar retrieved from cache: " + url));
                    return grammar;
                }
                _LOG.debug((Object)("Grammar not retrieved; not in cache: " + url));
                return null;
            }
        }
        _LOG.debug((Object)"Grammar not retrieved; null expandedSystemId");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockPool() {
        Map map = this._grammarMap;
        synchronized (map) {
            this._locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockPool() {
        Map map = this._grammarMap;
        synchronized (map) {
            this._locked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this._grammarMap;
        synchronized (map) {
            this._grammarMap.clear();
        }
    }
}

