/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import proai.Writable;
import proai.cache.CachedContent;
import proai.cache.RecordCache;
import proai.error.ServerException;

public class CachedContentAggregate
implements Writable {
    private File m_listFile;
    private String m_verb;
    private RecordCache m_cache;

    public CachedContentAggregate(File listFile, String verb, RecordCache cache) {
        this.m_listFile = listFile;
        this.m_verb = verb;
        this.m_cache = cache;
    }

    public void write(PrintWriter out) throws ServerException {
        BufferedReader lineReader = null;
        try {
            boolean headersOnly = this.m_verb.equals("ListIdentifiers");
            out.println("<" + this.m_verb + ">");
            lineReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_listFile), "UTF-8"));
            String line = lineReader.readLine();
            while (line != null) {
                String[] parts = line.split(" ");
                if (line.startsWith("end")) {
                    if (parts.length == 3) {
                        out.println("<resumptionToken cursor=\"" + parts[2] + "\">" + parts[1] + "</resumptionToken>");
                    } else if (parts.length == 2) {
                        out.println("<resumptionToken cursor=\"" + parts[1] + "\"/>");
                    }
                    line = null;
                    continue;
                }
                try {
                    if (parts.length == 2) {
                        new CachedContent(this.m_cache.getFile(parts[0]), parts[1], headersOnly).write(out);
                    } else {
                        new CachedContent(this.m_cache.getFile(parts[0])).write(out);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                line = lineReader.readLine();
            }
            out.println("</" + this.m_verb + ">");
        }
        catch (Exception e) {
            throw new ServerException("Error writing cached content aggregate", e);
        }
        finally {
            if (lineReader != null) {
                try {
                    lineReader.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

