/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import proai.CloseableIterator;
import proai.cache.CachedContent;
import proai.cache.RCDisk;
import proai.error.ServerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedRecordContentIterator
implements CloseableIterator<CachedContent> {
    private CloseableIterator<String[]> m_arrays;
    private RCDisk m_rcDisk;
    private boolean m_identifiers;
    private boolean m_closed;

    public CachedRecordContentIterator(CloseableIterator<String[]> paths, RCDisk rcDisk, boolean identifiers) {
        this.m_arrays = paths;
        this.m_rcDisk = rcDisk;
        this.m_identifiers = identifiers;
        this.m_closed = false;
    }

    @Override
    public boolean hasNext() throws ServerException {
        return this.m_arrays.hasNext();
    }

    @Override
    public CachedContent next() throws ServerException {
        if (!this.hasNext()) {
            return null;
        }
        try {
            String[] array = this.m_arrays.next();
            return this.m_rcDisk.getContent(array[0], array[1], this.m_identifiers);
        }
        catch (Exception e) {
            this.close();
            throw new ServerException("Could not get next record content from iterator", e);
        }
    }

    @Override
    public void close() {
        if (!this.m_closed) {
            this.m_closed = true;
            this.m_arrays.close();
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("CachedRecordContentIterator does not support remove().");
    }
}

