/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import proai.cache.ParsedRecord;
import proai.cache.QueueItem;
import proai.cache.RCDatabase;
import proai.cache.RecordCache;
import proai.cache.Updater;
import proai.error.ServerException;
import proai.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Committer
extends Thread {
    private static Logger _LOG = Logger.getLogger((String)Committer.class.getName());
    private Updater _updater;
    private RCDatabase _db;
    private int _maxCommitQueueSize;
    private int _maxRecordsPerTransaction;
    private Map<String, Integer> _formatKeyMap;
    private List<QueueItem> _commitQueue;
    private int _lastCommitQueueSize;
    private Object _lastCommitQueueSizeLock = new Object();
    private boolean _finishedRunning;
    private int _transactionCount;
    private int _processedCount;
    private long _totalCommitTime;

    public Committer(Updater updater, RCDatabase db, int maxCommitQueueSize, int maxRecordsPerTransaction) throws ServerException {
        super("Committer");
        this._updater = updater;
        this._db = db;
        this._maxCommitQueueSize = maxCommitQueueSize;
        this._maxRecordsPerTransaction = maxRecordsPerTransaction;
        this._commitQueue = new ArrayList<QueueItem>(this._maxCommitQueueSize);
        Connection conn = null;
        try {
            conn = RecordCache.getConnection();
            this._formatKeyMap = this._db.getFormatKeyMap(conn);
        }
        catch (SQLException e) {
            throw new ServerException("Error getting connection while initializing Committer", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean handoff(List<QueueItem> queueItems) {
        int toAddSize = queueItems.size();
        while (!this._finishedRunning && this.getLastCommitQueueSize() + toAddSize > this._maxCommitQueueSize) {
            _LOG.debug((Object)"Commit queue is too big; waiting for it shrink or for Committer thread to finish");
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (!this._finishedRunning) {
            List<QueueItem> list = this._commitQueue;
            synchronized (list) {
                this._commitQueue.addAll(queueItems);
                this.setLastCommitQueueSize(this._commitQueue.size());
            }
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        _LOG.info((Object)"Committer started");
        while (this._updater.anyWorkersAreRunning()) {
            List<QueueItem> nextItems = this.getNextTransactionItems();
            while (nextItems == null && this._updater.anyWorkersAreRunning()) {
                _LOG.debug((Object)"Commit queue is empty; waiting for worker(s)");
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                nextItems = this.getNextTransactionItems();
            }
            if (nextItems == null) continue;
            this.commit(nextItems);
        }
        List<QueueItem> lastItems = this.getNextTransactionItems();
        while (!this._updater.processingShouldStop() && lastItems != null) {
            this.commit(lastItems);
            lastItems = this.getNextTransactionItems();
        }
        _LOG.info((Object)"Committer finished");
        this._finishedRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(List<QueueItem> items) {
        Connection conn = null;
        boolean startedTransaction = false;
        long commitStartTime = System.currentTimeMillis();
        try {
            conn = RecordCache.getConnection();
            conn.setAutoCommit(false);
            startedTransaction = true;
            for (QueueItem item : items) {
                this.updateItem(conn, item);
            }
            Date cacheCommitDate = new Date(StreamUtil.nowUTC().getTime() + 5000L);
            this._db.setUncommittedRecordDates(conn, cacheCommitDate);
            conn.commit();
            ++this._transactionCount;
            this._processedCount += items.size();
            this._totalCommitTime += System.currentTimeMillis() - commitStartTime;
            _LOG.info((Object)("Committed " + items.size() + " QueueItems to database"));
            Date now = StreamUtil.nowUTC();
            if (cacheCommitDate.getTime() < now.getTime()) {
                long diff = now.getTime() - cacheCommitDate.getTime();
                _LOG.warn((Object)("Commit took longer than expected.  cacheCommitDate estimate was therefore not safe.  If any harvest requests specifying until=null started within the last " + diff + "ms., they might " + "have missed these records."));
            }
        }
        catch (Throwable th) {
            if (startedTransaction) {
                try {
                    conn.rollback();
                }
                catch (Exception e) {
                    _LOG.error((Object)"Failed to roll back failed transaction", (Throwable)e);
                }
            }
            for (QueueItem item : items) {
                ParsedRecord pr = item.getParsedRecord();
                if (pr == null) continue;
                pr.deleteFile();
            }
            this._updater.handleCommitException(th);
        }
        finally {
            if (conn != null) {
                try {
                    if (startedTransaction) {
                        conn.setAutoCommit(false);
                    }
                }
                catch (Exception e) {
                    _LOG.error((Object)"Failed to set autoCommit to false", (Throwable)e);
                }
                finally {
                    RecordCache.releaseConnection(conn);
                }
            }
        }
    }

    private void updateItem(Connection conn, QueueItem item) throws Exception {
        this._db.removeFromQueue(conn, item.getQueueKey());
        if (item.succeeded()) {
            this._db.putRecord(conn, item.getParsedRecord(), this._formatKeyMap);
            if (item.getQueueSource() == 'F') {
                this._db.removeFailure(conn, item.getIdentifier(), item.getMDPrefix());
            }
        } else {
            int oldFailCount = this._db.getFailCount(conn, item.getIdentifier(), item.getMDPrefix());
            if (oldFailCount == -1) {
                this._db.addFailure(conn, item.getIdentifier(), item.getMDPrefix(), item.getSourceInfo(), item.getFailDate(), item.getFailReason());
            } else {
                this._db.updateFailure(conn, item.getIdentifier(), item.getMDPrefix(), item.getSourceInfo(), oldFailCount + 1, item.getFailDate(), item.getFailReason());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueueItem> getNextTransactionItems() {
        List<QueueItem> list = this._commitQueue;
        synchronized (list) {
            if (this._commitQueue.size() == 0) {
                return null;
            }
            ArrayList<QueueItem> nextItems = new ArrayList<QueueItem>();
            while (this._commitQueue.size() > 0 && nextItems.size() < this._maxRecordsPerTransaction) {
                nextItems.add(this._commitQueue.remove(0));
            }
            this.setLastCommitQueueSize(this._commitQueue.size());
            return nextItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastCommitQueueSize() {
        Object object = this._lastCommitQueueSizeLock;
        synchronized (object) {
            return this._lastCommitQueueSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastCommitQueueSize(int size) {
        Object object = this._lastCommitQueueSizeLock;
        synchronized (object) {
            this._lastCommitQueueSize = size;
        }
    }

    protected int getTransactionCount() {
        return this._transactionCount;
    }

    protected int getProcessedCount() {
        return this._processedCount;
    }

    protected long getTotalCommitTime() {
        return this._totalCommitTime;
    }
}

