/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import proai.Record;
import proai.error.ServerException;
import proai.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedRecord
extends DefaultHandler
implements Record {
    private static final Logger _LOG = Logger.getLogger((String)ParsedRecord.class.getName());
    private String m_itemID;
    private String m_prefix;
    private String m_sourceInfo;
    private File m_file;
    private Date m_date;
    private List<String> m_setSpecs;
    private SimpleDateFormat m_formatter1;
    private SimpleDateFormat m_formatter2;
    private boolean m_inDatestamp;
    private boolean m_inSetSpec;
    private boolean m_finishedParsing;
    private StringBuffer m_buf = null;

    public ParsedRecord(String itemID, String prefix, String sourceInfo, File file) throws ServerException {
        this.m_itemID = itemID;
        this.m_prefix = prefix;
        this.m_sourceInfo = sourceInfo;
        this.m_file = file;
        this.m_date = new Date(0L);
        this.m_setSpecs = new ArrayList<String>();
        this.m_formatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.m_formatter2 = new SimpleDateFormat("yyyy-MM-dd");
        this.m_inDatestamp = false;
        this.m_inSetSpec = false;
        this.m_finishedParsing = false;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(false);
            SAXParser parser = spf.newSAXParser();
            parser.parse((InputStream)new FileInputStream(file), (DefaultHandler)this);
        }
        catch (Exception e) {
            if (_LOG.isDebugEnabled() && file.exists()) {
                try {
                    String xml = StreamUtil.getString(new FileInputStream(file), "UTF-8");
                    _LOG.debug((Object)("Error parsing record xml: #BEGIN-XML#" + xml + "#END-XML#"));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            throw new ServerException("Error parsing record xml", e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) throws SAXException {
        if (!this.m_finishedParsing) {
            if (qName.equals("datestamp")) {
                this.m_inDatestamp = true;
                this.m_buf = new StringBuffer();
            } else if (qName.equals("setSpec")) {
                this.m_inSetSpec = true;
                this.m_buf = new StringBuffer();
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.m_finishedParsing && (this.m_inDatestamp || this.m_inSetSpec)) {
            this.m_buf.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.m_finishedParsing) {
            if (qName.equals("header")) {
                this.m_finishedParsing = true;
            } else if (qName.equals("datestamp")) {
                String s = this.m_buf.toString().trim();
                try {
                    try {
                        this.m_date = this.m_formatter1.parse(s);
                    }
                    catch (Exception e) {
                        this.m_date = this.m_formatter2.parse(s);
                    }
                }
                catch (Exception e) {
                    throw new SAXException("Record datestamp is unparsable: " + s);
                }
                this.m_inDatestamp = false;
            } else if (qName.equals("setSpec")) {
                String s = this.m_buf.toString().trim();
                String[] h = s.split(":");
                if (h.length > 1) {
                    StringBuffer b4 = new StringBuffer();
                    for (int i = 0; i < h.length; ++i) {
                        this.m_setSpecs.add(b4.toString() + h[i]);
                        b4.append(h[i] + ":");
                    }
                } else {
                    this.m_setSpecs.add(this.m_buf.toString().trim());
                }
                this.m_inSetSpec = false;
            }
        }
    }

    @Override
    public String getItemID() {
        return this.m_itemID;
    }

    @Override
    public String getPrefix() {
        return this.m_prefix;
    }

    @Override
    public String getSourceInfo() {
        return this.m_sourceInfo;
    }

    public Date getDate() {
        return this.m_date;
    }

    public List<String> getSetSpecs() {
        return this.m_setSpecs;
    }

    public boolean deleteFile() {
        return this.m_file.delete();
    }
}

