/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import proai.cache.QueueItem;

public class QueueIterator {
    private File _tempFile;
    private BufferedReader _reader;
    private QueueItem _next;

    public QueueIterator(File tempFile) throws IOException {
        this._tempFile = tempFile;
        this._reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._tempFile), "UTF-8"));
        this._next = this.getNext();
    }

    private QueueItem getNext() throws IOException {
        if (this._reader == null) {
            return null;
        }
        String line = this._reader.readLine();
        if (line == null) {
            this.close();
            return null;
        }
        if (line.length() == 0) {
            return this.getNext();
        }
        return QueueIterator.parseLine(line);
    }

    private static QueueItem parseLine(String line) throws IOException {
        String[] parts = line.split(" ");
        if (parts.length > 4) {
            try {
                StringBuffer sourceInfo = new StringBuffer();
                for (int i = 4; i < parts.length; ++i) {
                    if (i > 4) {
                        sourceInfo.append(' ');
                    }
                    sourceInfo.append(parts[i]);
                }
                return new QueueItem(Integer.parseInt(parts[0]), parts[1], parts[2], sourceInfo.toString(), parts[3].charAt(0));
            }
            catch (Throwable th) {
                throw new IOException("Error parsing next line: " + th.getClass().getName());
            }
        }
        throw new IOException("Error parsing next line: expected at least 5 values, but got " + parts.length);
    }

    public boolean hasNext() {
        return this._next != null;
    }

    public QueueItem next() throws IOException {
        if (this._next == null) {
            return null;
        }
        QueueItem prev = this._next;
        this._next = this.getNext();
        return prev;
    }

    public void close() {
        if (this._reader != null) {
            try {
                this._reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._tempFile.delete();
            this._reader = null;
        }
    }
}

