/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import net.sf.bvalid.SchemaLanguage;
import net.sf.bvalid.Validator;
import net.sf.bvalid.ValidatorFactory;
import net.sf.bvalid.ValidatorOption;
import net.sf.bvalid.catalog.DiskSchemaCatalog;
import net.sf.bvalid.catalog.FileSchemaIndex;
import net.sf.bvalid.catalog.MemorySchemaCatalog;
import net.sf.bvalid.catalog.SchemaCatalog;
import net.sf.bvalid.catalog.SchemaIndex;
import net.sf.bvalid.locator.CachingSchemaLocator;
import net.sf.bvalid.locator.SchemaLocator;
import net.sf.bvalid.locator.URLSchemaLocator;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.log4j.Logger;
import proai.CloseableIterator;
import proai.MetadataFormat;
import proai.SetInfo;
import proai.Writable;
import proai.cache.CachedContent;
import proai.cache.CachedMetadataFormat;
import proai.cache.CachedRecordContentIterator;
import proai.cache.RCDatabase;
import proai.cache.RCDisk;
import proai.cache.Updater;
import proai.cache.WritableWrapper;
import proai.driver.OAIDriver;
import proai.driver.impl.RemoteIteratorImpl;
import proai.error.ServerException;
import proai.util.DDLConverter;
import proai.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordCache
extends Thread {
    public static final String OAI_RECORD_SCHEMA_URL = "http://proai.sourceforge.net/schemas/OAI-PMH-record.xsd";
    public static final String[] EXAMPLE_SCHEMAS = new String[]{"sample.xsd", "test_format.xsd", "my-about.xsd", "formatX.xsd", "formatY.xsd"};
    private static final Logger logger = Logger.getLogger((String)RecordCache.class.getName());
    private static final String propMissing = "Required property missing: ";
    private static final String pfx = "proai.";
    private static final String dbpfx = "proai.db.";
    private static final String dbconnpfx = "proai.db.connection.";
    public static final String PROP_BASEDIR = "proai.cacheBaseDir";
    public static final String PROP_OAIDRIVERCLASSNAME = "proai.driverClassName";
    public static final String PROP_POLLSECONDS = "proai.driverPollSeconds";
    public static final String PROP_POLLINGENABLED = "proai.driverPollingEnabled";
    public static final String PROP_MAXWORKERS = "proai.maxWorkers";
    public static final String PROP_MAXWORKBATCHSIZE = "proai.maxWorkBatchSize";
    public static final String PROP_MAXFAILEDRETRIES = "proai.maxFailedRetries";
    public static final String PROP_MAXCOMMITQUEUESIZE = "proai.maxCommitQueueSize";
    public static final String PROP_MAXRECORDSPERTRANS = "proai.maxRecordsPerTransaction";
    public static final String PROP_SCHEMADIR = "proai.schemaDir";
    public static final String PROP_VALIDATEUPDATES = "proai.validateUpdates";
    public static final String PROP_DB_URL = "proai.db.url";
    public static final String PROP_DB_DRIVERCLASSNAME = "proai.db.driverClassName";
    public static final String PROP_DB_MYSQL_TRICKLING = "proai.db.mySQLResultTrickling";
    public static final String PROP_DB_USERNAME = "proai.db.username";
    public static final String PROP_DB_PASSWORD = "proai.db.password";
    private static BasicDataSource s_pool;
    private Updater m_updater;
    private OAIDriver m_driver;
    private File m_baseDir;
    private RCDatabase m_rcdb;
    private RCDisk m_rcDisk;

    public RecordCache(Properties props) throws ServerException {
        BasicDataSource pool;
        OAIDriver driver;
        String baseDir = RecordCache.getRequiredParam(props, PROP_BASEDIR);
        String oaiDriverClassName = RecordCache.getRequiredParam(props, PROP_OAIDRIVERCLASSNAME);
        String dbDriverClassName = RecordCache.getRequiredParam(props, PROP_DB_DRIVERCLASSNAME);
        boolean mySQLTrickling = false;
        String mt = props.getProperty(PROP_DB_MYSQL_TRICKLING);
        if (mt != null && mt.equalsIgnoreCase("true")) {
            mySQLTrickling = true;
        }
        try {
            driver = (OAIDriver)Class.forName(oaiDriverClassName).newInstance();
        }
        catch (Exception e) {
            throw new ServerException("Unable to initialize OAIDriver: " + oaiDriverClassName, e);
        }
        driver.init(props);
        int pollSecondsInt = RecordCache.getRequiredInt(props, PROP_POLLSECONDS, 1, Integer.MAX_VALUE);
        boolean pollingEnabled = RecordCache.getRequiredParam(props, PROP_POLLINGENABLED).equalsIgnoreCase("true");
        int maxWorkers = RecordCache.getRequiredInt(props, PROP_MAXWORKERS, 1, Integer.MAX_VALUE);
        int maxWorkBatchSize = RecordCache.getRequiredInt(props, PROP_MAXWORKBATCHSIZE, 1, Integer.MAX_VALUE);
        int maxFailedRetries = RecordCache.getRequiredInt(props, PROP_MAXFAILEDRETRIES, 0, Integer.MAX_VALUE);
        int maxCommitQueueSize = RecordCache.getRequiredInt(props, PROP_MAXCOMMITQUEUESIZE, 1, Integer.MAX_VALUE);
        int maxRecordsPerTransaction = RecordCache.getRequiredInt(props, PROP_MAXRECORDSPERTRANS, 1, Integer.MAX_VALUE);
        logger.info((Object)"Initializing database connection pool...");
        try {
            Class.forName(dbDriverClassName);
            pool = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)RecordCache.getDBProperties(props, false));
            pool.setDriverClassName(dbDriverClassName);
            Properties connProps = RecordCache.getDBProperties(props, true);
            Enumeration<?> e = connProps.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                pool.addConnectionProperty(name, connProps.getProperty(name));
            }
        }
        catch (Exception e) {
            throw new ServerException("Unable to initialize DataSource", e);
        }
        DDLConverter ddlc = null;
        try {
            String ddlcProp = dbDriverClassName + ".ddlConverter";
            String ddlcClassName = RecordCache.getRequiredParam(props, ddlcProp);
            ddlc = (DDLConverter)Class.forName(ddlcClassName).newInstance();
        }
        catch (Exception e) {
            throw new ServerException("Unable to initialize DDLConverter", e);
        }
        boolean backslashIsEscape = true;
        String s = props.getProperty(dbDriverClassName + ".backslashIsEscape");
        if (s != null && s.trim().equalsIgnoreCase("false")) {
            backslashIsEscape = false;
        }
        File schemaDir = null;
        boolean validateUpdates = true;
        String vu = props.getProperty(PROP_VALIDATEUPDATES);
        if (vu != null && vu.equalsIgnoreCase("false")) {
            validateUpdates = false;
        } else {
            schemaDir = new File(RecordCache.getRequiredParam(props, PROP_SCHEMADIR));
        }
        this.init(pool, ddlc, mySQLTrickling, backslashIsEscape, pollingEnabled, driver, pollSecondsInt, new File(baseDir), maxWorkers, maxWorkBatchSize, maxFailedRetries, maxCommitQueueSize, maxRecordsPerTransaction, validateUpdates, schemaDir);
    }

    public RecordCache(BasicDataSource pool, DDLConverter ddlc, boolean mySQLTrickling, boolean backslashIsEscape, boolean pollingEnabled, OAIDriver driver, int pollSeconds, File baseDir, int maxWorkers, int maxWorkBatchSize, int maxFailedRetries, int maxCommitQueueSize, int maxRecordsPerTransaction, boolean validateUpdates, File schemaDir) throws ServerException {
        this.init(pool, ddlc, mySQLTrickling, backslashIsEscape, pollingEnabled, driver, pollSeconds, baseDir, maxWorkers, maxWorkBatchSize, maxFailedRetries, maxCommitQueueSize, maxRecordsPerTransaction, validateUpdates, schemaDir);
    }

    private void init(BasicDataSource pool, DDLConverter ddlc, boolean mySQLTrickling, boolean backslashIsEscape, boolean pollingEnabled, OAIDriver driver, int pollSeconds, File baseDir, int maxWorkers, int maxWorkBatchSize, int maxFailedRetries, int maxCommitQueueSize, int maxRecordsPerTransaction, boolean validateUpdates, File schemaDir) throws ServerException {
        logger.info((Object)"Initializing Record Cache...");
        s_pool = pool;
        this.m_driver = driver;
        this.m_baseDir = baseDir;
        this.m_rcDisk = new RCDisk(this.m_baseDir);
        logger.debug((Object)"Record Cache Initialized");
        Connection conn = null;
        try {
            conn = RecordCache.getConnection();
            this.m_rcdb = new RCDatabase(conn, ddlc, mySQLTrickling, backslashIsEscape, pollingEnabled, this.m_rcDisk);
        }
        catch (SQLException e) {
            throw new ServerException("Database connection problem", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
        Validator validator = null;
        if (validateUpdates) {
            if (!schemaDir.exists()) {
                schemaDir.mkdirs();
                if (!schemaDir.exists()) {
                    throw new ServerException("Cannot create schema dir: " + schemaDir.getPath());
                }
            }
            HashMap<ValidatorOption, String> opts = new HashMap<ValidatorOption, String>();
            opts.put(ValidatorOption.CACHE_PARSED_GRAMMARS, "true");
            try {
                validator = ValidatorFactory.getValidator((SchemaLanguage)SchemaLanguage.XSD, (SchemaLocator)this.createLocator(schemaDir), opts);
            }
            catch (Exception e) {
                throw new ServerException("Unable to initialize schema validator", e);
            }
        }
        this.m_updater = new Updater(this.m_driver, this, this.m_rcdb, this.m_rcDisk, pollSeconds, maxWorkers, maxWorkBatchSize, maxFailedRetries, maxCommitQueueSize, maxRecordsPerTransaction, validator);
        this.m_updater.start();
    }

    private SchemaLocator createLocator(File schemaDir) throws Exception {
        FileSchemaIndex index = new FileSchemaIndex(new File(schemaDir, "index.dat"));
        DiskSchemaCatalog cacheCatalog = new DiskSchemaCatalog((SchemaIndex)index, schemaDir);
        RecordCache.addToCatalog((SchemaCatalog)cacheCatalog, OAI_RECORD_SCHEMA_URL, "schemas/OAI-PMH-record.xsd");
        for (int i = 0; i < EXAMPLE_SCHEMAS.length; ++i) {
            RecordCache.addToCatalog((SchemaCatalog)cacheCatalog, "http://example.org/" + EXAMPLE_SCHEMAS[i], "schemas/" + EXAMPLE_SCHEMAS[i]);
        }
        return new CachingSchemaLocator((SchemaCatalog)new MemorySchemaCatalog(), (SchemaCatalog)cacheCatalog, (SchemaLocator)new URLSchemaLocator());
    }

    private static void addToCatalog(SchemaCatalog catalog, String url, String path) throws Exception {
        if (!catalog.contains(url)) {
            InputStream in = null;
            try {
                in = RecordCache.class.getClassLoader().getResourceAsStream(path);
            }
            catch (Throwable th) {
                in = ClassLoader.getSystemResourceAsStream(path);
            }
            catalog.put(url, in);
        }
    }

    protected static Connection getConnection() throws SQLException {
        if (s_pool == null) {
            throw new RuntimeException("RecordCache has not been constructed so the db connection pool does not exist!");
        }
        long startTime = System.currentTimeMillis();
        Connection conn = s_pool.getConnection();
        if (logger.isDebugEnabled()) {
            long delay = System.currentTimeMillis() - startTime;
            logger.debug((Object)("Got db connection from pool after " + delay + "ms.  Now idle = " + s_pool.getNumIdle() + " and active = " + s_pool.getNumActive()));
        }
        return conn;
    }

    protected static void releaseConnection(Connection conn) {
        if (s_pool == null) {
            throw new RuntimeException("RecordCache has not been constructed so the db connection pool does not exist!");
        }
        if (conn != null) {
            try {
                conn.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Released db connection to pool.  Now idle = " + s_pool.getNumIdle() + " and active = " + s_pool.getNumActive()));
                }
            }
            catch (Throwable th) {
                logger.warn((Object)"Unable to release db connection to pool", th);
            }
        }
    }

    private static String getRequiredParam(Properties props, String propName) throws ServerException {
        String val = props.getProperty(propName);
        if (val == null) {
            throw new ServerException(propMissing + propName);
        }
        logger.debug((Object)("Got required property: " + propName + " = " + val));
        return val.trim();
    }

    private static int getRequiredInt(Properties props, String propName, int minValue, int maxValue) throws ServerException {
        String val = RecordCache.getRequiredParam(props, propName);
        try {
            int intVal = Integer.parseInt(val);
            if (intVal < minValue) {
                throw new ServerException("Bad value for " + propName + ": smallest valid value is " + minValue);
            }
            if (intVal > maxValue) {
                throw new ServerException("Bad value for " + propName + ": largest valid value is " + minValue);
            }
            return intVal;
        }
        catch (NumberFormatException nfe) {
            throw new ServerException("Bad value for " + propName + ": must be an integer");
        }
    }

    private static final Properties getDBProperties(Properties props, boolean conn) {
        Properties dbProps = new Properties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String newPropName;
            String name = (String)e.nextElement();
            if (!name.startsWith(dbpfx)) continue;
            String value = props.getProperty(name);
            if (name.startsWith(dbconnpfx)) {
                if (!conn) continue;
                newPropName = name.substring(dbconnpfx.length());
                logger.debug((Object)("Set per-connection property: " + newPropName + " = " + value));
                dbProps.setProperty(newPropName, value);
                continue;
            }
            if (conn) continue;
            newPropName = name.substring(dbpfx.length());
            logger.debug((Object)("Set connection pool property: " + newPropName + " = " + value));
            dbProps.setProperty(newPropName, value);
        }
        return dbProps;
    }

    public File getFile(String cachePath) {
        return this.m_rcDisk.getFile(cachePath);
    }

    public Writable getRecordContent(String identifier, String metadataPrefix) throws ServerException {
        Connection conn = null;
        try {
            conn = RecordCache.getConnection();
            String[] info = this.m_rcdb.getRecordInfo(conn, identifier, metadataPrefix);
            if (info == null) {
                Writable writable = null;
                return writable;
            }
            WritableWrapper writableWrapper = new WritableWrapper("<GetRecord>\n", this.m_rcDisk.getContent(info[0], info[1], false), "\n</GetRecord>");
            return writableWrapper;
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
    }

    public Writable getIdentifyContent() throws ServerException {
        Connection conn = null;
        try {
            conn = RecordCache.getConnection();
            String path = this.m_rcdb.getIdentifyPath(conn);
            if (path == null) {
                throw new ServerException("Identify.xml does not yet exist in the cache");
            }
            CachedContent cachedContent = this.m_rcDisk.getContent(path);
            return cachedContent;
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
    }

    public Writable getMetadataFormatsContent(String identifier) throws ServerException {
        Connection conn = null;
        try {
            conn = RecordCache.getConnection();
            List<CachedMetadataFormat> formats = this.m_rcdb.getFormats(conn, identifier);
            if (identifier != null && formats.size() == 0) {
                Writable writable = null;
                return writable;
            }
            CachedContent cachedContent = new CachedContent(this.getFormatsXMLString(formats));
            return cachedContent;
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
    }

    public CloseableIterator<SetInfo> getSetInfoContent() throws ServerException {
        Connection conn = null;
        try {
            RemoteIteratorImpl<SetInfo> setInfo;
            conn = RecordCache.getConnection();
            List<SetInfo> list = this.m_rcdb.getSetInfo(conn);
            RemoteIteratorImpl<SetInfo> remoteIteratorImpl = setInfo = new RemoteIteratorImpl<SetInfo>(list.iterator());
            return remoteIteratorImpl;
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
    }

    public CloseableIterator<String[]> getSetInfoPaths() throws ServerException {
        Connection conn = null;
        try {
            RemoteIteratorImpl<String[]> setInfo;
            conn = RecordCache.getConnection();
            List<String[]> list = this.m_rcdb.getSetInfoPaths(conn);
            RemoteIteratorImpl<String[]> remoteIteratorImpl = setInfo = new RemoteIteratorImpl<String[]>(list.iterator());
            return remoteIteratorImpl;
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
    }

    public CloseableIterator<CachedContent> getRecordsContent(Date from, Date until, String prefix, String set, boolean identifiers) throws ServerException {
        if (until == null) {
            until = StreamUtil.nowUTC();
        }
        try {
            return new CachedRecordContentIterator(this.m_rcdb.findRecordInfo(RecordCache.getConnection(), from, until, prefix, set), this.m_rcDisk, identifiers);
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
    }

    public CloseableIterator<String[]> getRecordsPaths(Date from, Date until, String prefix, String set) throws ServerException {
        if (until == null) {
            until = StreamUtil.nowUTC();
        }
        try {
            return this.m_rcdb.findRecordInfo(RecordCache.getConnection(), from, until, prefix, set);
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
    }

    public boolean formatExists(String mdPrefix) throws ServerException {
        Connection conn = null;
        try {
            conn = RecordCache.getConnection();
            for (MetadataFormat metadataFormat : this.m_rcdb.getFormats(conn)) {
                if (!metadataFormat.getPrefix().equals(mdPrefix)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
    }

    private String getFormatsXMLString(List<? extends MetadataFormat> formats) {
        StringBuffer buf = new StringBuffer();
        buf.append("<ListMetadataFormats>\n");
        for (MetadataFormat metadataFormat : formats) {
            buf.append("  <metadataFormat>\n");
            buf.append("    <metadataPrefix>" + metadataFormat.getPrefix() + "</metadataPrefix>\n");
            buf.append("    <schema>" + metadataFormat.getSchemaLocation() + "</schema>\n");
            buf.append("    <metadataNamespace>" + metadataFormat.getNamespaceURI() + "</metadataNamespace>\n");
            buf.append("  </metadataFormat>\n");
        }
        buf.append("</ListMetadataFormats>");
        return buf.toString();
    }

    public boolean itemExists(String identifier) throws ServerException {
        Connection conn = null;
        try {
            conn = RecordCache.getConnection();
            boolean bl = this.m_rcdb.itemExists(conn, identifier);
            return bl;
        }
        catch (SQLException e) {
            throw new ServerException("Error getting a database connection", e);
        }
        finally {
            RecordCache.releaseConnection(conn);
        }
    }

    public void close() throws ServerException {
        if (s_pool != null) {
            this.m_updater.shutdown(true);
            try {
                s_pool.close();
                s_pool = null;
            }
            catch (Exception e) {
                throw new ServerException("Error closing DataSource", e);
            }
            logger.info((Object)"RecordCache shutdown complete.");
        }
    }

    public void finalize() throws ServerException {
        this.close();
    }
}

