/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;
import proai.CloseableIterator;
import proai.cache.RecordCache;
import proai.error.ServerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringResultIterator
implements CloseableIterator<String[]> {
    private static final Logger logger = Logger.getLogger((String)StringResultIterator.class.getName());
    private Connection m_conn;
    private Statement m_stmt;
    private ResultSet m_rs;
    private boolean m_closed;
    private String[] m_nextStringArray;
    private boolean m_exhausted;

    public StringResultIterator(Connection conn, Statement stmt, ResultSet rs) throws ServerException {
        logger.debug((Object)"Constructing");
        this.m_conn = conn;
        this.m_stmt = stmt;
        this.m_rs = rs;
        this.m_closed = false;
        this.m_nextStringArray = this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this.m_nextStringArray != null;
    }

    @Override
    public String[] next() throws ServerException {
        String[] next = this.m_nextStringArray;
        this.m_nextStringArray = this.getNext();
        return next;
    }

    private String[] getNext() throws ServerException {
        if (this.m_exhausted) {
            return null;
        }
        try {
            if (this.m_rs.next()) {
                String[] result = new String[2];
                result[0] = this.m_rs.getString(1);
                Date d = new Date(this.m_rs.getLong(2));
                try {
                    result[1] = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(d);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return result;
            }
            this.m_exhausted = true;
            this.close();
            return null;
        }
        catch (SQLException e) {
            this.close();
            throw new ServerException("Error pre-getting next string from db", e);
        }
    }

    @Override
    public void close() {
        if (!this.m_closed) {
            if (this.m_rs != null) {
                try {
                    this.m_rs.close();
                    this.m_rs = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.m_stmt != null) {
                try {
                    this.m_stmt.close();
                    this.m_stmt = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            RecordCache.releaseConnection(this.m_conn);
            long startTime = System.currentTimeMillis();
            long startFreeBytes = Runtime.getRuntime().freeMemory();
            System.gc();
            long ms = System.currentTimeMillis() - startTime;
            long currentFreeBytes = Runtime.getRuntime().freeMemory();
            logger.info((Object)("GC ran in " + ms + "ms and free memory " + "went from " + startFreeBytes + " to " + currentFreeBytes + " bytes."));
            this.m_closed = true;
            logger.info((Object)"Closed.");
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("StringResultIterator does not support remove().");
    }
}

