/*
 * Decompiled with CFR 0.152.
 */
package proai.driver.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import proai.MetadataFormat;
import proai.Record;
import proai.SetInfo;
import proai.driver.OAIDriver;
import proai.driver.RemoteIterator;
import proai.driver.impl.MetadataFormatImpl;
import proai.driver.impl.RecordImpl;
import proai.driver.impl.RemoteIteratorImpl;
import proai.driver.impl.SetInfoImpl;
import proai.error.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAIDriverImpl
implements OAIDriver {
    public static final String BASE_DIR_PROPERTY = "proai.driver.simple.baseDir";
    public static final String IDENTITY_FILENAME = "identity.xml";
    public static final String RECORDS_DIRNAME = "records";
    public static final String SETS_DIRNAME = "sets";
    public static final String FORMATS_DIRNAME = "formats";
    private File m_identityFile;
    private File m_recordsDir;
    private File m_setsDir;
    private File m_formatsDir;

    public OAIDriverImpl() {
    }

    public OAIDriverImpl(File dir) throws RepositoryException {
        Properties props = new Properties();
        props.setProperty(BASE_DIR_PROPERTY, dir.getPath());
        this.init(props);
    }

    @Override
    public void init(Properties props) throws RepositoryException {
        String baseDir = props.getProperty(BASE_DIR_PROPERTY);
        if (baseDir == null) {
            throw new RepositoryException("Required property is not set: proai.driver.simple.baseDir");
        }
        File dir = new File(baseDir);
        this.m_identityFile = new File(dir, IDENTITY_FILENAME);
        this.m_recordsDir = new File(dir, RECORDS_DIRNAME);
        this.m_setsDir = new File(dir, SETS_DIRNAME);
        this.m_formatsDir = new File(dir, FORMATS_DIRNAME);
        if (!dir.exists()) {
            throw new RepositoryException("Base directory does not exist: " + dir.getPath());
        }
        if (!this.m_identityFile.exists()) {
            throw new RepositoryException("Identity file does not exist: " + this.m_identityFile.getPath());
        }
        if (!this.m_recordsDir.exists()) {
            throw new RepositoryException("Records directory does not exist: " + this.m_recordsDir.getPath());
        }
        if (!this.m_setsDir.exists()) {
            throw new RepositoryException("Sets directory does not exist: " + this.m_setsDir.getPath());
        }
        if (!this.m_formatsDir.exists()) {
            throw new RepositoryException("Formats directory does not exist: " + this.m_formatsDir.getPath());
        }
    }

    @Override
    public void write(PrintWriter out) throws RepositoryException {
        OAIDriverImpl.writeFromFile(this.m_identityFile, out);
    }

    @Override
    public Date getLatestDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
        long latest = 0L;
        String[] names = this.m_recordsDir.list();
        for (int i = 0; i < names.length; ++i) {
            String[] temp = names[i].replaceFirst("-", " ").replaceFirst("-", " ").split(" ");
            if (temp.length != 3 || temp[2].indexOf(".") == -1) continue;
            try {
                long recDate = df.parse(temp[2].substring(0, temp[2].indexOf("."))).getTime();
                if (recDate <= latest) continue;
                latest = recDate;
                continue;
            }
            catch (Exception e) {
                System.out.println("WARNING: Ignoring unparsable filename: " + names[i]);
            }
        }
        return new Date(latest);
    }

    public RemoteIterator<MetadataFormat> listMetadataFormats() {
        return new RemoteIteratorImpl<MetadataFormat>(this.getMetadataFormatCollection().iterator());
    }

    public RemoteIterator<SetInfo> listSetInfo() {
        return new RemoteIteratorImpl<SetInfo>(this.getSetInfoCollection().iterator());
    }

    public RemoteIterator<Record> listRecords(Date from, Date until, String mdPrefix) {
        return new RemoteIteratorImpl<Record>(this.getRecordCollection(from, until, mdPrefix).iterator());
    }

    @Override
    public void writeRecordXML(String itemID, String mdPrefix, String sourceInfo, PrintWriter writer) throws RepositoryException {
        File file = new File(sourceInfo);
        OAIDriverImpl.writeFromFile(file, writer);
    }

    @Override
    public void close() {
    }

    public static void writeFromFile(File file, PrintWriter out) throws RepositoryException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = reader.readLine();
            while (line != null) {
                out.println(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RepositoryException("Error reading from file: " + file.getPath(), e);
        }
    }

    private Collection<SetInfo> getSetInfoCollection() {
        try {
            ArrayList<SetInfo> list = new ArrayList<SetInfo>();
            String[] names = this.m_setsDir.list();
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].endsWith(".xml")) continue;
                String spec = names[i].split("\\.")[0].replaceAll("-", ":");
                list.add(new SetInfoImpl(spec, new File(this.m_setsDir, names[i])));
            }
            return list;
        }
        catch (Exception e) {
            throw new RepositoryException("Error getting set information", e);
        }
    }

    private Collection<MetadataFormat> getMetadataFormatCollection() {
        try {
            ArrayList<MetadataFormat> list = new ArrayList<MetadataFormat>();
            String[] names = this.m_formatsDir.list();
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].endsWith(".txt")) continue;
                String prefix = names[i].split("\\.")[0];
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.m_formatsDir, names[i])), "UTF-8"));
                String uri = reader.readLine();
                if (uri == null) {
                    throw new RepositoryException("Error reading first line of format file: " + names[i]);
                }
                String loc = reader.readLine();
                if (loc == null) {
                    throw new RepositoryException("Error reading second line of format file: " + names[i]);
                }
                list.add(new MetadataFormatImpl(prefix, uri, loc));
            }
            return list;
        }
        catch (Exception e) {
            throw new RepositoryException("Error getting metadata formats", e);
        }
    }

    private Collection<Record> getRecordCollection(Date from, Date until, String mdPrefix) {
        ArrayList<Record> list = new ArrayList<Record>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
        String[] names = this.m_recordsDir.list();
        for (int i = 0; i < names.length; ++i) {
            String[] parts;
            String[] temp = names[i].replaceFirst("-", " ").replaceFirst("-", " ").split(" ");
            if (temp.length != 3 || temp[2].indexOf(".") == -1 || !(parts = names[i].split("-"))[1].equals(mdPrefix)) continue;
            try {
                long recDate = df.parse(temp[2].substring(0, temp[2].indexOf("."))).getTime();
                if (from != null && from.getTime() >= recDate || until.getTime() < recDate) continue;
                String itemID = "oai:example.org:" + parts[0];
                list.add(new RecordImpl(itemID, mdPrefix, new File(this.m_recordsDir, names[i])));
                continue;
            }
            catch (Exception e) {
                System.out.println("WARNING: Ignoring unparsable filename: " + names[i]);
            }
        }
        return list;
    }
}

