/*
 * Decompiled with CFR 0.152.
 */
package proai.service;

import java.util.Date;
import proai.CloseableIterator;
import proai.SetInfo;
import proai.cache.CachedContent;
import proai.cache.RecordCache;
import proai.error.CannotDisseminateFormatException;
import proai.error.NoRecordsMatchException;
import proai.error.NoSetHierarchyException;
import proai.error.ServerException;
import proai.service.ListProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordListProvider
implements ListProvider<CachedContent> {
    private RecordCache m_cache;
    private int m_incompleteListSize;
    private boolean m_identifiers;
    private Date m_from;
    private Date m_until;
    private String m_prefix;
    private String m_set;

    public RecordListProvider(RecordCache cache, int incompleteListSize, boolean identifiers, Date from, Date until, String prefix, String set) {
        this.m_cache = cache;
        this.m_incompleteListSize = incompleteListSize;
        this.m_identifiers = identifiers;
        this.m_from = from;
        this.m_until = until;
        this.m_prefix = prefix;
        this.m_set = set;
    }

    @Override
    public CloseableIterator<CachedContent> getList() throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, ServerException {
        CloseableIterator<CachedContent> iter = this.m_cache.getRecordsContent(this.m_from, this.m_until, this.m_prefix, this.m_set, this.m_identifiers);
        if (iter.hasNext()) {
            return iter;
        }
        if (!this.m_cache.formatExists(this.m_prefix)) {
            throw new CannotDisseminateFormatException("the metadataPrefix is unrecognized");
        }
        if (this.m_set != null) {
            CloseableIterator<SetInfo> sic = this.m_cache.getSetInfoContent();
            boolean supportsSets = sic.hasNext();
            try {
                sic.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!supportsSets) {
                throw new NoSetHierarchyException("there are no sets in the repository");
            }
        }
        throw new NoRecordsMatchException("no records match your selection criteria");
    }

    @Override
    public CloseableIterator<String[]> getPathList() throws CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, ServerException {
        CloseableIterator<String[]> iter = this.m_cache.getRecordsPaths(this.m_from, this.m_until, this.m_prefix, this.m_set);
        if (iter.hasNext()) {
            return iter;
        }
        if (!this.m_cache.formatExists(this.m_prefix)) {
            throw new CannotDisseminateFormatException("the metadataPrefix is unrecognized");
        }
        if (this.m_set != null) {
            CloseableIterator<SetInfo> sic = this.m_cache.getSetInfoContent();
            boolean supportsSets = sic.hasNext();
            try {
                sic.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!supportsSets) {
                throw new NoSetHierarchyException("there are no sets in the repository");
            }
        }
        throw new NoRecordsMatchException("no records match your selection criteria");
    }

    @Override
    public RecordCache getRecordCache() {
        return this.m_cache;
    }

    @Override
    public int getIncompleteListSize() {
        return this.m_incompleteListSize;
    }

    @Override
    public String getVerb() {
        if (this.m_identifiers) {
            return "ListIdentifiers";
        }
        return "ListRecords";
    }
}

