/*
 * Decompiled with CFR 0.152.
 */
package proai.service;

import proai.CloseableIterator;
import proai.SetInfo;
import proai.cache.RecordCache;
import proai.error.NoSetHierarchyException;
import proai.error.ServerException;
import proai.service.ListProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetListProvider
implements ListProvider<SetInfo> {
    private RecordCache m_cache;
    private int m_incompleteListSize;

    public SetListProvider(RecordCache cache, int incompleteListSize) {
        this.m_cache = cache;
        this.m_incompleteListSize = incompleteListSize;
    }

    @Override
    public CloseableIterator<SetInfo> getList() throws ServerException {
        CloseableIterator<SetInfo> iter = this.m_cache.getSetInfoContent();
        if (iter.hasNext()) {
            return iter;
        }
        try {
            iter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new NoSetHierarchyException("there are no sets in the repository");
    }

    @Override
    public CloseableIterator<String[]> getPathList() throws ServerException {
        CloseableIterator<String[]> iter = this.m_cache.getSetInfoPaths();
        if (iter.hasNext()) {
            return iter;
        }
        try {
            iter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new NoSetHierarchyException("there are no sets in the repository");
    }

    @Override
    public RecordCache getRecordCache() {
        return this.m_cache;
    }

    @Override
    public int getIncompleteListSize() {
        return this.m_incompleteListSize;
    }

    @Override
    public String getVerb() {
        return "ListSets";
    }
}

