/*
 * Decompiled with CFR 0.152.
 */
package proai.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import proai.MetadataFormat;
import proai.Record;
import proai.SetInfo;
import proai.Writable;
import proai.driver.OAIDriver;
import proai.driver.RemoteIterator;
import proai.driver.impl.OAIDriverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAIDriverImplTest
extends TestCase {
    public static final String LATEST_DATE = "2005-01-01T08:57:59Z";
    public static final String OAI_DC_PREFIX = "oai_dc";
    public static final String OAI_DC_URI = "http://www.openarchives.org/OAI/2.0/oai_dc/";
    public static final String OAI_DC_LOC = "http://www.openarchives.org/OAI/2.0/oai_dc.xsd";
    public static final String TEST_FORMAT_PREFIX = "test_format";
    public static final String TEST_FORMAT_URI = "http://example.org/testFormat/";
    public static final String TEST_FORMAT_LOC = "http://example.org/testFormat.xsd";
    public static final String ABOVE_TWO_SPEC = "abovetwo";
    public static final String ABOVE_TWO_EVEN_SPEC = "abovetwo:even";
    public static final String ABOVE_TWO_ODD_SPEC = "abovetwo:odd";
    public static final String PRIME_SPEC = "prime";
    public static final String ITEM1 = "oai:example.org:item1";
    public static final String ITEM2 = "oai:example.org:item2";
    public static final String ITEM3 = "oai:example.org:item3";
    public static final String ITEM4 = "oai:example.org:item4";
    private OAIDriver m_impl;

    public void setUp() {
        this.m_impl = new OAIDriverImpl();
        this.m_impl.init(System.getProperties());
    }

    public void testLatestDate() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String latestDate = df.format(this.m_impl.getLatestDate());
        System.out.println("Latest Date was " + latestDate);
        OAIDriverImplTest.assertEquals((String)latestDate, (String)LATEST_DATE);
    }

    public void testIdentity() throws Exception {
        StringWriter writer = new StringWriter();
        this.m_impl.write(new PrintWriter((Writer)writer, true));
        System.out.println("Result of writeIdentity:\n" + writer.toString());
    }

    public void testFormats() throws Exception {
        RemoteIterator<? extends MetadataFormat> iter = this.m_impl.listMetadataFormats();
        while (iter.hasNext()) {
            MetadataFormat format = (MetadataFormat)iter.next();
            String prefix = format.getPrefix();
            String uri = format.getNamespaceURI();
            String loc = format.getSchemaLocation();
            System.out.println("Format prefix = " + prefix);
            System.out.println("       uri    = " + uri);
            System.out.println("       loc    = " + loc);
            OAIDriverImplTest.assertTrue((prefix.equals(OAI_DC_PREFIX) || prefix.equals(TEST_FORMAT_PREFIX) ? 1 : 0) != 0);
            if (prefix.equals(OAI_DC_PREFIX)) {
                OAIDriverImplTest.assertEquals((String)uri, (String)OAI_DC_URI);
                OAIDriverImplTest.assertEquals((String)loc, (String)OAI_DC_LOC);
                continue;
            }
            OAIDriverImplTest.assertEquals((String)uri, (String)TEST_FORMAT_URI);
            OAIDriverImplTest.assertEquals((String)loc, (String)TEST_FORMAT_LOC);
        }
    }

    public void testSets() throws Exception {
        RemoteIterator<? extends SetInfo> iter = this.m_impl.listSetInfo();
        while (iter.hasNext()) {
            SetInfo info = (SetInfo)iter.next();
            String spec = info.getSetSpec();
            System.out.println("Set spec = " + spec);
            OAIDriverImplTest.assertTrue((spec.equals(ABOVE_TWO_SPEC) || spec.equals(ABOVE_TWO_EVEN_SPEC) || spec.equals(ABOVE_TWO_ODD_SPEC) || spec.equals(PRIME_SPEC) ? 1 : 0) != 0);
            StringWriter writer = new StringWriter();
            info.write(new PrintWriter((Writer)writer, true));
            System.out.println("Result of write: \n" + writer.toString());
        }
    }

    public void testRecords() throws Exception {
        Date fromDate = null;
        Date untilDate = this.m_impl.getLatestDate();
        System.out.println("Listing all oai_dc records");
        RemoteIterator<? extends Record> iter = this.m_impl.listRecords(fromDate, untilDate, OAI_DC_PREFIX);
        this.checkRecords(iter, new int[]{1, 2, 3, 4});
        System.out.println("Listing all test_form records");
        iter = this.m_impl.listRecords(fromDate, untilDate, TEST_FORMAT_PREFIX);
        this.checkRecords(iter, new int[]{1, 2, 3});
        untilDate = new Date();
        untilDate.setTime(1L);
        System.out.println("Listing zero oai_dc records");
        iter = this.m_impl.listRecords(fromDate, untilDate, OAI_DC_PREFIX);
        this.checkRecords(iter, new int[0]);
        System.out.println("Listing zero test_form records");
        iter = this.m_impl.listRecords(fromDate, untilDate, TEST_FORMAT_PREFIX);
        this.checkRecords(iter, new int[0]);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        fromDate = df.parse("2005-01-01T08:52:20Z");
        untilDate = new Date();
        untilDate.setTime(fromDate.getTime() + 1000L);
        System.out.println("Listing one oai_dc record");
        iter = this.m_impl.listRecords(fromDate, untilDate, OAI_DC_PREFIX);
        this.checkRecords(iter, new int[]{2});
        System.out.println("Listing one test_format record");
        iter = this.m_impl.listRecords(fromDate, untilDate, TEST_FORMAT_PREFIX);
        this.checkRecords(iter, new int[]{2});
        System.out.println("Listing zero unknown_format records");
        iter = this.m_impl.listRecords(fromDate, untilDate, "unknown_format");
        this.checkRecords(iter, new int[0]);
    }

    public void checkRecords(Iterator<? extends Record> iter, int[] expecting) throws Exception {
        boolean[] saw = new boolean[expecting.length];
        while (iter.hasNext()) {
            Record rec = iter.next();
            String id = rec.getItemID();
            System.out.println("  Found Record with itemID = " + id);
            int n = Integer.parseInt(id.substring(id.length() - 1));
            boolean wasExpected = false;
            for (int i = 0; i < expecting.length; ++i) {
                if (n != expecting[i]) continue;
                saw[i] = true;
                wasExpected = true;
            }
            OAIDriverImplTest.assertTrue((boolean)wasExpected);
            StringWriter writer = new StringWriter();
            ((Writable)((Object)rec)).write(new PrintWriter((Writer)writer, true));
            System.out.println("Result of write: \n" + writer.toString());
        }
        for (int i = 0; i < saw.length; ++i) {
            OAIDriverImplTest.assertTrue((boolean)saw[i]);
        }
    }

    public void tearDown() {
        this.m_impl.close();
    }

    public OAIDriverImplTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(OAIDriverImplTest.class);
    }
}

