/*
 * Decompiled with CFR 0.152.
 */
package proai.util;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class DBUtil {
    public static String getLongString(ResultSet rs, int pos) throws SQLException {
        String s = rs.getString(pos);
        if (s != null) {
            return s;
        }
        try {
            Clob c = rs.getClob(pos);
            return c.getSubString(1L, (int)c.length());
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
    }

    public static String quotedString(String in, boolean backslashIsEscape) {
        StringBuffer out = new StringBuffer();
        out.append('\'');
        if (in == null) {
            out.append("null");
        } else {
            for (int i = 0; i < in.length(); ++i) {
                char c = in.charAt(i);
                if (c == '\'') {
                    out.append("''");
                    continue;
                }
                if (backslashIsEscape && c == '\\') {
                    out.append("\\\\");
                    continue;
                }
                out.append(c);
            }
        }
        out.append('\'');
        return out.toString();
    }
}

