/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.Administrator;
import fedora.client.BatchOutput;
import fedora.client.BatchThread;
import fedora.common.Constants;
import fedora.swing.mdi.MDIDesktopPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class BatchBuildIngestGUI
extends JInternalFrame
implements Constants {
    private static final long serialVersionUID = 1L;
    private final JTextField m_templateField = new JTextField("", 10);
    private final JTextField m_specsField = new JTextField("", 10);
    private final JTextField m_objectsField = new JTextField("", 10);
    private final JTextField m_pidsField = new JTextField("", 10);
    private final JRadioButton m_xmlMap = new JRadioButton("xml");
    private final JRadioButton m_textMap = new JRadioButton("text");
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JRadioButton m_foxmlMap = new JRadioButton("foxml");
    private final JRadioButton m_metsMap = new JRadioButton("mets");
    private final ButtonGroup templateButtonGroup = new ButtonGroup();
    private Dimension unitDimension = null;
    private Dimension browseMin = null;
    private Dimension browsePref = null;
    private Dimension browseMax = null;
    private Dimension textMin = null;
    private Dimension textPref = null;
    private Dimension textMax = null;
    private Dimension okMin = null;
    private Dimension okPref = null;
    private Dimension okMax = null;
    private static HashMap<String, String> formatMap = new HashMap();
    private MDIDesktopPane mdiDesktopPane = null;
    BatchOutput batchOutput = new BatchOutput("Batch Build and Ingest Output");
    private final String host;
    private final String port;
    private final String user;
    private final String pass;

    public BatchBuildIngestGUI(JFrame parent, MDIDesktopPane mdiDesktopPane, String host, int port, String user, String pass) {
        super("Batch Build and Ingest", true, true, true, true);
        int[] temp;
        this.host = host;
        this.port = Integer.toString(port);
        this.user = user;
        this.pass = pass;
        formatMap.put(BatchBuildIngestGUI.FOXML1_1.uri, "FOXML");
        formatMap.put(BatchBuildIngestGUI.METS_EXT1_1.uri, "METS");
        this.mdiDesktopPane = mdiDesktopPane;
        JButton btn = new JButton("Build and Ingest this batch");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchBuildIngestGUI.this.buildBatch();
            }
        });
        JPanel entryPanel = new JPanel();
        entryPanel.setLayout(new BorderLayout());
        entryPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        entryPanel.add((Component)new JLabel("Build and Ingest Criteria"), "North");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 3));
        Graphics graphicsTemp = parent.getGraphics();
        FontMetrics fmTemp = graphicsTemp.getFontMetrics();
        int maxWidth = 0;
        for (int element : temp = fmTemp.getWidths()) {
            if (element <= maxWidth) continue;
            maxWidth = element;
        }
        this.unitDimension = new Dimension(new Float(1.5 * (double)maxWidth).intValue(), fmTemp.getHeight());
        this.browseMin = new Dimension(12 * this.unitDimension.width, this.unitDimension.height);
        this.browseMax = new Dimension(2 * this.browseMin.width, 2 * this.browseMin.height);
        this.browsePref = this.browseMin;
        this.textMin = new Dimension(22 * this.unitDimension.width, this.unitDimension.height);
        this.textMax = new Dimension(2 * this.textMin.width, 2 * this.textMin.height);
        this.textPref = this.textMin;
        this.okMin = new Dimension(9 * this.unitDimension.width, this.unitDimension.height);
        this.okPref = this.okMax = new Dimension(new Float(1.5 * (double)this.okMin.width).intValue(), new Float(1.5 * (double)this.okMin.height).intValue());
        labelPanel.add(new JLabel("Object template (input file)"));
        labelPanel.add(this.sized(this.m_templateField, this.textMin, this.textPref, this.textMax));
        JButton templateBtn = new JButton("browse...");
        templateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchBuildIngestGUI.this.templateAction();
            }
        });
        labelPanel.add(this.sized(templateBtn, this.browseMin, this.browsePref, this.browseMax));
        labelPanel.add(new JLabel("XML specs (input directory)"));
        labelPanel.add(this.sized(this.m_specsField, this.textMin, this.textPref, this.textMax));
        JButton specsBtn = new JButton("browse...");
        specsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchBuildIngestGUI.this.specsAction();
            }
        });
        labelPanel.add(this.sized(specsBtn, this.browseMin, this.browsePref, this.browseMax));
        labelPanel.add(new JLabel("Fedora objects (output directory)"));
        labelPanel.add(this.sized(this.m_objectsField, this.textMin, this.textPref, this.textMax));
        JButton objectsBtn = new JButton("browse...");
        objectsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchBuildIngestGUI.this.objectsAction();
            }
        });
        labelPanel.add(this.sized(objectsBtn, this.browseMin, this.browsePref, this.browseMax));
        this.buttonGroup.add(this.m_xmlMap);
        this.m_xmlMap.setSelected(true);
        this.buttonGroup.add(this.m_textMap);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_xmlMap, "West");
        jPanel.add((Component)new JLabel("object processing map (output file)"), "North");
        jPanel.add((Component)this.m_textMap, "Center");
        labelPanel.add(this.sized(jPanel, this.browseMin, this.browsePref, this.browseMax));
        labelPanel.add(this.sized(this.m_pidsField, this.textMin, this.textPref, this.textMax));
        JButton pidsBtn = new JButton("browse...");
        pidsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BatchBuildIngestGUI.this.pidsAction();
            }
        });
        labelPanel.add(this.sized(pidsBtn, this.browseMin, this.browsePref, this.browseMax));
        entryPanel.add((Component)labelPanel, "West");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)entryPanel, "Center");
        this.getContentPane().add((Component)this.sized(btn, this.okMin, this.okPref, this.okMax, true), "South");
        this.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/New16.gif")));
        this.pack();
        this.setSize(this.getSize().width + 20, this.getSize().height * 2);
    }

    private final void sizeIt(JComponent jc, Dimension min, Dimension pref, Dimension max) {
        jc.setMinimumSize(min);
        jc.setPreferredSize(pref);
        jc.setMaximumSize(max);
    }

    private final Box sized(JComponent jc, Dimension min, Dimension pref, Dimension max, boolean centered) {
        this.sizeIt(jc, min, pref, max);
        Box box = Box.createHorizontalBox();
        if (centered) {
            box.add(Box.createGlue());
        }
        box.add(jc);
        if (centered) {
            box.add(Box.createGlue());
        }
        return box;
    }

    private final Box sized(JComponent jc, Dimension min, Dimension pref, Dimension max) {
        return this.sized(jc, min, pref, max, false);
    }

    public void buildBatch() {
        block11: {
            try {
                String line;
                if (this.m_templateField.getText().equals("") || this.m_specsField.getText().equals("") || this.m_objectsField.getText().equals("") || this.m_pidsField.getText().equals("")) break block11;
                Properties properties = new Properties();
                properties.setProperty("merge-objects", "yes");
                properties.setProperty("ingest", "yes");
                properties.setProperty("template", this.m_templateField.getText());
                properties.setProperty("specifics", this.m_specsField.getText());
                properties.setProperty("objects", this.m_objectsField.getText());
                properties.setProperty("ingested-pids", this.m_pidsField.getText());
                properties.setProperty("pids-format", this.m_xmlMap.isSelected() ? "xml" : "text");
                properties.setProperty("server-fqdn", this.host);
                properties.setProperty("server-port", this.port);
                properties.setProperty("username", this.user);
                properties.setProperty("password", this.pass);
                properties.setProperty("server-protocol", Administrator.getProtocol());
                BufferedReader br = new BufferedReader(new FileReader(this.m_templateField.getText()));
                String objectFormat = null;
                while ((line = br.readLine()) != null) {
                    if (line.indexOf("<foxml:") != -1) {
                        objectFormat = BatchBuildIngestGUI.FOXML1_1.uri;
                        break;
                    }
                    if (line.indexOf("<METS:") == -1) continue;
                    objectFormat = BatchBuildIngestGUI.METS_EXT1_1.uri;
                    break;
                }
                br.close();
                br = null;
                if (objectFormat == null) {
                    JOptionPane.showMessageDialog(Administrator.getDesktop(), "Template object file format not recognized as either \"" + BatchBuildIngestGUI.FOXML1_1.uri + "\" or \"" + BatchBuildIngestGUI.METS_EXT1_1.uri + "\".\n" + "Please verify contents of template file.", "Unknown Object Format", 0);
                    throw new Exception("Unknown object format in template file.");
                }
                properties.setProperty("object-format", objectFormat);
                int n = JOptionPane.showConfirmDialog(Administrator.getDesktop(), "Based on template, generated objects will be in " + formatMap.get(objectFormat) + " format. Is this correct?", "Generated Object Format", 1);
                if (n != 0) break block11;
                this.batchOutput.setDirectoryPath(properties.getProperty("ingested-pids"));
                try {
                    this.mdiDesktopPane.add(this.batchOutput);
                }
                catch (Exception eee) {
                    this.mdiDesktopPane.add(this.batchOutput);
                }
                try {
                    this.batchOutput.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    System.err.println("BatchBuildIngestGUI frame select vetoed " + e.getMessage());
                }
                BatchThread batchThread = null;
                try {
                    batchThread = new BatchThread(this.batchOutput, this.batchOutput.getJTextArea(), "Building and Ingesting Batch . . .");
                }
                catch (Exception e) {
                    System.err.println("BatchBuildIngestGUI couldn't instantiate BatchThread " + e.getMessage());
                }
                batchThread.setProperties(properties);
                batchThread.start();
            }
            catch (Exception e) {
                System.err.println("BatchBuildIngestGUI general error " + e.getMessage());
            }
        }
    }

    protected File selectFile(File lastDir, boolean directoriesOnly) throws Exception {
        int returnVal;
        File selection = null;
        JFileChooser browse = Administrator.batchtoolLastDir == null ? new JFileChooser() : new JFileChooser(Administrator.batchtoolLastDir);
        if (directoriesOnly) {
            browse.setFileSelectionMode(1);
        }
        if ((returnVal = browse.showOpenDialog(this)) == 0) {
            selection = browse.getSelectedFile();
            Administrator.batchtoolLastDir = selection.getParentFile();
        }
        return selection;
    }

    protected void templateAction() {
        try {
            File temp = this.selectFile(Administrator.batchtoolLastDir, false);
            if (temp != null) {
                this.m_templateField.setText(temp.getPath());
            }
        }
        catch (Exception e) {
            this.m_templateField.setText("");
        }
    }

    protected void specsAction() {
        try {
            File temp = this.selectFile(Administrator.batchtoolLastDir, true);
            if (temp != null) {
                this.m_specsField.setText(temp.getPath());
            }
        }
        catch (Exception e) {
            this.m_specsField.setText("");
        }
    }

    protected void objectsAction() {
        try {
            File temp = this.selectFile(Administrator.batchtoolLastDir, true);
            if (temp != null) {
                this.m_objectsField.setText(temp.getPath());
            }
        }
        catch (Exception e) {
            this.m_objectsField.setText("");
        }
    }

    protected void pidsAction() {
        try {
            FileDialog dlg = new FileDialog((Frame)Administrator.INSTANCE, "PIDs Output File", 1);
            if (Administrator.batchtoolLastDir != null) {
                dlg.setDirectory(Administrator.batchtoolLastDir.getPath());
            }
            dlg.setVisible(true);
            String temp = dlg.getFile();
            if (temp != null) {
                File dir = new File(dlg.getDirectory());
                this.m_pidsField.setText(new File(dir, temp).getPath());
                Administrator.batchtoolLastDir = dir;
            }
        }
        catch (Exception e) {
            this.m_pidsField.setText("");
        }
    }
}

