/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.FedoraClient;
import fedora.client.Uploader;
import fedora.client.batch.BatchModifyParser;
import fedora.client.batch.BatchModifyValidator;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.utilities.StreamUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import javax.xml.rpc.ServiceException;

public class AutoModify {
    private static String s_rootName = null;
    private static PrintStream s_log = null;
    private static FedoraAPIM s_APIM = null;
    private static FedoraAPIA s_APIA = null;
    private static Uploader s_UPLOADER = null;
    public static FedoraAPIA APIA = null;
    public static FedoraAPIM APIM = null;

    public AutoModify(FedoraAPIA apia, FedoraAPIM apim, String protocol, String host, int port, String user, String pass) throws MalformedURLException, ServiceException, IOException {
        s_APIM = apim;
        s_APIA = apia;
        s_UPLOADER = new Uploader(protocol, host, port, user, pass);
    }

    public void modify(String directivesFilePath, String logFilePath, boolean isValidateOnly) {
        AutoModify.modify(s_APIM, s_UPLOADER, s_APIA, directivesFilePath, logFilePath, isValidateOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void modify(FedoraAPIM APIM, Uploader UPLOADER, FedoraAPIA APIA, String directivesFilePath, String logFilePath, boolean isValidateOnly) {
        block37: {
            long et;
            long st;
            BatchModifyValidator bmv;
            BatchModifyParser bmp;
            FileInputStream in;
            block36: {
                in = null;
                bmp = null;
                bmv = null;
                st = System.currentTimeMillis();
                et = 0L;
                in = new FileInputStream(directivesFilePath);
                if (isValidateOnly) {
                    AutoModify.openLog(logFilePath, "validate-modify-directives");
                    bmv = new BatchModifyValidator(in, s_log);
                    break block36;
                }
                AutoModify.openLog(logFilePath, "modify-batch");
                bmp = new BatchModifyParser(UPLOADER, APIM, APIA, in, s_log);
            }
            Object var15_11 = null;
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (s_log != null) {
                    et = System.currentTimeMillis();
                    if (bmp != null) {
                        if (bmp.getFailedCount() == -1) {
                            System.out.println("\n\n" + bmp.getSucceededCount() + " modify directives successfully processed.\n" + "Parser error encountered.\n" + "An unknown number of modify directives were not processed.\n" + "See log file for details of those directives processed before the error.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                            s_log.println("  <summary>");
                            s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n" + "    Parser error encountered.\n" + "    An unknown number of modify directives were not processed.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                            s_log.println("  </summary>");
                        } else {
                            System.out.println("\n\n" + bmp.getSucceededCount() + " modify directives successfully processed.\n" + bmp.getFailedCount() + " modify directives failed.\n" + "See log file for details.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                            s_log.println("  <summary>");
                            s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n    " + bmp.getFailedCount() + " modify directives failed.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                            s_log.println("  </summary>");
                        }
                    } else if (bmv != null) {
                        et = System.currentTimeMillis();
                        if (bmv.isValid()) {
                            System.out.println("Modify Directives File in \n" + directivesFilePath + "\n is Valid !" + "\nTime elapsed: " + AutoModify.getDuration(et - st));
                            s_log.println("  <summary>");
                            s_log.println("    Modify Directives File: \n    " + directivesFilePath + "\n    is Valid !" + "\n    Time elapsed: " + AutoModify.getDuration(et - st));
                            s_log.println("  </summary>");
                        } else {
                            System.out.println(bmv.getErrorCount() + " XML validation Errors found in Modify Directives file.\n" + "See log file for details.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                            s_log.println("  <summary>");
                            s_log.println("    " + StreamUtility.enc(bmv.getErrorCount() + " XML validation Errors found in Modify Directives file.\n" + "    See log file for details.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                            s_log.println("  </summary>");
                        }
                    }
                    AutoModify.closeLog();
                    System.out.println("A detailed log file was created at\n" + logFilePath + "\n\n");
                }
                break block37;
            }
            catch (Exception e2) {
                System.out.println(e2.getClass().getName() + " - " + (e2.getMessage() == null ? "(no detail provided)" : e2.getMessage()));
            }
            break block37;
            {
                catch (Exception e) {
                    System.out.println(e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
                    Object var15_12 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        if (s_log != null) {
                            et = System.currentTimeMillis();
                            if (bmp != null) {
                                if (bmp.getFailedCount() == -1) {
                                    System.out.println("\n\n" + bmp.getSucceededCount() + " modify directives successfully processed.\n" + "Parser error encountered.\n" + "An unknown number of modify directives were not processed.\n" + "See log file for details of those directives processed before the error.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                                    s_log.println("  <summary>");
                                    s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n" + "    Parser error encountered.\n" + "    An unknown number of modify directives were not processed.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                                    s_log.println("  </summary>");
                                } else {
                                    System.out.println("\n\n" + bmp.getSucceededCount() + " modify directives successfully processed.\n" + bmp.getFailedCount() + " modify directives failed.\n" + "See log file for details.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                                    s_log.println("  <summary>");
                                    s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n    " + bmp.getFailedCount() + " modify directives failed.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                                    s_log.println("  </summary>");
                                }
                            } else if (bmv != null) {
                                et = System.currentTimeMillis();
                                if (bmv.isValid()) {
                                    System.out.println("Modify Directives File in \n" + directivesFilePath + "\n is Valid !" + "\nTime elapsed: " + AutoModify.getDuration(et - st));
                                    s_log.println("  <summary>");
                                    s_log.println("    Modify Directives File: \n    " + directivesFilePath + "\n    is Valid !" + "\n    Time elapsed: " + AutoModify.getDuration(et - st));
                                    s_log.println("  </summary>");
                                } else {
                                    System.out.println(bmv.getErrorCount() + " XML validation Errors found in Modify Directives file.\n" + "See log file for details.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                                    s_log.println("  <summary>");
                                    s_log.println("    " + StreamUtility.enc(bmv.getErrorCount() + " XML validation Errors found in Modify Directives file.\n" + "    See log file for details.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                                    s_log.println("  </summary>");
                                }
                            }
                            AutoModify.closeLog();
                            System.out.println("A detailed log file was created at\n" + logFilePath + "\n\n");
                        }
                        break block37;
                    }
                    catch (Exception e2) {
                        System.out.println(e2.getClass().getName() + " - " + (e2.getMessage() == null ? "(no detail provided)" : e2.getMessage()));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_13 = null;
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    if (s_log != null) {
                        et = System.currentTimeMillis();
                        if (bmp != null) {
                            if (bmp.getFailedCount() == -1) {
                                System.out.println("\n\n" + bmp.getSucceededCount() + " modify directives successfully processed.\n" + "Parser error encountered.\n" + "An unknown number of modify directives were not processed.\n" + "See log file for details of those directives processed before the error.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                                s_log.println("  <summary>");
                                s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n" + "    Parser error encountered.\n" + "    An unknown number of modify directives were not processed.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                                s_log.println("  </summary>");
                            } else {
                                System.out.println("\n\n" + bmp.getSucceededCount() + " modify directives successfully processed.\n" + bmp.getFailedCount() + " modify directives failed.\n" + "See log file for details.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                                s_log.println("  <summary>");
                                s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n    " + bmp.getFailedCount() + " modify directives failed.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                                s_log.println("  </summary>");
                            }
                        } else if (bmv != null) {
                            et = System.currentTimeMillis();
                            if (bmv.isValid()) {
                                System.out.println("Modify Directives File in \n" + directivesFilePath + "\n is Valid !" + "\nTime elapsed: " + AutoModify.getDuration(et - st));
                                s_log.println("  <summary>");
                                s_log.println("    Modify Directives File: \n    " + directivesFilePath + "\n    is Valid !" + "\n    Time elapsed: " + AutoModify.getDuration(et - st));
                                s_log.println("  </summary>");
                            } else {
                                System.out.println(bmv.getErrorCount() + " XML validation Errors found in Modify Directives file.\n" + "See log file for details.\n" + "Time elapsed: " + AutoModify.getDuration(et - st));
                                s_log.println("  <summary>");
                                s_log.println("    " + StreamUtility.enc(bmv.getErrorCount() + " XML validation Errors found in Modify Directives file.\n" + "    See log file for details.\n" + "    Time elapsed: " + AutoModify.getDuration(et - st)));
                                s_log.println("  </summary>");
                            }
                        }
                        AutoModify.closeLog();
                        System.out.println("A detailed log file was created at\n" + logFilePath + "\n\n");
                    }
                }
                catch (Exception e2) {
                    System.out.println(e2.getClass().getName() + " - " + (e2.getMessage() == null ? "(no detail provided)" : e2.getMessage()));
                }
                throw throwable;
            }
        }
    }

    private static String getDuration(long millis) {
        long tsec = millis / 1000L;
        long h = tsec / 60L / 60L;
        long m = (tsec - h * 60L * 60L) / 60L;
        long s = tsec - h * 60L * 60L - m * 60L;
        StringBuffer out = new StringBuffer();
        if (h > 0L) {
            out.append(h + " hour");
            if (h > 1L) {
                out.append('s');
            }
        }
        if (m > 0L) {
            if (h > 0L) {
                out.append(", ");
            }
            out.append(m + " minute");
            if (m > 1L) {
                out.append('s');
            }
        }
        if (s > 0L || h == 0L && m == 0L) {
            if (h > 0L || m > 0L) {
                out.append(", ");
            }
            out.append(s + " second");
            if (s != 1L) {
                out.append('s');
            }
        }
        return out.toString();
    }

    private static void openLog(String outFile, String rootName) throws Exception {
        s_rootName = rootName;
        s_log = new PrintStream((OutputStream)new FileOutputStream(outFile), true, "UTF-8");
        s_log.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        s_log.println("<" + s_rootName + ">");
    }

    private static void closeLog() throws Exception {
        s_log.println("</" + s_rootName + ">");
        s_log.close();
        s_log = null;
    }

    public static void showUsage(String errMessage) {
        System.out.println("Error: " + errMessage);
        System.out.println("");
        System.out.println("Usage: AutoModify host:port username password directives-filepath log-filepath protocol [validate-only-option]");
        System.out.println("Note: protocol must be either http or https.");
    }

    public static void main(String[] args) {
        String logFilePath = null;
        String directivesFilePath = null;
        String protocol = null;
        String hostName = null;
        String username = null;
        String password = null;
        int portNum = 0;
        boolean isValidateOnly = true;
        try {
            if (args.length < 6 || args.length > 7) {
                AutoModify.showUsage("You must provide either 6 or 7 arguments.");
            } else {
                String[] hostPort = args[0].split(":");
                if (hostPort.length != 2) {
                    AutoModify.showUsage("First argument must contain target Fedora server hostname and port using the syntax \"hostname:port\"");
                }
                hostName = hostPort[0];
                portNum = Integer.parseInt(hostPort[1]);
                username = args[1];
                password = args[2];
                directivesFilePath = args[3];
                logFilePath = args[4];
                protocol = args[5];
                isValidateOnly = args.length != 6;
                if (new File(directivesFilePath).exists()) {
                    System.out.println("\nCONNECTING to Fedora server....");
                    String baseURL = protocol + "://" + hostName + ":" + portNum + "/fedora";
                    FedoraClient fc = new FedoraClient(baseURL, username, password);
                    APIA = fc.getAPIA();
                    APIM = fc.getAPIM();
                    AutoModify am = new AutoModify(APIA, APIM, protocol, hostName, portNum, username, password);
                    if (isValidateOnly) {
                        System.out.println("\n----- VALIDATING DIRECTIVES FILE ONLY -----\n");
                    } else {
                        System.out.println("\n----- PROCESSING DIRECTIVES FILE -----\n");
                    }
                    am.modify(directivesFilePath, logFilePath, isValidateOnly);
                } else {
                    AutoModify.showUsage("Directives input file does not exist: " + directivesFilePath + " .");
                }
            }
        }
        catch (Exception e) {
            AutoModify.showUsage(e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
        }
    }
}

