/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.FedoraClient;
import fedora.client.batch.BatchTool;
import fedora.client.utility.ingest.AutoIngestor;
import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class BatchIngest
implements Constants {
    String protocol = null;
    String host = null;
    int port = 0;
    String username;
    String password;
    FedoraAPIA APIA;
    FedoraAPIM APIM;
    String objectsPath = null;
    String pidsPath = null;
    String pidsFormat = null;
    String objectFormat = null;
    private Hashtable<String, String> pidMaps = null;
    private Vector<String> keys = null;

    BatchIngest(Properties optValues) throws Exception {
        this.objectsPath = optValues.getProperty("objects");
        this.pidsPath = optValues.getProperty("ingested-pids");
        this.pidsFormat = optValues.getProperty("pids-format");
        this.protocol = optValues.getProperty("server-protocol");
        this.host = optValues.getProperty("server-fqdn");
        String serverPortAsString = optValues.getProperty("server-port");
        this.username = optValues.getProperty("username");
        this.password = optValues.getProperty("password");
        this.objectFormat = optValues.getProperty("object-format");
        if (!BatchTool.argOK(this.objectsPath)) {
            System.err.println("objectsPath required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.pidsPath)) {
            System.err.println("pidsPath required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.pidsFormat)) {
            System.err.println("pids-format required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.host)) {
            System.err.println("server-fqdn required");
            throw new Exception();
        }
        if (!BatchTool.argOK(serverPortAsString)) {
            System.err.println("server-port required");
            throw new Exception();
        }
        this.port = Integer.parseInt(serverPortAsString);
        if (!BatchTool.argOK(this.username)) {
            System.err.println("username required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.password)) {
            System.err.println("password required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.objectFormat)) {
            System.err.println("template format required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.protocol)) {
            System.err.println("server protocol required");
            throw new Exception();
        }
        String baseURL = this.protocol + "://" + this.host + ":" + this.port + "/fedora";
        FedoraClient fc = new FedoraClient(baseURL, this.username, this.password);
        this.APIA = fc.getAPIA();
        this.APIM = fc.getAPIM();
    }

    final void prep() throws Exception {
    }

    Hashtable getPidMaps() {
        return this.pidMaps;
    }

    Vector getKeys() {
        return this.keys;
    }

    final void process() throws Exception {
        this.pidMaps = new Hashtable();
        this.keys = new Vector();
        AutoIngestor autoIngestor = new AutoIngestor(this.APIA, this.APIM);
        File[] files = null;
        File batchDirectory = new File(this.objectsPath);
        files = batchDirectory.listFiles();
        if (!this.pidsFormat.equals("xml") && !this.pidsFormat.equals("text")) {
            System.err.println("bad pidsFormat: " + this.pidsFormat);
        } else if (!this.objectFormat.equals(BatchIngest.FOXML1_1.uri) && !this.objectFormat.equals(BatchIngest.METS_EXT1_1.uri)) {
            System.err.println("bad objectFormat: " + this.objectFormat);
        } else {
            int badFileCount = 0;
            int succeededIngestCount = 0;
            int failedIngestCount = 0;
            String logMessage = "another fedora object";
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) {
                    ++badFileCount;
                    System.err.println("batch directory contains unexpected directory or file: " + files[i].getName());
                    continue;
                }
                String pid = null;
                try {
                    pid = autoIngestor.ingestAndCommit(new FileInputStream(files[i]), this.objectFormat, logMessage);
                }
                catch (Exception e) {
                    System.err.println("ingest failed for: " + files[i].getName());
                    System.err.println("\t" + e.getClass().getName());
                    System.err.println("\t" + e.getMessage());
                    System.err.println("ingest format specified was: \"" + this.objectFormat + "\"");
                    System.err.println("===BATCH HAS FAILED===");
                    System.err.println("consider manually backing out any objects which were already successfully ingested in this batch");
                    throw e;
                }
                if (pid == null || pid.equals("")) {
                    ++failedIngestCount;
                    System.err.println("ingest failed for: " + files[i].getName());
                    continue;
                }
                ++succeededIngestCount;
                System.out.println("ingest succeeded for: " + files[i].getName());
                this.keys.add(files[i].getName());
                this.pidMaps.put(files[i].getName(), pid);
            }
            System.err.println("\nBatch Ingest Summary");
            System.err.println("\n" + (succeededIngestCount + failedIngestCount + badFileCount) + " files processed in this batch");
            System.err.println("\t" + succeededIngestCount + " objects successfully ingested into Fedora");
            System.err.println("\t" + failedIngestCount + " objects failed");
            System.err.println("\t" + badFileCount + " unexpected files in directory");
            System.err.println("\t" + (files.length - (succeededIngestCount + failedIngestCount + badFileCount)) + " files ignored after error");
        }
    }

    public static final void main(String[] args) {
        try {
            Properties miscProperties = new Properties();
            miscProperties.load(new FileInputStream("c:\\batchdemo\\batchtool.properties"));
            BatchIngest batchIngest = new BatchIngest(miscProperties);
            batchIngest.prep();
            batchIngest.process();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

