/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.Administrator;
import fedora.client.batch.BatchModifyParser;
import fedora.common.Constants;
import fedora.server.utilities.StreamUtility;
import java.awt.Font;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BatchModify {
    private static String s_rootName = null;
    private static String s_logPath = null;
    private static PrintStream s_log = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BatchModify() {
        block24: {
            long et;
            long st;
            BatchModifyParser bmp;
            InputStream in;
            block23: {
                in = null;
                bmp = null;
                File file = null;
                st = System.currentTimeMillis();
                et = 0L;
                JFileChooser browse = new JFileChooser(Administrator.getLastDir());
                browse.setFileSelectionMode(2);
                int returnVal = browse.showOpenDialog(Administrator.getDesktop());
                if (returnVal != 0) break block23;
                file = browse.getSelectedFile();
                int n = JOptionPane.showConfirmDialog(Administrator.getDesktop(), "Process modify directives in file: \n" + file.getAbsolutePath() + " ?\n", "Run Batch Modify?", 0);
                if (n != 0) break block23;
                Administrator.setLastDir(file);
                BatchModify.openLog("modify-batch");
                in = new FileInputStream(file);
                bmp = new BatchModifyParser(Administrator.UPLOADER, Administrator.APIM, Administrator.APIA, in, s_log);
            }
            Object var12_10 = null;
            try {
                if (in != null) {
                    in.close();
                }
                if (s_log == null || bmp == null) break block24;
                et = System.currentTimeMillis();
                if (bmp.getFailedCount() == -1) {
                    JOptionPane.showMessageDialog(Administrator.getDesktop(), bmp.getSucceededCount() + " Modify Directives successfully processed.\n" + "Parser Error.\n" + "An Unknown number of Modify Directives were not processed.\n" + "See log file for details of how many directives were\n" + "processed before the fatal error occurred.\n" + "Time elapsed: " + BatchModify.getDuration(et - st));
                    s_log.println("  <summary>");
                    s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n" + "    Parser error encountered.\n" + "    An unknown number of modify directives were not processed.\n" + "    Time elapsed: " + BatchModify.getDuration(et - st)));
                    s_log.println("  </summary>");
                } else {
                    JOptionPane.showMessageDialog(Administrator.getDesktop(), bmp.getSucceededCount() + " modify directives successfully ingested.\n" + bmp.getFailedCount() + " modify directives failed.\n" + "See log file for details.\n" + "Time elapsed: " + BatchModify.getDuration(et - st));
                    s_log.println("  <summary>");
                    s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n    " + bmp.getFailedCount() + " modify directives failed.\n" + "    Time elapsed: " + BatchModify.getDuration(et - st)));
                    s_log.println("  </summary>");
                }
                BatchModify.closeLog();
                int n = JOptionPane.showConfirmDialog(Administrator.getDesktop(), "A detailed log file was created at\n" + s_logPath + "\n\n" + "View it now?", "View Modify Batch Log?", 0);
                if (n != 0) break block24;
                JTextArea textEditor = new JTextArea();
                ((JComponent)textEditor).setFont(new Font("monospaced", 0, 12));
                textEditor.setText(BatchModify.fileAsString(s_logPath));
                textEditor.setCaretPosition(0);
                textEditor.setEditable(false);
                JInternalFrame viewFrame = new JInternalFrame("Viewing " + s_logPath, true, true, true, true);
                viewFrame.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Edit16.gif")));
                viewFrame.getContentPane().add(new JScrollPane(textEditor));
                viewFrame.setSize(720, 520);
                viewFrame.setVisible(true);
                Administrator.getDesktop().add(viewFrame);
                s_log = null;
                try {
                    viewFrame.setSelected(true);
                    break block24;
                }
                catch (PropertyVetoException pve) {
                }
            }
            catch (Exception e2) {
                Administrator.showErrorDialog(Administrator.getDesktop(), "Error", e2.getClass().getName() + " - " + (e2.getMessage() == null ? "(no detail provided)" : e2.getMessage()), e2);
            }
            break block24;
            {
                catch (Exception e) {
                    Administrator.showErrorDialog(Administrator.getDesktop(), "Error in Parsing Directives File.", e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()), e);
                    Object var12_11 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (s_log == null || bmp == null) break block24;
                        et = System.currentTimeMillis();
                        if (bmp.getFailedCount() == -1) {
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), bmp.getSucceededCount() + " Modify Directives successfully processed.\n" + "Parser Error.\n" + "An Unknown number of Modify Directives were not processed.\n" + "See log file for details of how many directives were\n" + "processed before the fatal error occurred.\n" + "Time elapsed: " + BatchModify.getDuration(et - st));
                            s_log.println("  <summary>");
                            s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n" + "    Parser error encountered.\n" + "    An unknown number of modify directives were not processed.\n" + "    Time elapsed: " + BatchModify.getDuration(et - st)));
                            s_log.println("  </summary>");
                        } else {
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), bmp.getSucceededCount() + " modify directives successfully ingested.\n" + bmp.getFailedCount() + " modify directives failed.\n" + "See log file for details.\n" + "Time elapsed: " + BatchModify.getDuration(et - st));
                            s_log.println("  <summary>");
                            s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n    " + bmp.getFailedCount() + " modify directives failed.\n" + "    Time elapsed: " + BatchModify.getDuration(et - st)));
                            s_log.println("  </summary>");
                        }
                        BatchModify.closeLog();
                        int n = JOptionPane.showConfirmDialog(Administrator.getDesktop(), "A detailed log file was created at\n" + s_logPath + "\n\n" + "View it now?", "View Modify Batch Log?", 0);
                        if (n != 0) break block24;
                        JTextArea textEditor = new JTextArea();
                        ((JComponent)textEditor).setFont(new Font("monospaced", 0, 12));
                        textEditor.setText(BatchModify.fileAsString(s_logPath));
                        textEditor.setCaretPosition(0);
                        textEditor.setEditable(false);
                        JInternalFrame viewFrame = new JInternalFrame("Viewing " + s_logPath, true, true, true, true);
                        viewFrame.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Edit16.gif")));
                        viewFrame.getContentPane().add(new JScrollPane(textEditor));
                        viewFrame.setSize(720, 520);
                        viewFrame.setVisible(true);
                        Administrator.getDesktop().add(viewFrame);
                        s_log = null;
                        try {
                            viewFrame.setSelected(true);
                            break block24;
                        }
                        catch (PropertyVetoException pve) {
                        }
                    }
                    catch (Exception e2) {
                        Administrator.showErrorDialog(Administrator.getDesktop(), "Error", e2.getClass().getName() + " - " + (e2.getMessage() == null ? "(no detail provided)" : e2.getMessage()), e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (s_log != null && bmp != null) {
                        et = System.currentTimeMillis();
                        if (bmp.getFailedCount() == -1) {
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), bmp.getSucceededCount() + " Modify Directives successfully processed.\n" + "Parser Error.\n" + "An Unknown number of Modify Directives were not processed.\n" + "See log file for details of how many directives were\n" + "processed before the fatal error occurred.\n" + "Time elapsed: " + BatchModify.getDuration(et - st));
                            s_log.println("  <summary>");
                            s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n" + "    Parser error encountered.\n" + "    An unknown number of modify directives were not processed.\n" + "    Time elapsed: " + BatchModify.getDuration(et - st)));
                            s_log.println("  </summary>");
                        } else {
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), bmp.getSucceededCount() + " modify directives successfully ingested.\n" + bmp.getFailedCount() + " modify directives failed.\n" + "See log file for details.\n" + "Time elapsed: " + BatchModify.getDuration(et - st));
                            s_log.println("  <summary>");
                            s_log.println("    " + StreamUtility.enc(bmp.getSucceededCount() + " modify directives successfully processed.\n    " + bmp.getFailedCount() + " modify directives failed.\n" + "    Time elapsed: " + BatchModify.getDuration(et - st)));
                            s_log.println("  </summary>");
                        }
                        BatchModify.closeLog();
                        int n = JOptionPane.showConfirmDialog(Administrator.getDesktop(), "A detailed log file was created at\n" + s_logPath + "\n\n" + "View it now?", "View Modify Batch Log?", 0);
                        if (n == 0) {
                            JTextArea textEditor = new JTextArea();
                            ((JComponent)textEditor).setFont(new Font("monospaced", 0, 12));
                            textEditor.setText(BatchModify.fileAsString(s_logPath));
                            textEditor.setCaretPosition(0);
                            textEditor.setEditable(false);
                            JInternalFrame viewFrame = new JInternalFrame("Viewing " + s_logPath, true, true, true, true);
                            viewFrame.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Edit16.gif")));
                            viewFrame.getContentPane().add(new JScrollPane(textEditor));
                            viewFrame.setSize(720, 520);
                            viewFrame.setVisible(true);
                            Administrator.getDesktop().add(viewFrame);
                            s_log = null;
                            try {
                                viewFrame.setSelected(true);
                            }
                            catch (PropertyVetoException pve) {}
                        }
                    }
                }
                catch (Exception e2) {
                    Administrator.showErrorDialog(Administrator.getDesktop(), "Error", e2.getClass().getName() + " - " + (e2.getMessage() == null ? "(no detail provided)" : e2.getMessage()), e2);
                }
                throw throwable;
            }
        }
    }

    private static String getDuration(long millis) {
        long tsec = millis / 1000L;
        long h = tsec / 60L / 60L;
        long m = (tsec - h * 60L * 60L) / 60L;
        long s = tsec - h * 60L * 60L - m * 60L;
        StringBuffer out = new StringBuffer();
        if (h > 0L) {
            out.append(h + " hour");
            if (h > 1L) {
                out.append('s');
            }
        }
        if (m > 0L) {
            if (h > 0L) {
                out.append(", ");
            }
            out.append(m + " minute");
            if (m > 1L) {
                out.append('s');
            }
        }
        if (s > 0L || h == 0L && m == 0L) {
            if (h > 0L || m > 0L) {
                out.append(", ");
            }
            out.append(s + " second");
            if (s != 1L) {
                out.append('s');
            }
        }
        return out.toString();
    }

    private static void openLog(String rootName) throws Exception {
        File outFile;
        s_rootName = rootName;
        String fileName = s_rootName + "-" + System.currentTimeMillis() + ".xml";
        String fedoraHome = Constants.FEDORA_HOME;
        if (fedoraHome == null) {
            outFile = new File(fileName);
        } else {
            File logDir = new File(new File(new File(fedoraHome), "client"), "logs");
            if (!logDir.exists()) {
                logDir.mkdir();
            }
            outFile = new File(logDir, fileName);
        }
        s_logPath = outFile.getPath();
        s_log = new PrintStream((OutputStream)new FileOutputStream(outFile), true, "UTF-8");
        s_log.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        s_log.println("<" + s_rootName + ">");
    }

    private static void closeLog() throws Exception {
        s_log.println("</" + s_rootName + ">");
        s_log.close();
    }

    private static String fileAsString(String path) throws Exception {
        int ch;
        StringBuffer buffer = new StringBuffer();
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        BufferedReader in = new BufferedReader(isr);
        while ((ch = ((Reader)in).read()) > -1) {
            buffer.append((char)ch);
        }
        ((Reader)in).close();
        return buffer.toString();
    }
}

