/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.batch.BatchModifyValidatorErrorHandler;
import fedora.server.utilities.StreamUtility;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BatchModifyValidator
extends DefaultHandler {
    private static PrintStream out;
    private boolean isValid = false;
    private static int errorCount;

    public BatchModifyValidator(InputStream in, PrintStream out) throws Exception {
        BatchModifyValidator.out = out;
        errorCount = 0;
        XMLReader xmlReader = null;
        BatchModifyValidatorErrorHandler errorHandler = new BatchModifyValidatorErrorHandler(out);
        try {
            SAXParserFactory saxfactory = SAXParserFactory.newInstance();
            saxfactory.setValidating(true);
            SAXParser parser = saxfactory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            xmlReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            xmlReader.setErrorHandler(errorHandler);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
            BatchModifyValidator.logError(e, "(no detail provided.)");
            errorCount = BatchModifyValidatorErrorHandler.errorCount;
            if (errorCount == 0) {
                ++errorCount;
            }
            this.isValid = false;
        }
        try {
            xmlReader.parse(new InputSource(in));
            errorCount = BatchModifyValidatorErrorHandler.errorCount;
            if (BatchModifyValidatorErrorHandler.errorCount == 0) {
                this.isValid = true;
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
            BatchModifyValidator.logError(e, "(no detail provided.)");
            errorCount = BatchModifyValidatorErrorHandler.errorCount;
            this.isValid = false;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getErrorCount() {
        return errorCount;
    }

    private static void logError(Exception e, String msg) {
        out.println("  <parser-error>");
        if (e != null) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            out.println("    " + StreamUtility.enc(message));
        } else {
            out.println("    " + StreamUtility.enc(msg));
        }
        out.println("  </parser-error>");
    }

    public static void main(String[] args) {
        try {
            PrintStream log = new PrintStream(new FileOutputStream("c:\\zlogfile.txt"));
            FileInputStream file = new FileInputStream("c:\\fedora\\mellon\\dist\\client\\demo\\batch-demo\\modify-batch-directives.xml");
            BatchModifyValidator bmv = new BatchModifyValidator(file, log);
            ((InputStream)file).close();
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
        }
    }

    static {
        errorCount = 0;
    }
}

