/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import java.io.PrintStream;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BatchModifyValidatorErrorHandler
implements ErrorHandler {
    protected static int errorCount = 0;
    private static PrintStream out;

    public BatchModifyValidatorErrorHandler(PrintStream out) {
        BatchModifyValidatorErrorHandler.out = out;
        errorCount = 0;
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println("BatchModifyValidatorErrorHandler detected SAX WARNING: ");
        BatchModifyValidatorErrorHandler.logError(e);
    }

    public void error(SAXParseException e) throws SAXException {
        System.err.println("BatchModifyValidatorErrorHandler detected SAX ERROR: ");
        BatchModifyValidatorErrorHandler.logError(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.err.print("BatchModifyValidatorErrorHandler detected SAX FATAL ERROR:");
        BatchModifyValidatorErrorHandler.logError(e);
    }

    private static void printPubID(SAXParseException e) {
        if (e.getPublicId() != null) {
            System.err.print(e.getPublicId() + " ");
            out.println("    " + e.getPublicId() + " ");
        }
        if (e.getLineNumber() != -1) {
            System.err.println("[modify-directives-file] Parsing error at line: " + e.getLineNumber() + " column: " + e.getColumnNumber() + " ");
            out.println("    [modify-directives-file] Parsing error at line: " + e.getLineNumber() + " column: " + e.getColumnNumber() + " ");
        }
    }

    private static void printMsg(SAXParseException e) {
        System.err.println(e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
        out.println("    " + e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
    }

    private static void logError(SAXParseException e) {
        out.println("  <parser-error>");
        BatchModifyValidatorErrorHandler.printPubID(e);
        BatchModifyValidatorErrorHandler.printMsg(e);
        out.println("  </parser-error>");
        ++errorCount;
    }
}

