/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.batch.BatchTool;
import fedora.common.Constants;
import fedora.utilities.XmlTransformUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

class BatchXforms
implements Constants {
    private final HashMap<String, String> formatMap = new HashMap();
    private String additionsPath = null;
    private String objectsPath = null;
    private String xformPath = null;
    private String modelPath = null;
    private Transformer transformer = null;
    private boolean good2go = false;
    private Vector<String> keys = null;

    BatchXforms(Properties optValues) throws Exception {
        if (optValues.getProperty("object-format").equalsIgnoreCase(BatchXforms.FOXML1_1.uri)) {
            this.xformPath = Constants.FEDORA_HOME + "/client/lib/foxml-merge.xsl";
            this.formatMap.put("object-format", "FOXML");
        } else if (optValues.getProperty("object-format").equalsIgnoreCase(BatchXforms.METS_EXT1_1.uri)) {
            this.xformPath = Constants.FEDORA_HOME + "/client/lib/mets-merge.xsl";
            this.formatMap.put("object-format", "METS");
        } else {
            System.err.println("Unknown objectTemplate format: " + optValues.getProperty("object-format"));
            throw new Exception();
        }
        this.additionsPath = optValues.getProperty("specifics");
        this.objectsPath = optValues.getProperty("objects");
        this.modelPath = optValues.getProperty("template");
        if (!BatchTool.argOK(this.additionsPath)) {
            System.err.println("additionsPath required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.objectsPath)) {
            System.err.println("objectsPath required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.xformPath)) {
            System.err.println("xformPath required");
            throw new Exception();
        }
    }

    final void prep() throws Exception {
        this.good2go = true;
    }

    Vector getKeys() {
        return this.keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void process() throws TransformerConfigurationException, Exception {
        TransformerFactory tfactory = XmlTransformUtility.getTransformerFactory();
        this.keys = new Vector();
        if (this.good2go) {
            File file4catch = null;
            int files4catch = 0;
            int badFileCount = 0;
            int succeededBuildCount = 0;
            int failedBuildCount = 0;
            try {
                File[] files = null;
                File additionsDirectory = new File(this.additionsPath);
                files = additionsDirectory.listFiles();
                files4catch = files.length;
                for (int i = 0; i < files.length; ++i) {
                    file4catch = files[i];
                    if (!files[i].isFile()) {
                        ++badFileCount;
                        System.err.println("additions directory contains unexpected directory or file: " + files[i].getName());
                        continue;
                    }
                    File f = new File(this.xformPath);
                    StreamSource ss = new StreamSource(f);
                    this.transformer = tfactory.newTransformer(ss);
                    URI uri = files[i].toURI();
                    String temp = uri.toString();
                    this.transformer.setParameter("subfilepath", temp);
                    FileInputStream fis = new FileInputStream(this.modelPath);
                    FileOutputStream fos = new FileOutputStream(this.objectsPath + File.separator + files[i].getName());
                    try {
                        this.transform(fis, fos);
                        ++succeededBuildCount;
                        this.keys.add(files[i].getName());
                        continue;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        fis.close();
                        fos.close();
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Fedora " + this.formatMap.get("object-format") + " XML failed for " + file4catch.getName());
                System.err.println("exception: " + e.getMessage() + " , class is " + e.getClass());
                ++failedBuildCount;
            }
            System.err.println("\nBatch Build Summary");
            System.err.println("\n" + (succeededBuildCount + failedBuildCount + badFileCount) + " files processed in this batch");
            System.err.println("\t" + succeededBuildCount + " Fedora " + this.formatMap.get("object-format") + " XML documents successfully created");
            System.err.println("\t" + failedBuildCount + " Fedora " + this.formatMap.get("object-format") + " XML documents failed");
            System.err.println("\t" + badFileCount + " unexpected files in directory");
            System.err.println("\t" + (files4catch - (succeededBuildCount + failedBuildCount + badFileCount)) + " files ignored after error");
        }
    }

    public static final void main(String[] args) {
        try {
            Properties miscProperties = new Properties();
            miscProperties.load(new FileInputStream("c:\\batchdemo\\batchtool.properties"));
            BatchXforms batchXforms = new BatchXforms(miscProperties);
            batchXforms.prep();
            batchXforms.process();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void transform(InputStream sourceStream, OutputStream destStream) throws TransformerException, TransformerConfigurationException {
        this.transformer.transform(new StreamSource(sourceStream), new StreamResult(destStream));
    }
}

