/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.console;

import fedora.client.console.Console;
import fedora.client.console.ConsoleCommand;
import fedora.client.console.InputPanel;
import fedora.client.console.InputPanelFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConsoleCommandInvoker
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ConsoleCommand m_command;
    private final Console m_console;
    private final InputPanel[] m_inputPanels;

    public ConsoleCommandInvoker(ConsoleCommand command, Console console) {
        this.m_command = command;
        this.m_console = console;
        this.setLayout(new BoxLayout(this, 1));
        JLabel commandNameLabel = new JLabel("Command: " + this.m_command.getName());
        JPanel jeez = new JPanel();
        jeez.setLayout(new BorderLayout());
        jeez.add((Component)commandNameLabel, "West");
        this.add(jeez);
        Class[] types = command.getParameterTypes();
        String[] names = command.getParameterNames();
        this.m_inputPanels = new InputPanel[types.length];
        for (int i = 0; i < types.length; ++i) {
            JPanel typeNameInputPanel = new JPanel();
            typeNameInputPanel.setLayout(new BorderLayout());
            typeNameInputPanel.add((Component)new JLabel(names[i] + " (" + command.getUnqualifiedName(types[i]) + ") : "), "West");
            this.m_inputPanels[i] = InputPanelFactory.getPanel(types[i]);
            typeNameInputPanel.add(this.m_inputPanels[i]);
            this.add(typeNameInputPanel);
        }
        JLabel returnTypeLabel = new JLabel("Returns: " + this.m_command.getUnqualifiedName(this.m_command.getReturnType()));
        JPanel jeez2 = new JPanel();
        jeez2.setLayout(new BorderLayout());
        jeez2.add((Component)returnTypeLabel, "West");
        this.add(jeez2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        try {
            String duration;
            this.m_console.setBusy(true);
            this.m_console.print("Invoking " + this.m_command.toString() + "\n");
            Object[] parameters = new Object[this.m_command.getParameterTypes().length];
            if (this.m_command.getParameterTypes().length > 0) {
                for (int i = 0; i < this.m_command.getParameterTypes().length; ++i) {
                    Object paramValue;
                    this.m_console.print(this.m_command.getParameterNames()[i]);
                    this.m_console.print("=");
                    parameters[i] = paramValue = this.m_inputPanels[i].getValue();
                    if (paramValue == null) {
                        this.m_console.print("<null>");
                    } else {
                        this.m_console.print(this.stringify(paramValue));
                    }
                    this.m_console.print("\n");
                }
            }
            long startms = new Date().getTime();
            Object returned = this.m_command.invoke(this.m_console.getInvocationTarget(this.m_command), parameters);
            long endms = new Date().getTime();
            long totalms = endms - startms;
            if (returned != null) {
                this.m_console.print("Returned: " + this.stringify(returned) + "\n");
            } else if (this.m_command.getReturnType() == null) {
                this.m_console.print("Returned.\n");
            } else {
                this.m_console.print("Returned: <null>\n");
            }
            if (totalms == 0L) {
                duration = "< 0.001 seconds.";
            } else {
                double secs = (double)totalms / 1000.0;
                duration = secs + " seconds.";
            }
            this.m_console.print("Roundtrip time: ");
            this.m_console.print(duration);
            this.m_console.print("\n");
        }
        catch (InvocationTargetException ite) {
            this.m_console.print("ERROR (" + ite.getTargetException().getClass().getName() + ") : " + ite.getTargetException().getMessage() + "\n");
        }
        catch (Throwable th) {
            this.m_console.print("ERROR (" + th.getClass().getName() + ") : " + th.getMessage() + "\n");
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter(sw));
            this.m_console.print(sw.toString());
        }
        finally {
            this.m_console.setBusy(false);
        }
    }

    private String stringify(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        String nm = obj.getClass().getName();
        if (nm.startsWith("[L")) {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            for (int i = 0; i < Array.getLength(obj); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(Array.get(obj, i).toString());
            }
            buf.append("}");
            return buf.toString();
        }
        return obj.toString();
    }
}

