/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class DemoObjectConverter {
    private static String fromProtocol = null;
    private static String fromHostName = null;
    private static String fromPortNum = null;
    private static String toProtocol = null;
    private static String toHostName = null;
    private static String toPortNum = null;

    public DemoObjectConverter(String fromProtocol, String fromHostName, String fromPortNum, String toProtocol, String toHostName, String toPortNum, String fedoraHome) {
        DemoObjectConverter.toProtocol = toProtocol;
        DemoObjectConverter.toHostName = toHostName;
        DemoObjectConverter.toPortNum = toPortNum;
        DemoObjectConverter.fromProtocol = fromProtocol;
        DemoObjectConverter.fromHostName = fromHostName;
        DemoObjectConverter.fromPortNum = fromPortNum;
    }

    public static void convert(String fedoraHome) {
        File demoDir = new File(fedoraHome, "client/demo");
        if (demoDir.exists()) {
            DemoObjectConverter.getFiles(demoDir);
        } else {
            System.out.println("ERROR: Unable to locate Demo Object Directory: " + demoDir.toString());
        }
    }

    public static void getFiles(File dir) {
        File[] files;
        for (File element : files = dir.listFiles()) {
            if (element.isDirectory()) {
                DemoObjectConverter.getFiles(element);
                continue;
            }
            DemoObjectConverter.substitute(element);
        }
    }

    public static void substitute(File demoObject) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(demoObject));
            String tempFile = demoObject.toString() + "-temp";
            FileOutputStream os = new FileOutputStream(new File(tempFile));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, "UTF-8");
            String nextLine = "";
            String newUrlStart = toProtocol.equalsIgnoreCase("http") && (toPortNum.equals("") || toPortNum.equals("80")) ? "http://" + toHostName + "/" : (toProtocol.equalsIgnoreCase("https") && (toPortNum.equals("") || toPortNum.equals("443")) ? "https://" + toHostName + "/" : toProtocol + "://" + toHostName + ":" + toPortNum + "/");
            String a = fromProtocol + "://" + fromHostName;
            String fromURLStartNoPort = a + "/";
            String fromURLStartPort80 = a + ":80" + "/";
            String fromURLStartPort443 = a + ":443" + "/";
            String fromURLStartWithPort = a + ":" + fromPortNum + "/";
            if (fromProtocol.equalsIgnoreCase("http") && (fromPortNum.equals("") || fromPortNum.equals("80"))) {
                System.out.println("searching for " + fromURLStartNoPort);
                System.out.println("searching for " + fromURLStartPort80);
                System.out.println("replacing with " + newUrlStart);
            } else if (fromProtocol.equalsIgnoreCase("https") && (fromPortNum.equals("") || fromPortNum.equals("443"))) {
                System.out.println("searching for " + fromURLStartNoPort);
                System.out.println("searching for " + fromURLStartPort443);
                System.out.println("replacing with " + newUrlStart);
            } else {
                System.out.println("searching for " + fromURLStartWithPort);
                System.out.println("replacing with " + newUrlStart);
            }
            while (nextLine != null) {
                nextLine = in.readLine();
                if (nextLine == null) continue;
                if (fromProtocol.equalsIgnoreCase("http") && (fromPortNum.equals("") || fromPortNum.equals("80"))) {
                    nextLine = nextLine.replaceAll(fromURLStartNoPort, newUrlStart);
                    nextLine = nextLine.replaceAll(fromURLStartPort80, newUrlStart);
                } else if (fromProtocol.equalsIgnoreCase("https") && (fromPortNum.equals("") || fromPortNum.equals("443"))) {
                    nextLine = nextLine.replaceAll(fromURLStartNoPort, newUrlStart);
                    nextLine = nextLine.replaceAll(fromURLStartPort443, newUrlStart);
                } else {
                    nextLine = nextLine.replaceAll(fromURLStartWithPort, newUrlStart);
                }
                out.write(nextLine + "\n");
            }
            in.close();
            out.close();
            if (demoObject.delete()) {
                File file = new File(tempFile);
                if (!file.renameTo(demoObject)) {
                    System.out.println("ERROR: unable to rename file: " + demoObject);
                } else {
                    System.out.println("Replaced File: " + demoObject);
                }
            } else {
                System.out.println("ERROR: Unable to delete file: " + demoObject);
            }
        }
        catch (IOException ioe) {
            System.out.println("IO ERROR: " + ioe.getMessage());
        }
    }

    public static void showUsage(String errMessage) {
        System.out.println("Error: " + errMessage);
        System.out.println("");
        System.out.println("Usage: DemoObjectConverter fromProtocol fromHostName fromPortNum toProtocol toHostName toPortNum fedoraHome");
    }

    public static void main(String[] args) {
        try {
            if (args.length != 7) {
                DemoObjectConverter.showUsage("You must provide seven arguments.");
            } else {
                String fromProtocol = args[0];
                String fromHostName = args[1];
                String fromPortNum = args[2];
                String toProtocol = args[3];
                String toHostName = args[4];
                String toPortNum = args[5];
                String fedoraHome = args[6];
                DemoObjectConverter doc = new DemoObjectConverter(fromProtocol, fromHostName, fromPortNum, toProtocol, toHostName, toPortNum, fedoraHome);
                DemoObjectConverter.convert(fedoraHome);
            }
        }
        catch (Exception e) {
            DemoObjectConverter.showUsage(e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
        }
    }
}

