/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.Administrator;
import fedora.client.deployment.DCElementDialog;
import fedora.client.deployment.MethodsPane;
import fedora.client.deployment.ServiceDefinitionBuilder;
import fedora.client.deployment.ServiceDeploymentBuilder;
import fedora.client.deployment.data.DCElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class GeneralPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JInternalFrame parent;
    private JComboBox sDefPIDComboBox;
    private String sDefPID;
    protected JTextField bObjectPID;
    private JRadioButton rb_sysPID;
    private JRadioButton rb_retainPID;
    private final ButtonGroup rb_buttonGroup = new ButtonGroup();
    protected String rb_chosen;
    private JTextField bObjectLabel;
    private JTextField bObjectName;
    private JTable dcTable;
    protected DefaultTableModel dcTableModel;
    protected DCElementDialog dcDialog;
    private boolean editDCMode = false;
    protected String[] sDefOptions = new String[0];

    public GeneralPane(ServiceDeploymentBuilder parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(2, 1));
        topPanel.add(this.setDescriptionPanel());
        topPanel.add(this.setContractPanel());
        this.add((Component)topPanel, "North");
        this.add((Component)this.setDCPanel(), "Center");
        this.setVisible(true);
    }

    public GeneralPane(ServiceDefinitionBuilder parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.add((Component)this.setDescriptionPanel(), "North");
        this.add((Component)this.setDCPanel(), "Center");
        this.setVisible(true);
    }

    private JPanel setDescriptionPanel() {
        PIDActionListener rb_listen = new PIDActionListener();
        this.rb_sysPID = new JRadioButton("system assigned", true);
        this.rb_sysPID.setActionCommand("sysPID");
        this.rb_sysPID.addActionListener(rb_listen);
        this.rb_chosen = "sysPID";
        this.rb_retainPID = new JRadioButton("use PID", false);
        this.rb_retainPID.setActionCommand("retainPID");
        this.rb_retainPID.addActionListener(rb_listen);
        this.rb_buttonGroup.add(this.rb_sysPID);
        this.rb_buttonGroup.add(this.rb_retainPID);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new GridBagLayout());
        descriptionPanel.setBorder(new TitledBorder("Service Deployment Description"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        descriptionPanel.add((Component)new JLabel("Service Object PID: "), gbc);
        gbc.gridx = 1;
        descriptionPanel.add((Component)this.rb_sysPID, gbc);
        gbc.gridx = 2;
        descriptionPanel.add((Component)this.rb_retainPID, gbc);
        gbc.gridx = 3;
        this.bObjectPID = new JTextField(10);
        descriptionPanel.add((Component)this.bObjectPID, gbc);
        this.bObjectPID.setToolTipText("The repository will accept test PIDs with the prefixes 'test:' or 'demo:' or a prefix you configured with your Fedora server. Examples PIDs are: 'demo:1', test:50, my-behaviors:75, myprefix:200");
        this.bObjectPID.setEnabled(false);
        gbc.gridy = 1;
        gbc.gridx = 0;
        descriptionPanel.add((Component)new JLabel("Service Object Name (1 word): "), gbc);
        gbc.gridx = 1;
        this.bObjectName = new JTextField(20);
        descriptionPanel.add((Component)this.bObjectName, gbc);
        this.bObjectName.setToolTipText("This one-word name will be used in metadata within the service object (e.g., in WSDL as the service name).");
        gbc.gridy = 2;
        gbc.gridx = 0;
        descriptionPanel.add((Component)new JLabel("Service Object Description: "), gbc);
        gbc.gridx = 1;
        this.bObjectLabel = new JTextField(20);
        descriptionPanel.add((Component)this.bObjectLabel, gbc);
        this.bObjectLabel.setToolTipText("This is a free-form textual description of theservice object.");
        gbc.gridy = 3;
        gbc.gridx = 0;
        descriptionPanel.add((Component)new JLabel(" "), gbc);
        return descriptionPanel;
    }

    private JPanel setContractPanel() {
        JPanel contractPanel = new JPanel();
        contractPanel.setLayout(new GridBagLayout());
        contractPanel.setBorder(new TitledBorder("Service Definition Contract"));
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridy = 0;
        gbc2.gridx = 0;
        contractPanel.add((Component)new JLabel("Service: "), gbc2);
        Map allSDefLabels = null;
        try {
            throw new UnsupportedOperationException("This operation uses obsolete field search semantics.");
        }
        catch (Exception e) {
            Administrator.showErrorDialog(Administrator.getDesktop(), "Contact system administrator.", e.getMessage() + "\nError getting service definitions from repository!", e);
            HashMap sDefLabels = new HashMap();
            for (String pid : allSDefLabels.keySet()) {
                sDefLabels.put(pid, allSDefLabels.get(pid));
            }
            this.sDefOptions = new String[sDefLabels.keySet().size() + 1];
            this.sDefOptions[0] = this.sDefOptions.length == 1 ? "No Service definitions in repository!" : "[Select a Service Definition]";
            Iterator iter = sDefLabels.keySet().iterator();
            int i = 1;
            while (iter.hasNext()) {
                String pid = (String)iter.next();
                String label = (String)sDefLabels.get(pid);
                this.sDefOptions[i++] = pid + " - " + label;
            }
            this.sDefPIDComboBox = new JComboBox<String>(this.sDefOptions);
            this.sDefPIDComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MethodsPane mp;
                    try {
                        String[] parts = ((String)GeneralPane.this.sDefPIDComboBox.getSelectedItem()).split(" - ");
                        if (parts.length == 1) {
                            GeneralPane.this.sDefPID = null;
                        } else {
                            GeneralPane.this.sDefPID = parts[0];
                        }
                    }
                    catch (Exception e) {
                        Administrator.showErrorDialog(Administrator.getDesktop(), "Error getting service definition", e.getMessage(), e);
                    }
                    if (GeneralPane.this.sDefPID != null) {
                        mp = (MethodsPane)((ServiceDeploymentBuilder)((GeneralPane)GeneralPane.this).parent).tabpane.getComponentAt(2);
                        mp.renderContractMethods(GeneralPane.this.sDefPID);
                    } else {
                        mp = (MethodsPane)((ServiceDeploymentBuilder)((GeneralPane)GeneralPane.this).parent).tabpane.getComponentAt(2);
                        mp.clearContractMethods();
                    }
                }
            });
            gbc2.gridx = 1;
            contractPanel.add((Component)this.sDefPIDComboBox, gbc2);
            return contractPanel;
        }
    }

    private JPanel setDCPanel() {
        this.dcTableModel = new DefaultTableModel();
        this.dcTable = new JTable(this.dcTableModel){
            private static final long serialVersionUID = 1L;

            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return vColIndex != 0;
            }
        };
        this.dcTable.setColumnSelectionAllowed(false);
        this.dcTable.setRowSelectionAllowed(true);
        this.dcTableModel.addColumn("Element Name");
        this.dcTableModel.addColumn("Value");
        this.dcTableModel.addRow(new Object[]{"title", ""});
        this.dcTableModel.addRow(new Object[]{"creator", ""});
        this.dcTableModel.addRow(new Object[]{"subject", ""});
        this.dcTableModel.addRow(new Object[]{"publisher", ""});
        this.dcTableModel.addRow(new Object[]{"description", ""});
        this.dcTableModel.addRow(new Object[]{"contributor", ""});
        this.dcTableModel.addRow(new Object[]{"date", ""});
        this.dcTableModel.addRow(new Object[]{"type", ""});
        this.dcTableModel.addRow(new Object[]{"format", ""});
        this.dcTableModel.addRow(new Object[]{"identifier", ""});
        this.dcTableModel.addRow(new Object[]{"source", ""});
        this.dcTableModel.addRow(new Object[]{"language", ""});
        this.dcTableModel.addRow(new Object[]{"relation", ""});
        this.dcTableModel.addRow(new Object[]{"coverage", ""});
        this.dcTableModel.addRow(new Object[]{"rights", ""});
        JScrollPane scrollpane = new JScrollPane(this.dcTable);
        scrollpane.getViewport().setBackground(Color.white);
        JButton jb1 = new JButton("Add");
        jb1.setMinimumSize(new Dimension(100, 30));
        jb1.setMaximumSize(new Dimension(100, 30));
        jb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneralPane.this.addDCElement();
            }
        });
        JButton jb2 = new JButton("Edit");
        jb2.setMinimumSize(new Dimension(100, 30));
        jb2.setMaximumSize(new Dimension(100, 30));
        jb2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneralPane.this.editDCElement();
            }
        });
        JButton jb3 = new JButton("Delete");
        jb3.setMinimumSize(new Dimension(100, 30));
        jb3.setMaximumSize(new Dimension(100, 30));
        jb3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneralPane.this.deleteDCElement();
            }
        });
        JPanel t_buttonPanel = new JPanel();
        t_buttonPanel.setLayout(new BoxLayout(t_buttonPanel, 1));
        t_buttonPanel.add(jb1);
        t_buttonPanel.add(jb2);
        t_buttonPanel.add(jb3);
        JPanel dcPanel = new JPanel(new BorderLayout());
        dcPanel.setBorder(new TitledBorder("Dublin Core Metadata"));
        dcPanel.add((Component)scrollpane, "Center");
        dcPanel.add((Component)t_buttonPanel, "East");
        return dcPanel;
    }

    public String getSDefContractPID() {
        if (this.parent.getClass().getName().equalsIgnoreCase(ServiceDeploymentBuilder.class.getName())) {
            return this.sDefPID;
        }
        return null;
    }

    public String getBObjectPID() {
        return this.bObjectPID.getText();
    }

    public String getBObjectLabel() {
        return this.bObjectLabel.getText();
    }

    public String getBObjectName() {
        String s = this.bObjectName.getText();
        StringTokenizer st = new StringTokenizer(s, " ", false);
        String nameNoSpaces = "";
        while (st.hasMoreElements()) {
            nameNoSpaces = nameNoSpaces + st.nextElement();
        }
        return nameNoSpaces;
    }

    public DCElement[] getDCElements() {
        if (this.dcTable.isEditing()) {
            this.dcTable.getCellEditor().stopCellEditing();
        }
        Vector<DCElement> elements = new Vector<DCElement>();
        int rowcount = this.dcTable.getModel().getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            DCElement dcElement = new DCElement();
            dcElement.elementName = (String)this.dcTable.getValueAt(i, 0);
            dcElement.elementValue = (String)this.dcTable.getValueAt(i, 1);
            if (dcElement.elementName == null || dcElement.elementName.trim().equals("") || dcElement.elementValue == null || dcElement.elementValue.trim().equals("")) continue;
            elements.add(dcElement);
        }
        return elements.toArray(new DCElement[0]);
    }

    public void setDCElement(String dcName, String dcValue) {
        if (this.editDCMode) {
            int currentRowIndex = this.dcTable.getSelectedRow();
            this.dcTable.setValueAt(dcName, currentRowIndex, 0);
            this.dcTable.setValueAt(dcValue, currentRowIndex, 1);
        } else {
            this.dcTableModel.addRow(new Object[]{dcName, dcValue});
        }
    }

    private void addDCElement() {
        this.dcDialog = new DCElementDialog(this, "Add DC Element", true);
    }

    private void editDCElement() {
        this.editDCMode = true;
        if (this.dcTable.isEditing()) {
            this.dcTable.getCellEditor().stopCellEditing();
        }
        int currentRowIndex = this.dcTable.getSelectedRow();
        this.dcDialog = new DCElementDialog(this, "Edit DC Element", true, (String)this.dcTable.getValueAt(currentRowIndex, 0), (String)this.dcTable.getValueAt(currentRowIndex, 1));
        this.editDCMode = false;
    }

    private void deleteDCElement() {
        this.dcTableModel.removeRow(this.dcTable.getSelectedRow());
    }

    protected void assertInvalidDCMsg(String msg) {
        JOptionPane.showMessageDialog(this, new String(msg), "Invalid DC Element", 1);
    }

    class PIDActionListener
    implements ActionListener {
        PIDActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GeneralPane.this.rb_chosen = GeneralPane.this.rb_buttonGroup.getSelection().getActionCommand();
            if (GeneralPane.this.rb_chosen.equalsIgnoreCase("retainPID")) {
                GeneralPane.this.bObjectPID.setEnabled(true);
            } else if (GeneralPane.this.rb_chosen.equalsIgnoreCase("sysPID")) {
                GeneralPane.this.bObjectPID.setEnabled(false);
                GeneralPane.this.bObjectPID.setText("");
            }
        }
    }
}

